/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.spawn;

import java.util.ArrayList;
import net.daveyx0.multimob.common.capabilities.CapabilityVariantEntity;
import net.daveyx0.multimob.common.capabilities.IVariantEntity;
import net.daveyx0.multimob.config.MMConfigSpawns;
import net.daveyx0.multimob.entity.EntityDummy;
import net.daveyx0.multimob.spawn.MMSpawnChecks;
import net.daveyx0.multimob.spawn.MMSpawnEntry;
import net.daveyx0.multimob.spawn.MMSpawnRegistry;
import net.daveyx0.multimob.spawn.MMWorldSpawner;
import net.daveyx0.multimob.util.EntityUtil;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.event.entity.living.LivingPackSizeEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class MMSpawnerEventHandler {
    private MMWorldSpawner worldSpawner = null;

    @SubscribeEvent
    public void onWorldTickEvent(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START || !(event.world instanceof WorldServer)) {
            return;
        }
        WorldServer worldServer = (WorldServer)event.world;
        if (MMConfigSpawns.getUseAdditionalSpawning()) {
            WorldInfo worldInfo;
            if (this.worldSpawner == null) {
                this.worldSpawner = new MMWorldSpawner();
            }
            if ((worldInfo = worldServer.func_72912_H()).func_82573_f() % (long)MMConfigSpawns.getSpawnTickDelay() == 0L) {
                this.worldSpawner.findChunksForSpawning(worldServer, worldServer.func_82736_K().func_82766_b("doMobSpawning"), true, true);
            }
        } else {
            this.worldSpawner = null;
        }
    }

    @SubscribeEvent
    public void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getSpawner() != null || event.getResult() == Event.Result.DENY) {
            return;
        }
        if (event.getEntity() instanceof EntityDummy) {
            event.setResult(Event.Result.DENY);
        }
        ArrayList<MMSpawnEntry> spawnEntries = new ArrayList<MMSpawnEntry>();
        for (MMSpawnEntry entry : MMSpawnRegistry.getSpawnEntries()) {
            if (!entry.getEntityClass().equals(event.getEntityLiving().getClass())) continue;
            spawnEntries.add(entry);
        }
        if (spawnEntries == null || spawnEntries.isEmpty()) {
            return;
        }
        MMSpawnEntry entry = (MMSpawnEntry)spawnEntries.get(event.getWorld().field_73012_v.nextInt(spawnEntries.size()));
        if (entry != null) {
            IVariantEntity variant;
            if (entry.getVariantID() != 0 && CapabilityVariantEntity.EventHandler.hasVariant(event.getEntity()) && (variant = EntityUtil.getCapability(event.getEntity(), CapabilityVariantEntity.VARIANT_ENTITY_CAPABILITY, null)) != null) {
                variant.setVariant(entry.getVariantID());
            }
            if (MMSpawnChecks.performSpawnChecks((WorldServer)event.getWorld(), new BlockPos((double)event.getX(), (double)event.getY(), (double)event.getZ()), entry)) {
                if (!entry.getOverrideCanGetSpawnHere()) {
                    event.setResult(Event.Result.DEFAULT);
                    return;
                }
                if (MMSpawnChecks.canEntitySpawnHere((Entity)event.getEntityLiving(), entry)) {
                    event.setResult(Event.Result.ALLOW);
                } else {
                    event.setResult(Event.Result.DENY);
                }
            } else {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onLivingPackSizeEvent(LivingPackSizeEvent event) {
        MMSpawnEntry entry = MMSpawnRegistry.getSpawnEntryFromEntityClass(event.getEntityLiving().getClass());
        if (entry != null && entry.getGroupSizeRange() != null && entry.getGroupSizeRange()[1] > 0) {
            event.setMaxPackSize(entry.getGroupSizeRange()[1]);
            event.setResult(Event.Result.ALLOW);
        }
    }

    public MMWorldSpawner getWorldSpawner() {
        return this.worldSpawner;
    }
}

