/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items.wrapper;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.minecraftforge.items.IItemHandlerModifiable;

public class RangedWrapper
implements IItemHandlerModifiable {
    private final IItemHandlerModifiable compose;
    private final int minSlot;
    private final int maxSlot;

    public RangedWrapper(IItemHandlerModifiable compose, int minSlot, int maxSlotExclusive) {
        Preconditions.checkArgument((maxSlotExclusive > minSlot ? 1 : 0) != 0, (Object)"Max slot must be greater than min slot");
        this.compose = compose;
        this.minSlot = minSlot;
        this.maxSlot = maxSlotExclusive;
    }

    @Override
    public int getSlots() {
        return this.maxSlot - this.minSlot;
    }

    @Override
    @Nonnull
    public aip getStackInSlot(int slot) {
        if (this.checkSlot(slot)) {
            return this.compose.getStackInSlot(slot + this.minSlot);
        }
        return aip.a;
    }

    @Override
    @Nonnull
    public aip insertItem(int slot, @Nonnull aip stack, boolean simulate) {
        if (this.checkSlot(slot)) {
            return this.compose.insertItem(slot + this.minSlot, stack, simulate);
        }
        return stack;
    }

    @Override
    @Nonnull
    public aip extractItem(int slot, int amount, boolean simulate) {
        if (this.checkSlot(slot)) {
            return this.compose.extractItem(slot + this.minSlot, amount, simulate);
        }
        return aip.a;
    }

    @Override
    public void setStackInSlot(int slot, @Nonnull aip stack) {
        if (this.checkSlot(slot)) {
            this.compose.setStackInSlot(slot + this.minSlot, stack);
        }
    }

    @Override
    public int getSlotLimit(int slot) {
        if (this.checkSlot(slot)) {
            return this.compose.getSlotLimit(slot + this.minSlot);
        }
        return 0;
    }

    @Override
    public boolean isItemValid(int slot, @Nonnull aip stack) {
        if (this.checkSlot(slot)) {
            return this.compose.isItemValid(slot + this.minSlot, stack);
        }
        return false;
    }

    private boolean checkSlot(int localSlot) {
        return localSlot + this.minSlot < this.maxSlot;
    }
}

