/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.fluid.FluidUtils;
import codechicken.lib.math.MathHelper;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.TMultiPart;
import codechicken.translocators.client.render.RenderTranslocator;
import codechicken.translocators.init.ModItems;
import codechicken.translocators.part.TranslocatorPart;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public class FluidTranslocatorPart
extends TranslocatorPart {
    public List<MovingLiquid> movingLiquids = new LinkedList<MovingLiquid>();
    public List<MovingLiquid> exitingLiquids = new LinkedList<MovingLiquid>();

    @Override
    public ItemStack getItem() {
        return new ItemStack((Item)ModItems.translocatorPart, 1, 1);
    }

    @Override
    public int getTType() {
        return 1;
    }

    public ResourceLocation getType() {
        return new ResourceLocation("translocators", "fluid_translocator");
    }

    @Override
    public boolean canStay() {
        BlockPos pos = this.pos().func_177972_a(EnumFacing.field_82609_l[this.side]);
        TileEntity tile = this.world().func_175625_s(pos);
        return tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.field_82609_l[this.side ^ 1]);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.world().field_72995_K) {
            Iterator<MovingLiquid> iterator = this.movingLiquids.iterator();
            while (iterator.hasNext()) {
                MovingLiquid m = iterator.next();
                if (!m.update()) continue;
                iterator.remove();
                this.exitingLiquids.add(m);
            }
            this.exitingLiquids.removeIf(MovingLiquid::update);
        } else if (this.a_eject) {
            IFluidHandler[] attached = new IFluidHandler[6];
            for (int i = 0; i < 6; ++i) {
                attached[i] = this.canInsert(i) || i == this.side ? FluidUtils.getFluidHandlerOrEmpty((IBlockAccess)this.world(), (BlockPos)this.pos().func_177972_a(EnumFacing.field_82609_l[i]), (int)(i ^ 1)) : EmptyFluidHandler.INSTANCE;
            }
            IFluidHandler myHandler = attached[this.side];
            FluidStack drain = myHandler.drain(this.fast ? 1000 : 100, false);
            if (drain != null && drain.amount != 0) {
                ArrayList<FluidTransfer> transfers = new ArrayList<FluidTransfer>();
                FluidStack move = drain.copy();
                this.spreadOutput(move, this.getOutputs(), attached, transfers);
                myHandler.drain(drain.amount - move.amount, true);
                this.sendTransferPacket(transfers);
            }
        }
    }

    private void spreadOutput(FluidStack move, int[] outputs, IFluidHandler[] attached, List<FluidTransfer> transfers) {
        for (int k = 0; k < outputs.length && move.amount > 0; ++k) {
            int dst = outputs[k];
            IFluidHandler outaccess = attached[dst];
            int fit = outaccess.fill(move, false);
            int spread = outputs.length - k;
            if ((fit = Math.min(fit, move.amount / spread + this.world().field_73012_v.nextInt(move.amount % spread + 1))) == 0) continue;
            FluidStack add = FluidUtils.copy((FluidStack)move, (int)fit);
            outaccess.fill(add, true);
            move.amount -= fit;
            transfers.add(new FluidTransfer(dst, add));
        }
    }

    public int[] getOutputs() {
        int[] att = new int[6];
        int[] r_att = new int[6];
        int a = 0;
        int r_a = 0;
        for (byte i = 0; i < 6; ++i) {
            FluidTranslocatorPart part;
            TMultiPart p = this.tile().partMap((int)i);
            if (!(p instanceof FluidTranslocatorPart) || (part = (FluidTranslocatorPart)p).canEject() || i == this.side) continue;
            if (part.redstone) {
                r_att[r_a++] = i;
                continue;
            }
            att[a++] = i;
        }
        int[] ret = new int[a + r_a];
        if (a > 0) {
            System.arraycopy(att, 0, ret, 0, a);
        }
        if (r_a > 0) {
            System.arraycopy(r_att, 0, ret, a, r_a);
        }
        return ret;
    }

    private void sendTransferPacket(List<FluidTransfer> transfers) {
        MCDataOutput stream = this.getIncStream();
        stream.writeByte(transfers.size());
        for (FluidTransfer t : transfers) {
            stream.writeByte(t.dst);
            stream.writeFluidStack(t.fluid);
        }
    }

    public List<MovingLiquid> getMovingLiquids() {
        LinkedList<MovingLiquid> liquids = new LinkedList<MovingLiquid>();
        liquids.addAll(this.movingLiquids);
        liquids.addAll(this.exitingLiquids);
        return liquids;
    }

    @Override
    public void readIncUpdate(MCDataInput packet) {
        ArrayList<FluidTransfer> transfers = new ArrayList<FluidTransfer>();
        HashSet<Integer> updatedDests = new HashSet<Integer>();
        int num_t = packet.readUByte();
        for (int i = 0; i < num_t; ++i) {
            short dst = packet.readUByte();
            FluidStack fluid = packet.readFluidStack();
            transfers.add(new FluidTransfer(dst, fluid));
            updatedDests.add(Integer.valueOf(dst));
        }
        for (FluidTransfer t : transfers) {
            boolean found = false;
            Iterator<MovingLiquid> iterator = this.movingLiquids.iterator();
            while (iterator.hasNext()) {
                MovingLiquid m = iterator.next();
                if (m.liquid.isFluidEqual(t.fluid) && m.dst == t.dst) {
                    m.addLiquid(t.fluid.amount);
                    found = true;
                    continue;
                }
                if (m.dst != t.dst || updatedDests.contains(m.dst)) continue;
                iterator.remove();
                m.finish();
                this.exitingLiquids.add(m);
            }
            if (found) continue;
            this.movingLiquids.add(new MovingLiquid(t.dst, t.fluid));
        }
    }

    @Override
    public void renderDynamic(Vector3 pos, int pass, float delta) {
        RenderTranslocator.renderFluid(this, pos, delta);
        super.renderDynamic(pos, pass, delta);
    }

    public class MovingLiquid {
        public int dst;
        public FluidStack liquid;
        public double a_start;
        public double b_start;
        public double a_end;
        public double b_end;
        public boolean fast;

        public MovingLiquid(int dst, FluidStack add) {
            this.dst = dst;
            this.liquid = add;
            this.fast = FluidTranslocatorPart.this.fast;
            this.capLiquid();
        }

        private void capLiquid() {
            this.liquid.amount = Math.min(this.liquid.amount, this.fast ? 1000 : 100);
        }

        public boolean update() {
            if (this.a_end == 1.0) {
                return true;
            }
            this.b_start = this.a_start;
            this.a_start = MathHelper.approachLinear((double)this.a_start, (double)1.0, (double)0.2);
            this.b_end = this.a_end;
            if (this.liquid.amount > 0) {
                this.liquid.amount = Math.max(this.liquid.amount - (this.fast ? 200 : 20), 0);
                return this.liquid.amount == 0;
            }
            this.a_end = MathHelper.approachLinear((double)this.a_end, (double)1.0, (double)0.2);
            return false;
        }

        public void addLiquid(int moving) {
            if (this.liquid.amount == 0) {
                throw new IllegalArgumentException("Something went wrong!");
            }
            this.liquid.amount += moving;
            this.fast = FluidTranslocatorPart.this.fast;
            this.capLiquid();
        }

        public void finish() {
            this.liquid.amount = 0;
        }
    }

    private class FluidTransfer {
        int dst;
        FluidStack fluid;

        public FluidTransfer(int dst, FluidStack fluid) {
            this.dst = dst;
            this.fluid = fluid;
        }
    }
}

