/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.client.models.handler;

import com.teamacronymcoders.base.IBaseMod;
import com.teamacronymcoders.base.client.models.IHasModel;
import com.teamacronymcoders.base.util.ItemStackUtils;
import com.teamacronymcoders.base.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelHandler {
    private ILogger logger;

    public ModelHandler(IBaseMod mod) {
        this.logger = mod.getLogger();
    }

    public void registerModels(IHasModel model) {
        ItemStack itemStack;
        ArrayList<ItemStack> allSubItems = new ArrayList<ItemStack>();
        model.getAllSubItems(allSubItems);
        int locationsIndex = 0;
        List<ModelResourceLocation> modelResourceLocations = model.getModelResourceLocations(new ArrayList<ModelResourceLocation>());
        if (!modelResourceLocations.isEmpty()) {
            for (ItemStack itemStack2 : allSubItems) {
                ModelResourceLocation modelResourceLocation = modelResourceLocations.get(locationsIndex);
                if (ItemStackUtils.isValid(itemStack2) && modelResourceLocation != null) {
                    ModelLoader.setCustomModelResourceLocation((Item)itemStack2.func_77973_b(), (int)itemStack2.func_77960_j(), (ModelResourceLocation)modelResourceLocation);
                    if (++locationsIndex < modelResourceLocations.size()) continue;
                    locationsIndex = 0;
                    continue;
                }
                this.logger.warning("Found IHasModel with Empty Itemstack or ResourceLocation");
            }
        } else if (!allSubItems.isEmpty() && !(itemStack = (ItemStack)allSubItems.get(0)).func_190926_b()) {
            this.logger.warning(itemStack.func_77977_a() + " has no models");
        } else {
            this.logger.warning("There's an issue with an IHasModel.");
        }
    }
}

