/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.client.models.sided;

import com.google.common.collect.ImmutableMap;
import com.teamacronymcoders.base.blocks.properties.SideType;
import com.teamacronymcoders.base.client.models.sided.ITextureNamer;
import com.teamacronymcoders.base.client.models.sided.ModelSidedBlock;
import com.teamacronymcoders.base.client.models.sided.SidedTypeRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;

public class ModelLoaderSidedBlock
implements ICustomModelLoader {
    private static ModelLoaderSidedBlock instance;
    private static final String RESOURCE_LOCATION = "models/block/side_type/";
    private Map<String, List<BakedQuad>> modelCache = new HashMap<String, List<BakedQuad>>();
    private List<String> domains = new ArrayList<String>();

    public static ModelLoaderSidedBlock getInstance() {
        if (instance == null) {
            instance = new ModelLoaderSidedBlock();
            ModelLoaderRegistry.registerLoader((ICustomModelLoader)instance);
        }
        return instance;
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        this.modelCache.clear();
    }

    public boolean accepts(@Nonnull ResourceLocation modelLocation) {
        return this.domains.contains(modelLocation.func_110624_b()) && modelLocation.func_110623_a().contains(RESOURCE_LOCATION);
    }

    @Nonnull
    public IModel loadModel(@Nonnull ResourceLocation modelLocation) {
        String resourcePath = modelLocation.func_110623_a();
        if (resourcePath.startsWith(RESOURCE_LOCATION)) {
            String sub = resourcePath.replaceFirst(RESOURCE_LOCATION, "");
            int firstSlash = sub.indexOf("/");
            String name = sub.substring(firstSlash + 1);
            String type = sub.substring(0, firstSlash);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ITextureNamer textureNamer = SidedTypeRegistry.getTextureNamer(type);
            for (EnumFacing f : EnumFacing.field_82609_l) {
                for (SideType cfg : SideType.values()) {
                    String key = f.func_176610_l() + "_" + cfg.func_176610_l();
                    String tex = name + "_" + textureNamer.getTextureName(f, cfg);
                    builder.put((Object)key, (Object)new ResourceLocation(modelLocation.func_110624_b(), "blocks/" + tex));
                }
            }
            return new ModelSidedBlock(name, type, (ImmutableMap<String, ResourceLocation>)builder.build());
        }
        return ModelLoaderRegistry.getMissingModel();
    }

    public void addDomain(String modid) {
        this.domains.add(modid);
    }

    public Map<String, List<BakedQuad>> getModelCache() {
        return this.modelCache;
    }
}

