/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.multiblock.rectangular;

import com.teamacronymcoders.base.multiblock.BlockFacings;
import com.teamacronymcoders.base.multiblock.MultiblockControllerBase;
import com.teamacronymcoders.base.multiblock.MultiblockTileEntityBase;
import com.teamacronymcoders.base.multiblock.rectangular.PartPosition;
import com.teamacronymcoders.base.multiblock.rectangular.RectangularMultiblockControllerBase;
import com.teamacronymcoders.base.multiblock.validation.IMultiblockValidator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public abstract class RectangularMultiblockTileEntityBase<T extends RectangularMultiblockControllerBase>
extends MultiblockTileEntityBase<T> {
    private PartPosition position = PartPosition.UNKNOWN;
    private BlockFacings outwardFacings = BlockFacings.NONE;

    @Nonnull
    public BlockFacings getOutwardsDir() {
        return this.outwardFacings;
    }

    @Nonnull
    public PartPosition getPartPosition() {
        return this.position;
    }

    @Nullable
    public EnumFacing getOutwardFacing() {
        BlockFacings out;
        EnumFacing facing;
        EnumFacing enumFacing = facing = null != this.position ? this.position.getFacing() : null;
        if (null == facing && !(out = this.getOutwardsDir()).none() && 1 == out.countFacesIf(true)) {
            facing = out.firstIf(true);
        }
        return facing;
    }

    @Nullable
    public EnumFacing getOutwardFacingFromWorldPosition() {
        BlockFacings facings = null;
        Object controller = this.getMultiblockController();
        if (null != controller) {
            BlockPos position = this.getWorldPosition();
            BlockPos min = ((MultiblockControllerBase)controller).getMinimumCoord();
            BlockPos max = ((MultiblockControllerBase)controller).getMaximumCoord();
            int x = position.func_177958_n();
            int y = position.func_177956_o();
            int z = position.func_177952_p();
            facings = BlockFacings.from(min.func_177956_o() == y, max.func_177956_o() == y, min.func_177952_p() == z, max.func_177952_p() == z, min.func_177958_n() == x, max.func_177958_n() == x);
        }
        return null != facings && !facings.none() && 1 == facings.countFacesIf(true) ? facings.firstIf(true) : null;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        super.onAttached(newController);
        this.recalculateOutwardsDirection(newController.getMinimumCoord(), newController.getMaximumCoord());
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        this.recalculateOutwardsDirection(controller.getMinimumCoord(), controller.getMaximumCoord());
    }

    @Override
    public void onMachineBroken() {
        this.position = PartPosition.UNKNOWN;
        this.outwardFacings = BlockFacings.NONE;
    }

    public void recalculateOutwardsDirection(BlockPos minCoord, BlockPos maxCoord) {
        BlockPos myPosition = this.func_174877_v();
        int myX = myPosition.func_177958_n();
        int myY = myPosition.func_177956_o();
        int myZ = myPosition.func_177952_p();
        int facesMatching = 0;
        boolean downFacing = myY == minCoord.func_177956_o();
        boolean upFacing = myY == maxCoord.func_177956_o();
        boolean northFacing = myZ == minCoord.func_177952_p();
        boolean southFacing = myZ == maxCoord.func_177952_p();
        boolean westFacing = myX == minCoord.func_177958_n();
        boolean eastFacing = myX == maxCoord.func_177958_n();
        this.outwardFacings = BlockFacings.from(downFacing, upFacing, northFacing, southFacing, westFacing, eastFacing);
        if (eastFacing || westFacing) {
            ++facesMatching;
        }
        if (upFacing || downFacing) {
            ++facesMatching;
        }
        if (southFacing || northFacing) {
            ++facesMatching;
        }
        if (facesMatching <= 0) {
            this.position = PartPosition.INTERIOR;
        } else if (facesMatching >= 3) {
            if (upFacing) {
                if (southFacing) {
                    if (eastFacing) {
                        this.position = PartPosition.FRAME_CORNER_SOUTH_EAST_TOP;
                    } else if (westFacing) {
                        this.position = PartPosition.FRAME_CORNER_SOUTH_WEST_TOP;
                    }
                } else if (northFacing) {
                    if (eastFacing) {
                        this.position = PartPosition.FRAME_CORNER_NORTH_EAST_TOP;
                    } else if (westFacing) {
                        this.position = PartPosition.FRAME_CORNER_NORTH_WEST_TOP;
                    }
                }
            } else if (downFacing) {
                if (southFacing) {
                    if (eastFacing) {
                        this.position = PartPosition.FRAME_CORNER_SOUTH_EAST_BOTTOM;
                    } else if (westFacing) {
                        this.position = PartPosition.FRAME_CORNER_SOUTH_WEST_BOTTOM;
                    }
                } else if (northFacing) {
                    if (eastFacing) {
                        this.position = PartPosition.FRAME_CORNER_NORTH_EAST_BOTTOM;
                    } else if (westFacing) {
                        this.position = PartPosition.FRAME_CORNER_NORTH_WEST_BOTTOM;
                    }
                }
            }
        } else if (facesMatching == 2) {
            if (!eastFacing && !westFacing) {
                if (upFacing) {
                    if (northFacing) {
                        this.position = PartPosition.FRAME_NORTH_TOP;
                    } else if (southFacing) {
                        this.position = PartPosition.FRAME_SOUTH_TOP;
                    }
                } else if (downFacing) {
                    if (northFacing) {
                        this.position = PartPosition.FRAME_NORTH_BOTTOM;
                    } else if (southFacing) {
                        this.position = PartPosition.FRAME_SOUTH_BOTTOM;
                    }
                }
            } else if (!southFacing && !northFacing) {
                if (upFacing) {
                    if (eastFacing) {
                        this.position = PartPosition.FRAME_EAST_TOP;
                    } else if (westFacing) {
                        this.position = PartPosition.FRAME_WEST_TOP;
                    }
                } else if (downFacing) {
                    if (eastFacing) {
                        this.position = PartPosition.FRAME_EAST_BOTTOM;
                    } else if (westFacing) {
                        this.position = PartPosition.FRAME_WEST_BOTTOM;
                    }
                }
            } else if (southFacing) {
                if (eastFacing) {
                    this.position = PartPosition.FRAME_VERTICAL_SOUTH_EAST;
                } else if (westFacing) {
                    this.position = PartPosition.FRAME_VERTICAL_SOUTH_WEST;
                }
            } else if (northFacing) {
                if (eastFacing) {
                    this.position = PartPosition.FRAME_VERTICAL_NORTH_EAST;
                } else if (westFacing) {
                    this.position = PartPosition.FRAME_VERTICAL_NORTH_WEST;
                }
            }
        } else {
            this.position = eastFacing ? PartPosition.EAST_FACE : (westFacing ? PartPosition.WEST_FACE : (southFacing ? PartPosition.SOUTH_FACE : (northFacing ? PartPosition.NORTH_FACE : (upFacing ? PartPosition.TOP_FACE : PartPosition.BOTTOM_FACE))));
        }
    }

    public abstract boolean isGoodForFrame(IMultiblockValidator var1);

    public abstract boolean isGoodForSides(IMultiblockValidator var1);

    public abstract boolean isGoodForTop(IMultiblockValidator var1);

    public abstract boolean isGoodForBottom(IMultiblockValidator var1);

    public abstract boolean isGoodForInterior(IMultiblockValidator var1);
}

