/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.tileentities;

import com.teamacronymcoders.base.tileentities.TileEntityBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityInventoryBase
extends TileEntityBase {
    private ItemStackHandler inventory;

    public TileEntityInventoryBase(int inventorySize) {
        this(new ItemStackHandler(inventorySize));
    }

    public TileEntityInventoryBase(ItemStackHandler inventory) {
        this.inventory = inventory;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    protected void readFromDisk(NBTTagCompound data) {
        this.inventory.deserializeNBT(data.func_74775_l("Items"));
    }

    @Override
    protected NBTTagCompound writeToDisk(NBTTagCompound data) {
        data.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        return data;
    }
}

