/*
 * Decompiled with CFR 0.152.
 */
package ftblag.stoneblockdimensions;

import ftblag.stoneblockdimensions.ResourceLocationMeta;
import ftblag.stoneblockdimensions.SBUConfig;
import ftblag.stoneblockdimensions.SBUTeleporter;
import ftblag.stoneblockdimensions.StoneBlockDimensions;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.StatList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="stoneblockdimensions")
public class SBUEvents {
    @SubscribeEvent
    public static void move(TickEvent.PlayerTickEvent e) {
        if (e.player.field_70170_p.field_72995_K || e.phase == TickEvent.Phase.END) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)e.player;
        if (player.field_71088_bW > 0) {
            return;
        }
        int dimFrom = player.field_70170_p.field_73011_w.getDimension();
        if (dimFrom == -1 && SBUConfig.disableNether || dimFrom == 1 && SBUConfig.disableNether) {
            SBUEvents.teleport(player, 0, 0, true);
        }
        if (dimFrom == 0) {
            if (player.field_70163_u >= (double)SBUConfig.overToMining) {
                SBUEvents.teleport(player, SBUConfig.dimIDMining, SBUConfig.overToMiningPosition, false);
                StoneBlockDimensions.log("Starting teleport Overworld -> Mining");
            }
        } else if (dimFrom == SBUConfig.dimIDMining) {
            if (player.field_70163_u <= (double)SBUConfig.miningToOver) {
                SBUEvents.teleport(player, 0, SBUConfig.miningToOverPosition, false);
                StoneBlockDimensions.log("Starting teleport Mining -> Overworld");
            } else if (player.field_70163_u >= (double)SBUConfig.miningToEnd) {
                SBUEvents.teleport(player, SBUConfig.dimIDEnd, SBUConfig.miningToEndPosition, false);
                StoneBlockDimensions.log("Starting teleport Mining -> End");
            }
        } else if (dimFrom == SBUConfig.dimIDEnd && player.field_70163_u <= (double)SBUConfig.endToMining) {
            SBUEvents.teleport(player, SBUConfig.dimIDMining, SBUConfig.endToMiningPosition, false);
            StoneBlockDimensions.log("Starting teleport End -> Mining");
        }
    }

    private static void teleport(EntityPlayerMP player, int dim, int y, boolean toSpawn) {
        if (player.func_147099_x().func_77444_a(StatList.field_188097_g) < SBUConfig.wait_time) {
            return;
        }
        if (!ForgeHooks.onTravelToDimension((Entity)player, (int)dim)) {
            return;
        }
        if (player.field_71088_bW > 0) {
            return;
        }
        WorldServer worldServer = player.field_71133_b.func_71218_a(dim);
        player.field_71088_bW = SBUConfig.tp_cooldown;
        player.changeDimension(dim, (ITeleporter)new SBUTeleporter(worldServer, toSpawn ? worldServer.func_180504_m() : new BlockPos(player.field_70165_t, (double)y, player.field_70161_v)));
        player.field_71088_bW = SBUConfig.tp_cooldown;
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equals("stoneblockdimensions")) {
            ConfigManager.sync((String)event.getModID(), (Config.Type)Config.Type.INSTANCE);
            ResourceLocationMeta.updateArrayList();
        }
    }

    @SubscribeEvent
    public static void teleport(EntityTravelToDimensionEvent e) {
        if (e.getDimension() == -1 && SBUConfig.disableNether || e.getDimension() == 1 && SBUConfig.disableEnd) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPortalCreate(BlockEvent.PortalSpawnEvent e) {
        if (SBUConfig.disableNether) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void respawn2(PlayerEvent.PlayerRespawnEvent e) {
        e.player.field_71088_bW = SBUConfig.tp_cooldown;
    }
}

