/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.thermalexpansion.recipehandler;

import cofh.thermalexpansion.block.machine.TileExtruder;
import cofh.thermalexpansion.util.managers.machine.ExtruderManager;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.IdentityHashMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.commoncapabilities.capability.recipehandler.TransformedRecipeHandlerAdapter;
import org.cyclops.commoncapabilities.modcompat.thermalexpansion.ThermalExpansionHelpers;

public class TileExtruderRecipeHandler
extends TransformedRecipeHandlerAdapter<ExtruderManager.ExtruderRecipe> {
    private final TileExtruder tile;

    public TileExtruderRecipeHandler(TileExtruder tile) {
        super(Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.FLUIDSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK}));
        this.tile = tile;
    }

    protected boolean isAugmentSedimentary() {
        try {
            return (Boolean)ThermalExpansionHelpers.FIELD_TILEEXTRUDER_AUGMENTSEDIMANTARY.get(this.tile);
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    @Override
    protected String getRecipeCacheKey() {
        return "thermalexpansion:extruder:" + this.isAugmentSedimentary();
    }

    @Override
    protected IRecipeDefinition transformRecipe(ExtruderManager.ExtruderRecipe recipe) {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        IdentityHashMap outputs = Maps.newIdentityHashMap();
        inputs.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new IPrototypedIngredientAlternatives[]{new PrototypedIngredientAlternativesList(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<FluidStack, Integer>(IngredientComponent.FLUIDSTACK, recipe.getInputCold(), 15)})), new PrototypedIngredientAlternativesList(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<FluidStack, Integer>(IngredientComponent.FLUIDSTACK, recipe.getInputHot(), 15)}))}));
        outputs.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{recipe.getOutput()}));
        return new RecipeDefinition(inputs, new MixedIngredients(outputs));
    }

    @Override
    protected ExtruderManager.ExtruderRecipe findRecipe(IMixedIngredients input) {
        FluidStack fluidStackCold = (FluidStack)Iterables.get(input.getInstances(IngredientComponent.FLUIDSTACK), (int)0, null);
        FluidStack fluidStackHot = (FluidStack)Iterables.get(input.getInstances(IngredientComponent.FLUIDSTACK), (int)1, null);
        for (ExtruderManager.ExtruderRecipe recipe : ExtruderManager.getRecipeList((boolean)this.isAugmentSedimentary())) {
            if (!recipe.getInputCold().equals((Object)fluidStackCold) || !recipe.getInputHot().equals((Object)fluidStackHot)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    protected Collection<ExtruderManager.ExtruderRecipe> getRecipesRaw() {
        return Lists.newArrayList((Object[])ExtruderManager.getRecipeList((boolean)this.isAugmentSedimentary()));
    }

    @Override
    public boolean isValidSizeInput(IngredientComponent<?, ?> component, int size) {
        return component == IngredientComponent.FLUIDSTACK && size == 2;
    }
}

