/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.energystorage;

import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.VanillaEntityItemFrameCapabilityDelegator;

public class VanillaEntityItemFrameEnergyStorage
extends VanillaEntityItemFrameCapabilityDelegator<IEnergyStorage>
implements IEnergyStorage {
    public VanillaEntityItemFrameEnergyStorage(EntityItemFrame entity, EnumFacing side) {
        super(entity, side);
    }

    @Override
    protected Capability<IEnergyStorage> getCapabilityType() {
        return CapabilityEnergy.ENERGY;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        ItemStack itemStack = this.getItemStack();
        IEnergyStorage energyStorage = (IEnergyStorage)this.getCapability(itemStack);
        if (energyStorage != null) {
            int ret = energyStorage.receiveEnergy(maxReceive, simulate);
            if (!simulate && ret > 0) {
                this.updateItemStack(itemStack);
            }
            return ret;
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        ItemStack itemStack = this.getItemStack();
        IEnergyStorage energyStorage = (IEnergyStorage)this.getCapability(itemStack);
        if (energyStorage != null) {
            int ret = energyStorage.extractEnergy(maxExtract, simulate);
            if (!simulate && ret > 0) {
                this.updateItemStack(itemStack);
            }
            return ret;
        }
        return 0;
    }

    public int getEnergyStored() {
        IEnergyStorage energyStorage = (IEnergyStorage)this.getCapability();
        if (energyStorage != null) {
            return energyStorage.getEnergyStored();
        }
        return 0;
    }

    public int getMaxEnergyStored() {
        IEnergyStorage energyStorage = (IEnergyStorage)this.getCapability();
        if (energyStorage != null) {
            return energyStorage.getMaxEnergyStored();
        }
        return 0;
    }

    public boolean canExtract() {
        IEnergyStorage energyStorage = (IEnergyStorage)this.getCapability();
        return energyStorage != null && energyStorage.canExtract();
    }

    public boolean canReceive() {
        IEnergyStorage energyStorage = (IEnergyStorage)this.getCapability();
        return energyStorage != null && energyStorage.canReceive();
    }
}

