/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import gnu.trove.set.TLongSet;
import java.beans.ConstructorProperties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.tuple.Pair;
import team.chisel.client.render.ModelChiselBlock;

public enum ModelCache {
    INSTANCE;

    private static final Cache<State, ModelChiselBlock> modelcache;
    private static final Cache<Pair<IBlockAccess, BlockPos>, State> statecache;

    @Nonnull
    ModelChiselBlock getModel(@Nonnull State state, @Nonnull Callable<ModelChiselBlock> loader) {
        return (ModelChiselBlock)((Object)modelcache.get((Object)state, loader));
    }

    @Nonnull
    State getState(IBlockAccess world, BlockPos pos, @Nonnull Callable<State> loader) {
        return (State)statecache.get((Object)Pair.of((Object)world, (Object)pos), loader);
    }

    static {
        modelcache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(500L).build();
        statecache = CacheBuilder.newBuilder().expireAfterWrite(100L, TimeUnit.MILLISECONDS).build();
    }

    static final class State {
        private final IBlockState cleanState;
        private final TLongSet serializedContext;

        public IBlockState getCleanState() {
            return this.cleanState;
        }

        public TLongSet getSerializedContext() {
            return this.serializedContext;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State other = (State)o;
            IBlockState this$cleanState = this.getCleanState();
            IBlockState other$cleanState = other.getCleanState();
            if (this$cleanState == null ? other$cleanState != null : !this$cleanState.equals(other$cleanState)) {
                return false;
            }
            TLongSet this$serializedContext = this.getSerializedContext();
            TLongSet other$serializedContext = other.getSerializedContext();
            return !(this$serializedContext == null ? other$serializedContext != null : !this$serializedContext.equals(other$serializedContext));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IBlockState $cleanState = this.getCleanState();
            result = result * 59 + ($cleanState == null ? 43 : $cleanState.hashCode());
            TLongSet $serializedContext = this.getSerializedContext();
            result = result * 59 + ($serializedContext == null ? 43 : $serializedContext.hashCode());
            return result;
        }

        public String toString() {
            return "ModelCache.State(cleanState=" + this.getCleanState() + ", serializedContext=" + this.getSerializedContext() + ")";
        }

        @ConstructorProperties(value={"cleanState", "serializedContext"})
        public State(IBlockState cleanState, TLongSet serializedContext) {
            this.cleanState = cleanState;
            this.serializedContext = serializedContext;
        }
    }
}

