/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.mmec.common.entity;

import java.util.List;
import me.ichun.mods.mmec.common.MightyEnderChicken;
import me.ichun.mods.mmec.common.entity.EntityEnderChicken;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityEggBomb
extends Entity {
    public static final DamageSource EGG = new DamageSource("egg_bomb").func_76348_h();
    public static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(EntityEggBomb.class, (DataSerializer)DataSerializers.field_187193_c);
    private BlockPos spawnPosition;
    public int maxLiveTime;
    public int liveTime;
    public int explodeTimer;
    public boolean exploded;
    public EntityLivingBase target;
    public boolean huntTarget;
    public boolean chaosType;
    public float lastScale = -1.0f;

    public EntityEggBomb(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.09f * this.getScale(), 0.09f * this.getScale());
        int min = Math.min(MightyEnderChicken.config.eggBombMinAge, MightyEnderChicken.config.eggBombMaxAge);
        int max = Math.max(MightyEnderChicken.config.eggBombMinAge, MightyEnderChicken.config.eggBombMaxAge);
        this.maxLiveTime = min + this.field_70170_p.field_73012_v.nextInt(max - min);
        this.liveTime = 0;
    }

    public EntityEggBomb(World worldIn, float scale, EntityLivingBase target, boolean huntTarget, boolean isChaos) {
        this(worldIn);
        this.setScale(scale);
        this.target = target;
        this.huntTarget = huntTarget;
        this.chaosType = isChaos;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(SCALE, (Object)Float.valueOf(10.0f));
    }

    public void setScale(float f) {
        this.func_184212_Q().func_187227_b(SCALE, (Object)Float.valueOf(f));
        this.func_70105_a(0.09f * f, 0.09f * f);
    }

    public float getScale() {
        return ((Float)this.func_184212_Q().func_187225_a(SCALE)).floatValue();
    }

    public void func_70071_h_() {
        float scale = this.getScale();
        if (this.lastScale != scale) {
            this.lastScale = scale;
            this.func_70105_a(0.09f * scale, 0.09f * scale);
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            double d2;
            double d1;
            double d0;
            double speed = (double)MightyEnderChicken.config.eggBombSpeed / 1000.0;
            if (this.huntTarget && this.target != null && this.liveTime > 20) {
                if (!this.target.func_70089_S()) {
                    this.explodeTimer = 5;
                }
                d0 = this.target.field_70165_t - this.field_70165_t;
                d1 = this.target.field_70163_u + (double)(this.target.field_70131_O / 2.0f) - this.field_70163_u;
                d2 = this.target.field_70161_v - this.field_70161_v;
                double dist = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2)) * 2.0f;
                this.field_70159_w = d0 / dist;
                this.field_70181_x = d1 / dist;
                this.field_70179_y = d2 / dist;
            } else {
                if (!(this.spawnPosition == null || this.field_70170_p.func_175623_d(this.spawnPosition) && this.spawnPosition.func_177956_o() >= 1)) {
                    this.spawnPosition = null;
                }
                if (this.spawnPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.spawnPosition.func_177954_c((double)((int)this.field_70165_t), (double)((int)this.field_70163_u), (double)((int)this.field_70161_v)) < 4.0) {
                    this.spawnPosition = new BlockPos((int)this.field_70165_t + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.field_70163_u + this.field_70146_Z.nextInt(6) - 2, (int)this.field_70161_v + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
                }
                d0 = (double)this.spawnPosition.func_177958_n() + 0.5 - this.field_70165_t;
                d1 = (double)this.spawnPosition.func_177956_o() + 0.1 - this.field_70163_u;
                d2 = (double)this.spawnPosition.func_177952_p() + 0.5 - this.field_70161_v;
                this.field_70159_w += (Math.signum(d0) * 0.5 - this.field_70159_w) * speed;
                this.field_70181_x += (Math.signum(d1) * (double)0.7f - this.field_70181_x) * speed;
                this.field_70179_y += (Math.signum(d2) * 0.5 - this.field_70179_y) * speed;
            }
            float f = (float)(MathHelper.func_181159_b((double)this.field_70179_y, (double)this.field_70159_w) * 57.29577951308232) - 90.0f;
            float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
            this.field_70177_z += f1;
            if (this.liveTime > 3) {
                Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
                RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
                vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
                if (raytraceresult != null) {
                    vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
                }
                Entity entity = null;
                List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
                double dd0 = 0.0;
                for (int i = 0; i < list.size(); ++i) {
                    double dd1;
                    AxisAlignedBB axisalignedbb;
                    RayTraceResult raytraceresult1;
                    Entity entity1 = (Entity)list.get(i);
                    if (!entity1.func_70067_L() || entity1 instanceof EntityEnderChicken || entity1 instanceof EntityEnderChicken.MultiPartEntityPartCustom || (raytraceresult1 = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(vec3d, vec3d1)) == null || !((dd1 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < dd0) && dd0 != 0.0) continue;
                    entity = entity1;
                    dd0 = dd1;
                }
                if (entity != null) {
                    raytraceresult = new RayTraceResult(entity);
                }
                if (raytraceresult != null && raytraceresult.field_72313_a != RayTraceResult.Type.MISS) {
                    this.explode();
                    return;
                }
            }
            ++this.liveTime;
            if (this.liveTime > this.maxLiveTime) {
                this.explode();
            }
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.explodeTimer > 0) {
            --this.explodeTimer;
            if (this.explodeTimer == 0) {
                this.explode();
            }
        }
    }

    public boolean func_184223_x(Entity entityIn) {
        if (entityIn instanceof EntityEnderChicken || entityIn instanceof EntityEnderChicken.MultiPartEntityPartCustom || entityIn instanceof EntityEggBomb) {
            return true;
        }
        return super.func_184223_x(entityIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.explodeTimer = 10;
        return true;
    }

    public void explode() {
        if (!this.exploded) {
            this.exploded = true;
            boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this);
            float size = 0.15f * this.getScale() * ((float)MightyEnderChicken.config.eggBombExplosionScale / 100.0f);
            double posYmid = this.field_70163_u + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) / 2.0;
            if (this.chaosType) {
                float f3 = size * 2.0f;
                int k1 = MathHelper.func_76128_c((double)(this.field_70165_t - (double)f3 - 1.0));
                int l1 = MathHelper.func_76128_c((double)(this.field_70165_t + (double)f3 + 1.0));
                int i2 = MathHelper.func_76128_c((double)(posYmid - (double)f3 - 1.0));
                int i1 = MathHelper.func_76128_c((double)(posYmid + (double)f3 + 1.0));
                int j2 = MathHelper.func_76128_c((double)(this.field_70161_v - (double)f3 - 1.0));
                int j1 = MathHelper.func_76128_c((double)(this.field_70161_v + (double)f3 + 1.0));
                List list = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
                for (int k2 = 0; k2 < list.size(); ++k2) {
                    double d12;
                    Entity entity = (Entity)list.get(k2);
                    if (entity.func_180427_aV() || entity instanceof EntityEnderChicken || !((d12 = entity.func_70011_f(this.field_70165_t, posYmid, this.field_70161_v) / (double)f3) <= 1.0)) continue;
                    entity.func_70097_a(EGG, (float)((double)(4.8f * this.getScale()) * (1.0 - d12) * (double)((float)MightyEnderChicken.config.chaosChickenDamageMultiplier / 100.0f)));
                }
            }
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, posYmid, this.field_70161_v, size, flag);
        }
        this.func_70106_y();
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    protected void func_70037_a(NBTTagCompound tag) {
        if (tag.func_74764_b("scale")) {
            this.setScale(tag.func_74760_g("scale"));
        }
        if (tag.func_74764_b("maxLiveTime")) {
            this.maxLiveTime = tag.func_74762_e("maxLiveTime");
        }
        if (tag.func_74764_b("chaosType")) {
            this.chaosType = tag.func_74767_n("chaosType");
        }
        this.liveTime = tag.func_74762_e("liveTime");
        this.explodeTimer = tag.func_74762_e("explodeTimer");
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74776_a("scale", this.getScale());
        tag.func_74768_a("maxLiveTime", this.maxLiveTime);
        tag.func_74757_a("chaosType", this.chaosType);
        tag.func_74768_a("liveTime", this.liveTime);
        tag.func_74768_a("explodeTimer", this.explodeTimer);
    }
}

