/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui;

import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiDraggable;
import com.brandon3055.projectintelligence.client.DisplayController;
import com.brandon3055.projectintelligence.client.gui.guielements.GuiPartMDWindow;
import com.brandon3055.projectintelligence.client.gui.guielements.GuiPartMenu;
import com.brandon3055.projectintelligence.client.gui.guielements.GuiPartPageList;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;

public class PIGuiContainer
implements IModularGui<GuiScreen> {
    private Minecraft mc;
    private int xPos;
    private int yPos;
    private int xSize;
    private int ySize;
    private int screenWidth;
    private int screenHeight;
    private GuiElementManager manager = new GuiElementManager((IModularGui)this);
    private GuiScreen gui;
    private DisplayController controller;
    private int zLevel = 0;
    private boolean enableMenu = true;
    private Supplier<Integer> listMaxWidth = () -> 150;
    private boolean enablePageList = true;
    private boolean enableContentWindow = true;
    private GuiDraggable partContainer = null;
    private GuiPartMenu menu = null;
    private GuiPartMDWindow mdWindow = null;
    private GuiPartPageList pageList = null;
    private Runnable siseChangeHandler = null;
    private Runnable closeHandler = null;
    private Supplier<Boolean> canDrag = () -> false;
    private Consumer<GuiDraggable> onMoved = null;
    private GuiDraggable.PositionRestraint positionRestraint = MGuiElementBase::normalizePosition;

    public PIGuiContainer(GuiScreen gui, DisplayController controller) {
        this.gui = gui;
        this.controller = controller;
        this.onGuiInit();
    }

    public void initContainer() {
        this.mdWindow = null;
        this.pageList = null;
        this.manager.reinitialize(this.mc, this.screenWidth, this.screenHeight);
    }

    public void onGuiInit() {
        this.mc = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        this.screenWidth = scaledresolution.func_78326_a();
        this.screenHeight = scaledresolution.func_78328_b();
        this.manager.setWorldAndResolution(this.mc, this.screenWidth, this.screenHeight);
    }

    public void setMenuEnabled(boolean enableMenu) {
        this.enableMenu = enableMenu;
    }

    public void setPageListEnabled(boolean enablePageList) {
        this.enablePageList = enablePageList;
    }

    public void setContentWindowEnabled(boolean enableContentWindow) {
        this.enableContentWindow = enableContentWindow;
    }

    public void setMenuElement(GuiPartMenu menu) {
        if (this.menu != null && this.partContainer != null) {
            this.partContainer.removeChild((MGuiElementBase)this.menu);
        }
        this.menu = menu;
        if (menu != null && this.partContainer != null) {
            this.partContainer.addChild((MGuiElementBase)menu);
        }
        this.updatePartArrangement(true);
    }

    public void addElements(GuiElementManager manager) {
        this.partContainer = new GuiDraggable();
        this.partContainer.setCanDrag(this.canDrag);
        this.partContainer.setPositionRestraint(this.positionRestraint);
        this.partContainer.setOnMovedCallback(this.onMoved == null ? null : () -> this.onMoved.accept(this.partContainer));
        manager.add((MGuiElementBase)this.partContainer);
        if (this.enableMenu && this.menu != null) {
            this.partContainer.addChild((MGuiElementBase)this.menu);
        }
        if (this.enablePageList) {
            this.pageList = new GuiPartPageList(this, this.controller);
            this.partContainer.addChild((MGuiElementBase)this.pageList);
        }
        if (this.enableContentWindow) {
            this.mdWindow = new GuiPartMDWindow(this.controller);
            this.partContainer.addChild((MGuiElementBase)this.mdWindow);
        }
        this.updatePartArrangement(true);
        this.controller.addChangeListener(this, () -> {
            if (this.enablePageList) {
                this.pageList.reloadElement();
            }
            if (this.enableContentWindow) {
                this.mdWindow.reloadElement();
            }
        });
    }

    public void dispose() {
        this.controller.removeChangeListener(this);
    }

    public void updatePos(int xPos, int yPos) {
        this.updatePos(xPos, yPos, true);
    }

    public void updatePos(int xPos, int yPos, boolean reload) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.updatePartArrangement(reload);
    }

    public void updateSize(int xSize, int ySize) {
        this.xSize = xSize;
        this.ySize = ySize;
        this.updatePartArrangement(true);
    }

    public void setListMaxWidth(Supplier<Integer> pageListMaxWidth) {
        this.listMaxWidth = pageListMaxWidth;
    }

    public void updatePartArrangement(boolean reload) {
        if (!this.manager.isInitialized()) {
            return;
        }
        this.partContainer.setPosAndSize(this.xPos, this.yPos, this.xSize, this.ySize);
        int yPos = this.yPos;
        int xPos = this.xPos;
        int ySize = this.ySize;
        int xSize = this.xSize;
        if (this.menu != null) {
            this.menu.setPosAndSize(xPos, yPos, xSize, 20);
            yPos = this.menu.maxYPos();
            ySize -= this.menu.ySize();
            if (reload) {
                this.menu.reloadElement();
            }
        }
        if (this.pageList != null) {
            this.pageList.setPosAndSize(xPos, yPos, this.pageList.extended ? this.getListMaxWidth().get() : this.pageList.HIDDEN_X_SIZE, ySize);
            xPos = this.pageList.maxXPos();
            xSize -= this.pageList.xSize();
            if (reload) {
                this.pageList.reloadElement();
            }
        }
        if (this.mdWindow != null) {
            this.mdWindow.setPosAndSize(xPos, yPos, xSize, ySize);
            if (reload) {
                this.mdWindow.reloadElement();
            }
        }
    }

    public void pageListMotionUpdate() {
        if (this.mdWindow != null && this.pageList != null) {
            this.mdWindow.setPosAndSize(this.pageList.maxXPos(), this.mdWindow.yPos(), this.xSize - this.pageList.xSize(), this.mdWindow.ySize());
            this.mdWindow.reloadElement();
        }
    }

    public void setCloseHandler(Runnable closeHandler) {
        this.closeHandler = closeHandler;
    }

    public void setCanDrag(Supplier<Boolean> canDrag) {
        this.canDrag = canDrag;
        if (this.partContainer != null) {
            this.partContainer.setCanDrag(canDrag);
        }
    }

    public void setPositionRestraint(GuiDraggable.PositionRestraint positionRestraint) {
        this.positionRestraint = positionRestraint;
        if (this.partContainer != null) {
            this.partContainer.setPositionRestraint(positionRestraint);
        }
    }

    public void setOnMoved(Consumer<GuiDraggable> onMoved) {
        this.onMoved = onMoved;
        if (this.partContainer != null) {
            this.partContainer.setOnMovedCallback(onMoved == null ? null : () -> onMoved.accept(this.partContainer));
        }
    }

    public void setGui(GuiScreen gui) {
        this.gui = gui;
    }

    public Supplier<Integer> getListMaxWidth() {
        return this.listMaxWidth;
    }

    public void closeButtonPressed() {
        if (this.closeHandler != null) {
            this.closeHandler.run();
        }
    }

    public GuiPartPageList getPageList() {
        return this.pageList;
    }

    public GuiPartMenu getMenu() {
        return this.menu;
    }

    public GuiPartMDWindow getMdWindow() {
        return this.mdWindow;
    }

    public GuiDraggable getPartContainer() {
        return this.partContainer;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        return this.manager.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(int mouseX, int mouseY, int state) {
        return this.manager.mouseReleased(mouseX, mouseY, state);
    }

    public boolean mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        return this.manager.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    public boolean keyTyped(char typedChar, int keyCode) throws IOException {
        boolean ret = this.manager.keyTyped(typedChar, keyCode);
        if (!ret && (keyCode == 1 || this.mc.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) && this.closeHandler != null) {
            this.closeHandler.run();
            return true;
        }
        return ret;
    }

    public boolean handleMouseInput() throws IOException {
        return this.manager.handleMouseInput();
    }

    public void renderElements(int mouseX, int mouseY, float partialTicks) {
        this.manager.renderElements(this.mc, mouseX, mouseY, partialTicks);
    }

    public void renderOverlayLayer(int mouseX, int mouseY, float partialTicks) {
        this.manager.renderOverlayLayer(this.mc, mouseX, mouseY, partialTicks);
    }

    public void updateScreen() {
        this.manager.onUpdate();
    }

    public GuiScreen getScreen() {
        return this.gui;
    }

    public int xSize() {
        return this.xSize;
    }

    public int ySize() {
        return this.ySize;
    }

    public int guiLeft() {
        return 0;
    }

    public int guiTop() {
        return 0;
    }

    public GuiElementManager getManager() {
        return this.manager;
    }

    public void setZLevel(int zLevel) {
        this.zLevel = zLevel;
    }

    public int getZLevel() {
        return this.zLevel;
    }
}

