/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui.guielements;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiPopUpDialogBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiScrollElement;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTextField;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTextFieldDialog;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.projectintelligence.client.PIGuiHelper;
import com.brandon3055.projectintelligence.client.PITextures;
import com.brandon3055.projectintelligence.client.StyleHandler;
import com.brandon3055.projectintelligence.client.gui.PIConfig;
import com.brandon3055.projectintelligence.client.gui.PIPartRenderer;
import com.brandon3055.projectintelligence.client.gui.guielements.GuiStyleEditor;
import com.brandon3055.projectintelligence.client.gui.guielements.StyledGuiButton;
import com.brandon3055.projectintelligence.client.gui.guielements.StyledGuiRect;
import com.brandon3055.projectintelligence.client.gui.guielements.StyledSelectDialog;
import com.brandon3055.projectintelligence.docmanagement.DocumentationManager;
import com.brandon3055.projectintelligence.docmanagement.LanguageManager;
import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;

public class GuiPIConfig
extends GuiPopUpDialogBase<GuiPIConfig> {
    public static StyleHandler.PropertyGroup buttonProps = new StyleHandler.PropertyGroup("user_dialogs.button_style");
    private GuiScrollElement configList;
    private GuiStyleEditor styleEditor;

    public GuiPIConfig(MGuiElementBase parent, GuiStyleEditor styleEditor) {
        super(parent);
        this.styleEditor = styleEditor;
        this.setSize(200, 200);
        this.setDragBar(12);
        this.setCloseOnOutsideClick(false);
    }

    public void reloadConfigProperties() {
        this.configList.clearElements();
        this.configList.addElement((MGuiElementBase)((GuiLabel)new GuiLabel(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"pi.config.basic_config", (Object[])new Object[0])).setYSize(12)).setShadow(false).setTextColGetter(hovering -> StyleHandler.getInt("user_dialogs." + StyleHandler.StyleType.TEXT_COLOUR.getName())));
        this.addConfig(new ConfigProperty(this, "pi.config.open_style_settings").setAction(() -> this.styleEditor.toggleShown(true, 550)).setCloseOnClick(true));
        this.addConfig(((ConfigProperty)new ConfigProperty(this, () -> "pi.config.set_pi_language", () -> (LanguageManager.isCustomUserLanguageSet() ? "" : I18n.func_135052_a((String)"pi.lang.mc_default", (Object[])new Object[0]) + " ") + LanguageManager.LANG_NAME_MAP.get(LanguageManager.getUserLanguage())).setHoverText(new String[]{I18n.func_135052_a((String)"pi.config.set_pi_language.info", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"pi.config.set_pi_language_note.info", (Object[])new Object[0])})).setAction(this::openLanguageSelector));
        this.addConfig(((ConfigProperty)new ConfigProperty(this, () -> "pi.config.max_tabs", () -> String.valueOf(PIConfig.maxTabs)).setHoverText(I18n.func_135052_a((String)"pi.config.max_tabs.info", (Object[])new Object[0]))).setAction(() -> {
            GuiTextFieldDialog dialog = new GuiTextFieldDialog((MGuiElementBase)this, I18n.func_135052_a((String)"pi.config.max_tabs.title", (Object[])new Object[0]));
            ((GuiTextFieldDialog)dialog.setXSize(200)).setMaxLength(4096);
            dialog.addChild(new StyledGuiRect("user_dialogs").setPosAndSize((MGuiElementBase)dialog));
            dialog.setTitleColour(StyleHandler.getInt("user_dialogs." + StyleHandler.StyleType.TEXT_COLOUR.getName()));
            dialog.setText(String.valueOf(PIConfig.maxTabs));
            dialog.setValidator(value -> value.isEmpty() || Utils.validInteger((String)value));
            dialog.addTextConfirmCallback(s -> {
                PIConfig.maxTabs = MathHelper.clip((int)Utils.parseInt((String)s, (boolean)true), (int)1, (int)64);
                PIConfig.save();
            });
            dialog.showCenter(this.displayZLevel + 50);
        }));
        this.addConfig((ConfigProperty)new ConfigProperty(this, () -> "pi.config.et_fluid", () -> PIConfig.etCheckFluid + "").setAction(() -> {
            PIConfig.etCheckFluid = !PIConfig.etCheckFluid;
        }).setHoverText(I18n.func_135052_a((String)"pi.config.et_fluid.info", (Object[])new Object[0])));
        this.configList.addElement((MGuiElementBase)((GuiLabel)new GuiLabel(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"pi.config.advanced_config", (Object[])new Object[0])).setYSize(12)).setShadow(false).setTextColGetter(hovering -> StyleHandler.getInt("user_dialogs." + StyleHandler.StyleType.TEXT_COLOUR.getName())));
        this.addConfig(new ConfigProperty(this, () -> "pi.config.edit_mode", () -> PIConfig.editMode() + "").setAction(() -> {
            PIConfig.setEditMode(!PIConfig.editMode());
            if (!PIConfig.editMode()) {
                PIGuiHelper.closeEditor();
            }
            PIConfig.save();
            if (PIConfig.editMode() && !new File(PIConfig.editingRepoLoc).exists()) {
                this.reloadConfigProperties();
                this.displayRepoSetDialog();
            } else {
                DocumentationManager.checkAndReloadDocFiles();
                if (this.getParent() != null) {
                    this.getParent().reloadElement();
                }
                this.reloadConfigProperties();
            }
        }));
        if (PIConfig.editMode()) {
            this.addConfig(((ConfigProperty)new ConfigProperty(this, () -> "pi.config.edit_repo_loc", () -> PIConfig.editingRepoLoc.isEmpty() ? "[Not Set]" : PIConfig.editingRepoLoc).setHoverText(I18n.func_135052_a((String)"pi.config.edit_repo_loc.info", (Object[])new Object[0]))).setAction(() -> this.displayRepoSetDialog()));
        }
        this.addConfig(((ConfigProperty)new ConfigProperty(this, () -> PIConfig.editMode() ? "pi.config.reload_from_disk" : "pi.config.reload_documentation").setHoverText(PIConfig.editMode() ? I18n.func_135052_a((String)"pi.config.reload_from_disk.info", (Object[])new Object[0]) : I18n.func_135052_a((String)"pi.config.reload_documentation.info", (Object[])new Object[0]))).setAction(DocumentationManager::checkAndReloadDocFiles));
        if (PIConfig.editMode()) {
            this.addConfig(new ConfigProperty(this, "pi.config.open_editor").setAction(PIGuiHelper::displayEditor));
        }
        if (GuiScreen.func_146272_n()) {
            this.addConfig(new ConfigProperty(this, () -> "Reset PI and clear image cache").setAction(PIConfig::deleteConfigAndReload));
        }
    }

    private void displayRepoSetDialog() {
        GuiTextFieldDialog dialog = new GuiTextFieldDialog((MGuiElementBase)this, I18n.func_135052_a((String)"pi.config.edit_repo_select_title", (Object[])new Object[0]));
        ((GuiTextFieldDialog)dialog.setXSize(280)).setMaxLength(4096);
        dialog.addChild(new StyledGuiRect("user_dialogs").setPosAndSize((MGuiElementBase)dialog));
        dialog.setTitleColour(StyleHandler.getInt("user_dialogs." + StyleHandler.StyleType.TEXT_COLOUR.getName()));
        dialog.setText(PIConfig.editingRepoLoc);
        dialog.addTextConfirmCallback(s -> {
            PIConfig.editingRepoLoc = s;
            PIConfig.save();
            if (PIConfig.editMode()) {
                DocumentationManager.checkAndReloadDocFiles();
            }
        });
        dialog.showCenter(this.displayZLevel + 50);
    }

    public void addConfig(ConfigProperty configProperty) {
        this.configList.addElement((MGuiElementBase)configProperty);
    }

    public void addChildElements() {
        this.childElements.clear();
        this.addChild(new StyledGuiRect("user_dialogs").setPosAndSize((MGuiElementBase)this));
        this.addChild((MGuiElementBase)((GuiLabel)((GuiLabel)((GuiLabel)new GuiLabel(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"pi.config.pi_configuration.title", (Object[])new Object[0])).setPos((MGuiElementBase)this)).setSize(this.xSize(), 10)).translate(4, 3)).setTextColGetter(hovering -> StyleHandler.getInt("user_dialogs." + StyleHandler.StyleType.TEXT_COLOUR.getName())).setShadow(false).setAlignment(GuiAlign.CENTER));
        GuiButton close = (GuiButton)((GuiButton)((GuiButton)new StyledGuiButton("user_dialogs.button_style").setPos((MGuiElementBase)this)).translate(this.xSize() - 14, 3)).setSize(11, 11);
        close.setListener(() -> ((GuiPIConfig)this).close());
        close.setHoverText(I18n.func_135052_a((String)"pi.button.close", (Object[])new Object[0]));
        close.addChild(new GuiTexture(64, 16, 5, 5, PITextures.PI_PARTS).setRelPos(3, 3));
        this.addChild((MGuiElementBase)close);
        GuiBorderedRect listBackground = (GuiBorderedRect)((GuiBorderedRect)new GuiBorderedRect().setRelPos(4, 16)).setSize(this.xSize() - 8, this.ySize() - 20);
        this.addChild((MGuiElementBase)listBackground);
        listBackground.setFillColourGetter(hovering -> StyleHandler.getInt("user_dialogs.sub_elements." + StyleHandler.StyleType.COLOUR.getName()));
        listBackground.setBorderColourGetter(hovering -> StyleHandler.getInt("user_dialogs.sub_elements." + StyleHandler.StyleType.BORDER.getName()));
        this.configList = new GuiScrollElement();
        ((GuiScrollElement)this.configList.setRelPos(5, 17)).setSize(this.xSize() - 10, this.ySize() - 22);
        this.configList.setStandardScrollBehavior();
        this.configList.setListMode(GuiScrollElement.ListMode.VERT_LOCK_POS_WIDTH);
        this.configList.getVerticalScrollBar().setHidden(true);
        this.configList.setListSpacing(1);
        this.configList.clearElements();
        this.reloadConfigProperties();
        this.addChild((MGuiElementBase)this.configList);
        super.addChildElements();
    }

    public void reloadElement() {
        super.reloadElement();
        this.reloadConfigProperties();
    }

    protected boolean keyTyped(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.close();
            return true;
        }
        return super.keyTyped(typedChar, keyCode);
    }

    public void openLanguageSelector() {
        StyledSelectDialog langSelect = new StyledSelectDialog((MGuiElementBase)this, "user_dialogs", "Select Language");
        langSelect.setInsets(14, 2, 18, 2);
        GuiTextField filter = new GuiTextField();
        langSelect.addChild((MGuiElementBase)filter);
        ((GuiTextField)filter.setSize(langSelect.xSize() - 4, 14)).setPos(langSelect.xPos() + 2, langSelect.maxYPos() - 16);
        filter.setListener((event, eventSource) -> langSelect.reloadElement());
        langSelect.setSelectionFilter(item -> {
            String ft = filter.getText().toLowerCase();
            return ft.isEmpty() || item.toLowerCase().contains(ft) || LanguageManager.LANG_NAME_MAP.getOrDefault(item, "").toLowerCase().contains(ft);
        });
        String doTrans = I18n.func_135052_a((String)"pi.lang.disable_override", (Object[])new Object[0]);
        if (LanguageManager.isCustomUserLanguageSet()) {
            langSelect.addItem(doTrans);
        }
        langSelect.setSelected(LanguageManager.getUserLanguage());
        LanguageManager.ALL_LANGUAGES.forEach(arg_0 -> langSelect.addItem(arg_0));
        langSelect.setSelectionListener(lang -> {
            LanguageManager.setCustomUserLanguage(lang.equals(doTrans) ? null : lang);
            GuiButton.playGenericClick((Minecraft)this.mc);
            DocumentationManager.checkAndReloadDocFiles();
        });
        langSelect.setCloseOnSelection(true);
        langSelect.showCenter(this.displayZLevel + 50);
    }

    public static class ConfigProperty
    extends MGuiElementBase<ConfigProperty> {
        public PIPartRenderer buttonRenderer = new PIPartRenderer(buttonProps).setButtonRender(true);
        private boolean playSound = true;
        private boolean closeOnClick = false;
        private Supplier<String> unlocalizedNameSupplier = null;
        private Supplier<String> valueSupplier = null;
        private Runnable clickAction = null;
        private GuiPIConfig gui;

        public ConfigProperty(GuiPIConfig gui) {
            this.gui = gui;
            this.setYSize(15);
        }

        public ConfigProperty(GuiPIConfig gui, Supplier<String> unlocalizedNameSupplier) {
            this(gui);
            this.unlocalizedNameSupplier = unlocalizedNameSupplier;
        }

        public ConfigProperty(GuiPIConfig gui, String unlocalizedName) {
            this(gui);
            this.unlocalizedNameSupplier = () -> unlocalizedName;
        }

        public ConfigProperty(GuiPIConfig gui, Supplier<String> unlocalizedNameSupplier, Supplier<String> valueSupplier) {
            this(gui, unlocalizedNameSupplier);
            this.valueSupplier = valueSupplier;
            this.setYSize(26);
        }

        public ConfigProperty(GuiPIConfig gui, Supplier<String> unlocalizedNameSupplier, Supplier<String> valueSupplier, Runnable clickAction) {
            this(gui, unlocalizedNameSupplier, valueSupplier);
            this.clickAction = clickAction;
        }

        public ConfigProperty setNameSupplier(Supplier<String> unlocalizedNameSupplier) {
            this.unlocalizedNameSupplier = unlocalizedNameSupplier;
            return this;
        }

        public ConfigProperty setValueSupplier(Supplier<String> valueSupplier) {
            this.valueSupplier = valueSupplier;
            this.setYSize(26);
            return this;
        }

        public ConfigProperty setAction(Runnable clickAction) {
            this.clickAction = clickAction;
            return this;
        }

        public ConfigProperty setCloseOnClick(boolean closeOnClick) {
            this.closeOnClick = closeOnClick;
            return this;
        }

        public ConfigProperty setSilent() {
            this.playSound = false;
            return this;
        }

        public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
            if (this.isMouseOver(mouseX, mouseY)) {
                if (this.clickAction != null) {
                    this.clickAction.run();
                }
                if (this.closeOnClick) {
                    this.gui.close();
                }
                if (this.playSound) {
                    this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                }
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            boolean mouseOver = this.isMouseOver(mouseX, mouseY);
            this.buttonRenderer.render(this, mouseOver);
            if (this.unlocalizedNameSupplier != null) {
                this.drawString(this.fontRenderer, TextFormatting.UNDERLINE + I18n.func_135052_a((String)this.unlocalizedNameSupplier.get(), (Object[])new Object[0]), this.xPos() + 4, this.yPos() + 3, buttonProps.textColour());
            }
            if (this.valueSupplier != null) {
                this.drawString(this.fontRenderer, this.valueSupplier.get(), this.xPos() + 4, this.yPos() + 15, buttonProps.textColourHover());
            }
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
    }
}

