/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.docmanagement;

import com.brandon3055.brandonscore.handlers.FileHandler;
import com.brandon3055.brandonscore.integration.ModHelperBC;
import com.brandon3055.brandonscore.lib.FileDownloadManager;
import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.projectintelligence.client.PIGuiHelper;
import com.brandon3055.projectintelligence.client.gui.PIConfig;
import com.brandon3055.projectintelligence.docmanagement.DocumentationManager;
import com.brandon3055.projectintelligence.docmanagement.LanguageManager;
import com.brandon3055.projectintelligence.utils.LogHelper;
import com.google.common.hash.Hashing;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class PIUpdateManager {
    public static FileDownloadManager downloadManager = new FileDownloadManager("PI-Update-Manager", 6, false);
    private static String modManifestURL = "https://pi.brandon3055.com/manifest.json";
    private static File modManifest;
    private static File updaterFolder;
    private static File updaterModsFolder;
    public static UpdateStage updateStage;
    private static Map<String, File> perModManifestMap;
    private static Map<String, File> modDLManifestMap;
    private static Map<String, String> downloadingVersionMap;
    public static Map<File, PairKV<String, File>> tempFileToFileMap;

    public static void performFullUpdateCheck() {
        if (PIConfig.editMode()) {
            LogHelper.warn("Canceling documentation update as edit mode is now enabled!");
            return;
        }
        if (!PIConfig.downloadsAllowed) {
            return;
        }
        updateStage = UpdateStage.DL_MASTER_MANIFEST;
        LogHelper.dev("### Performing full update check ###");
        downloadManager.reset();
        updaterFolder = new File(DocumentationManager.piConfigDirectory, "DocUpdater");
        if (!updaterFolder.exists() && !updaterFolder.mkdirs()) {
            PIGuiHelper.displayError("Failed to create folder - " + updaterFolder + " Doc update check can not be completed!");
            updateStage = UpdateStage.INACTIVE;
            return;
        }
        updaterModsFolder = new File(updaterFolder, "Mods");
        if (!updaterModsFolder.exists() && !updaterModsFolder.mkdirs()) {
            PIGuiHelper.displayError("Failed to create folder - " + updaterModsFolder + " Doc update check can not be completed!");
            updateStage = UpdateStage.INACTIVE;
            return;
        }
        modManifest = new File(updaterFolder, "manifest.json");
        downloadManager.addFileToQue(modManifestURL, modManifest);
        downloadManager.setQueCompeteCallback(PIUpdateManager::downloadPerModManifests);
        downloadManager.startDownload();
    }

    private static void downloadPerModManifests() {
        JsonObject modsJson;
        if (PIConfig.editMode()) {
            LogHelper.warn("Canceling documentation update as edit mode is now enabled!");
            return;
        }
        updateStage = UpdateStage.DL_MOD_MANIFESTS;
        LogHelper.dev("### Downloading per mod manifests ###");
        if (PIUpdateManager.downloadManager.failedFiles.containsValue(modManifest)) {
            PIGuiHelper.displayError("Failed to download the PI mod manifest from " + modManifestURL);
            DocumentationManager.loadDocumentationFromDisk();
            updateStage = UpdateStage.INACTIVE;
            return;
        }
        downloadManager.reset();
        perModManifestMap.clear();
        try {
            modsJson = FileHandler.readObj((File)modManifest);
        }
        catch (IOException e) {
            e.printStackTrace();
            PIGuiHelper.displayError("Failed to read mod manifest! See console for stacktrace.");
            updateStage = UpdateStage.INACTIVE;
            return;
        }
        for (String modid : ModHelperBC.getLoadedMods()) {
            if (!modsJson.has(modid)) continue;
            LogHelper.dev("Mod has dock avalible: " + modid);
            File perModManifest = new File(updaterModsFolder, modid + ".json");
            downloadManager.addFileToQue(modsJson.get(modid).getAsString(), perModManifest);
            perModManifestMap.put(modid, perModManifest);
        }
        downloadManager.setQueCompeteCallback(PIUpdateManager::readPerModManifests);
        downloadManager.startDownload();
    }

    private static void readPerModManifests() {
        if (PIConfig.editMode()) {
            LogHelper.warn("Canceling documentation update as edit mode is now enabled!");
            return;
        }
        updateStage = UpdateStage.DL_MOD_DOCUMENTATION;
        LogHelper.dev("### Reading per mod manifests ###");
        if (PIUpdateManager.downloadManager.failedFiles.size() > 0) {
            PIGuiHelper.displayError("Failed to download one or more per-mod manifest files");
        }
        downloadManager.reset();
        modDLManifestMap.clear();
        for (String mod : perModManifestMap.keySet()) {
            try {
                JsonObject modJson;
                try {
                    modJson = FileHandler.readObj((File)perModManifestMap.get(mod));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    PIGuiHelper.displayError("Failed to read manifest jason for mod " + mod + " See console for stacktrace.");
                    continue;
                }
                String installedVersion = ModHelperBC.getModVersion((String)mod);
                String latestMatch = "";
                String latestMatchURL = "";
                int latestBuild = -1;
                for (Map.Entry entry : modJson.entrySet()) {
                    if (((String)entry.getKey()).equals("mod_id")) continue;
                    int build = Utils.parseInt((String)((String)entry.getKey()));
                    JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                    String version = obj.get("mod_version").getAsString();
                    String file = obj.get("file").getAsString();
                    if (DocumentationManager.compareVersion(version, installedVersion) > 0) continue;
                    int versCheck = DocumentationManager.compareVersion(version, latestMatch);
                    if (!latestMatch.isEmpty() && versCheck <= 0 && (versCheck != 0 || build <= latestBuild)) continue;
                    latestBuild = build;
                    latestMatch = version;
                    latestMatchURL = file;
                }
                if (!latestMatchURL.isEmpty()) {
                    LogHelper.dev("Found documentation for version " + latestMatch + " of " + mod + ". Installed mod version is " + installedVersion);
                    File file = new File(updaterModsFolder, mod + "-downloadManifest.json");
                    downloadManager.addFileToQue(latestMatchURL, file);
                    modDLManifestMap.put(mod, file);
                    downloadingVersionMap.put(mod, latestMatch);
                    continue;
                }
                LogHelper.dev("Did not find documentation for mod " + mod + " that matches the installed mod version " + installedVersion);
            }
            catch (Exception e) {
                PIGuiHelper.displayError("An error occurred while reading manifest for mod " + mod + " See console for stacktrace.");
                e.printStackTrace();
            }
        }
        downloadManager.setQueCompeteCallback(PIUpdateManager::performLocalUpdateCheck);
        downloadManager.startDownload();
    }

    public static void performLocalUpdateCheck() {
        if (PIConfig.editMode()) {
            LogHelper.warn("Canceling documentation update as edit mode is now enabled!");
            return;
        }
        updateStage = UpdateStage.DL_MOD_DOCUMENTATION;
        LogHelper.dev("### Performing local update check ###");
        if (PIUpdateManager.downloadManager.failedFiles.size() > 0) {
            PIGuiHelper.displayError("Failed to download one or more mod download manifests");
        }
        downloadManager.reset();
        tempFileToFileMap.clear();
        for (String mod : modDLManifestMap.keySet()) {
            try {
                String hash;
                File file;
                JsonObject obj;
                JsonObject dlManifest;
                try {
                    dlManifest = FileHandler.readObj((File)modDLManifestMap.get(mod));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    PIGuiHelper.displayError("Failed to read download manifest jason for mod " + mod + " See console for stacktrace.");
                    continue;
                }
                JsonArray baseFiles = dlManifest.getAsJsonArray("base_files");
                JsonArray langFiles = dlManifest.getAsJsonArray("lang_files");
                for (JsonElement element : baseFiles) {
                    obj = element.getAsJsonObject();
                    file = new File(DocumentationManager.getDlDocDirectory(), mod + "/" + downloadingVersionMap.get(mod) + "/" + obj.get("file_path").getAsString());
                    hash = obj.get("sha1").getAsString();
                    if (file.exists() && PIUpdateManager.getHash(file).equals(hash)) {
                        LogHelper.dev("Existing file is valid! Skipping file: " + file);
                        continue;
                    }
                    File tempFile = new File(updaterFolder, hash + ".temp");
                    tempFileToFileMap.put(tempFile, (PairKV<String, File>)new PairKV((Object)hash, (Object)file));
                    downloadManager.addFileToQue(obj.get("url").getAsString(), tempFile);
                }
                for (JsonElement element : langFiles) {
                    obj = element.getAsJsonObject();
                    file = new File(DocumentationManager.getDlDocDirectory(), mod + "/" + downloadingVersionMap.get(mod) + "/" + obj.get("file_path").getAsString());
                    hash = obj.get("sha1").getAsString();
                    String lang = obj.get("lang").getAsString();
                    if (!LanguageManager.isLangUsedByMod(lang, mod)) continue;
                    if (file.exists() && PIUpdateManager.getHash(file).equals(hash)) {
                        LogHelper.dev("Existing file is valid! Skipping file: " + file);
                        continue;
                    }
                    File tempFile = new File(updaterFolder, hash + ".temp");
                    tempFileToFileMap.put(tempFile, (PairKV<String, File>)new PairKV((Object)hash, (Object)file));
                    downloadManager.addFileToQue(obj.get("url").getAsString(), tempFile);
                }
            }
            catch (Exception e) {
                PIGuiHelper.displayError("An error occurred while reading download list for mod " + mod + " See console for stacktrace.");
                e.printStackTrace();
            }
        }
        downloadManager.setQueCompeteCallback(() -> PIUpdateManager.completeDownloads(tempFileToFileMap));
        downloadManager.startDownload();
    }

    private static void completeDownloads(Map<File, PairKV<String, File>> tempFileToFileMap) {
        updateStage = UpdateStage.RELOAD_DOCUMENTATION;
        LogHelper.dev("### Transferring downloaded files ###");
        if (PIUpdateManager.downloadManager.failedFiles.size() > 0) {
            PIGuiHelper.displayError("Failed to download one or more mod page files!");
            tempFileToFileMap.entrySet().removeIf(entry -> PIUpdateManager.downloadManager.failedFiles.containsValue(entry.getKey()));
        }
        for (File tempFile : tempFileToFileMap.keySet()) {
            PairKV<String, File> hashFilePair = tempFileToFileMap.get(tempFile);
            try {
                String hash = PIUpdateManager.getHash(tempFile);
                if (hash.equals(hashFilePair.getKey())) {
                    ((File)hashFilePair.getValue()).delete();
                    LogHelper.dev(tempFile + " -> " + hashFilePair.getValue());
                    FileUtils.moveFile((File)tempFile, (File)((File)hashFilePair.getValue()));
                    continue;
                }
                PIGuiHelper.displayError("An error occurred while transferring downloaded file. The hash of the downloaded file does not match the expected hash. " + tempFile);
            }
            catch (Exception e) {
                PIGuiHelper.displayError("An error occurred while transferring downloaded file to final location file: " + tempFile + " -> " + hashFilePair.getValue() + " See console for stacktrace.");
                e.printStackTrace();
            }
        }
        DocumentationManager.loadDocumentationFromDisk();
        updateStage = UpdateStage.INACTIVE;
    }

    private static String getHash(File file) throws IOException {
        return Hashing.sha1().hashBytes(FileUtils.readFileToByteArray((File)file)).toString();
    }

    static {
        updateStage = UpdateStage.INACTIVE;
        perModManifestMap = new LinkedHashMap<String, File>();
        modDLManifestMap = new LinkedHashMap<String, File>();
        downloadingVersionMap = new LinkedHashMap<String, String>();
        tempFileToFileMap = new LinkedHashMap<File, PairKV<String, File>>();
    }

    public static enum UpdateStage {
        INACTIVE,
        DL_MASTER_MANIFEST,
        DL_MOD_MANIFESTS,
        DL_MOD_DOCUMENTATION,
        RELOAD_DOCUMENTATION;


        public String getUnlocalizedName() {
            return "pi.update.status." + this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

