/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicterminal.init;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.exceptions.AppEngException;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.storage.ITerminalHost;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.client.gui.GuiNull;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerNull;
import appeng.container.ContainerOpenContext;
import appeng.core.sync.GuiHostType;
import appeng.util.Platform;
import ftblag.thaumicterminal.ThaumicTerminal;
import ftblag.thaumicterminal.container.ContainerArcaneTerminal;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public enum ModGuiHandler implements IGuiHandler
{
    INSTANCE,
    ME_ArcaneTerminal(ContainerArcaneTerminal.class, ITerminalHost.class, GuiHostType.WORLD, SecurityPermissions.CRAFT);

    private final Class<?> tileClass;
    private final Class<? extends AEBaseContainer> containerClass;
    private Class<?> guiClass;
    private GuiHostType type;
    private SecurityPermissions requiredPermission;

    private ModGuiHandler() {
        this.tileClass = null;
        this.guiClass = null;
        this.containerClass = null;
    }

    private ModGuiHandler(Class<? extends AEBaseContainer> containerClass, SecurityPermissions requiredPermission) {
        this.requiredPermission = requiredPermission;
        this.containerClass = containerClass;
        this.tileClass = null;
        this.getGui();
    }

    private void getGui() {
        if (Platform.isClient()) {
            GuiLink link = this.containerClass.getAnnotation(GuiLink.class);
            this.guiClass = link.value();
        }
    }

    private ModGuiHandler(Class<? extends AEBaseContainer> containerClass, Class<?> tileClass, GuiHostType type, SecurityPermissions requiredPermission) {
        this.requiredPermission = requiredPermission;
        this.containerClass = containerClass;
        this.type = type;
        this.tileClass = tileClass;
        this.getGui();
    }

    public Object getServerGuiElement(int ordinal, EntityPlayer player, World w, int x, int y, int z) {
        boolean stem;
        AEPartLocation side = AEPartLocation.fromOrdinal((int)(ordinal & 7));
        ModGuiHandler ID = ModGuiHandler.values()[ordinal >> 4];
        boolean bl = stem = (ordinal >> 3 & 1) == 1;
        if (ID.type.isItem()) {
            ItemStack it = ItemStack.field_190927_a;
            if (stem) {
                it = player.field_71071_by.func_70448_g();
            } else if (x >= 0 && x < player.field_71071_by.field_70462_a.size()) {
                it = player.field_71071_by.func_70301_a(x);
            }
            Object myItem = this.getGuiObject(it, player, w, x, y, z);
            if (myItem != null && ID.CorrectTileOrPart(myItem)) {
                return this.updateGui(ID.ConstructContainer(player.field_71071_by, side, myItem), w, x, y, z, side, myItem);
            }
        }
        if (ID.type != GuiHostType.ITEM) {
            TileEntity TE = w.func_175625_s(new BlockPos(x, y, z));
            if (TE instanceof IPartHost) {
                ((IPartHost)TE).getPart(side);
                IPart part = ((IPartHost)TE).getPart(side);
                if (ID.CorrectTileOrPart(part)) {
                    return this.updateGui(ID.ConstructContainer(player.field_71071_by, side, part), w, x, y, z, side, part);
                }
            } else if (ID.CorrectTileOrPart(TE)) {
                return this.updateGui(ID.ConstructContainer(player.field_71071_by, side, TE), w, x, y, z, side, TE);
            }
        }
        return new ContainerNull();
    }

    private Object getGuiObject(ItemStack it, EntityPlayer player, World w, int x, int y, int z) {
        if (!it.func_190926_b()) {
            if (it.func_77973_b() instanceof IGuiItem) {
                return ((IGuiItem)it.func_77973_b()).getGuiObject(it, w, new BlockPos(x, y, z));
            }
            AEApi.instance().registries().wireless().getWirelessTerminalHandler(it);
        }
        return null;
    }

    public boolean CorrectTileOrPart(Object tE) {
        if (this.tileClass == null) {
            throw new IllegalArgumentException("This Gui Cannot use the standard Handler.");
        }
        return this.tileClass.isInstance(tE);
    }

    private Object updateGui(Object newContainer, World w, int x, int y, int z, AEPartLocation side, Object myItem) {
        if (newContainer instanceof AEBaseContainer) {
            AEBaseContainer bc = (AEBaseContainer)newContainer;
            bc.setOpenContext(new ContainerOpenContext(myItem));
            bc.getOpenContext().setWorld(w);
            bc.getOpenContext().setX(x);
            bc.getOpenContext().setY(y);
            bc.getOpenContext().setZ(z);
            bc.getOpenContext().setSide(side);
        }
        return newContainer;
    }

    public Object ConstructContainer(InventoryPlayer inventory, AEPartLocation side, Object tE) {
        try {
            Constructor<?>[] c = this.containerClass.getConstructors();
            if (c.length == 0) {
                throw new AppEngException("Invalid Gui Class");
            }
            Constructor<?> target = this.findConstructor(c, inventory, tE);
            if (target == null) {
                throw new IllegalStateException("Cannot find " + this.containerClass.getName() + "( " + this.typeName(inventory) + ", " + this.typeName(tE) + " )");
            }
            return target.newInstance(inventory, tE);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    private Constructor<?> findConstructor(Constructor<?>[] c, InventoryPlayer inventory, Object tE) {
        for (Constructor<?> con : c) {
            Class<?>[] types = con.getParameterTypes();
            if (types.length != 2 || !types[0].isAssignableFrom(inventory.getClass()) || !types[1].isAssignableFrom(tE.getClass())) continue;
            return con;
        }
        return null;
    }

    private String typeName(Object inventory) {
        if (inventory == null) {
            return "NULL";
        }
        return inventory.getClass().getName();
    }

    public Object getClientGuiElement(int ordinal, EntityPlayer player, World w, int x, int y, int z) {
        boolean stem;
        AEPartLocation side = AEPartLocation.fromOrdinal((int)(ordinal & 7));
        ModGuiHandler ID = ModGuiHandler.values()[ordinal >> 4];
        boolean bl = stem = (ordinal >> 3 & 1) == 1;
        if (ID.type.isItem()) {
            ItemStack it = ItemStack.field_190927_a;
            if (stem) {
                it = player.field_71071_by.func_70448_g();
            } else if (x >= 0 && x < player.field_71071_by.field_70462_a.size()) {
                it = player.field_71071_by.func_70301_a(x);
            }
            Object myItem = this.getGuiObject(it, player, w, x, y, z);
            if (myItem != null && ID.CorrectTileOrPart(myItem)) {
                return ID.ConstructGui(player.field_71071_by, side, myItem);
            }
        }
        if (ID.type != GuiHostType.ITEM) {
            TileEntity TE = w.func_175625_s(new BlockPos(x, y, z));
            if (TE instanceof IPartHost) {
                ((IPartHost)TE).getPart(side);
                IPart part = ((IPartHost)TE).getPart(side);
                if (ID.CorrectTileOrPart(part)) {
                    return ID.ConstructGui(player.field_71071_by, side, part);
                }
            } else if (ID.CorrectTileOrPart(TE)) {
                return ID.ConstructGui(player.field_71071_by, side, TE);
            }
        }
        return new GuiNull((Container)new ContainerNull());
    }

    public Object ConstructGui(InventoryPlayer inventory, AEPartLocation side, Object tE) {
        try {
            Constructor<?>[] c = this.guiClass.getConstructors();
            if (c.length == 0) {
                throw new AppEngException("Invalid Gui Class");
            }
            Constructor<?> target = this.findConstructor(c, inventory, tE);
            if (target == null) {
                throw new IllegalStateException("Cannot find " + this.containerClass.getName() + "( " + this.typeName(inventory) + ", " + this.typeName(tE) + " )");
            }
            return target.newInstance(inventory, tE);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    public boolean hasPermissions(TileEntity te, int x, int y, int z, AEPartLocation side, EntityPlayer player) {
        World w = player.func_130014_f_();
        BlockPos pos = new BlockPos(x, y, z);
        if (Platform.hasPermissions((DimensionalCoord)(te != null ? new DimensionalCoord(te) : new DimensionalCoord(player.field_70170_p, pos)), (EntityPlayer)player)) {
            IGuiItemObject myItem;
            ItemStack it;
            if (this.type.isItem() && !(it = player.field_71071_by.func_70448_g()).func_190926_b() && it.func_77973_b() instanceof IGuiItem && this.CorrectTileOrPart(myItem = ((IGuiItem)it.func_77973_b()).getGuiObject(it, w, pos))) {
                return true;
            }
            if (this.type != GuiHostType.ITEM) {
                TileEntity TE = w.func_175625_s(pos);
                if (TE instanceof IPartHost) {
                    ((IPartHost)TE).getPart(side);
                    IPart part = ((IPartHost)TE).getPart(side);
                    if (this.CorrectTileOrPart(part)) {
                        return this.securityCheck(part, player);
                    }
                } else if (this.CorrectTileOrPart(TE)) {
                    return this.securityCheck(TE, player);
                }
            }
        }
        return false;
    }

    private boolean securityCheck(Object te, EntityPlayer player) {
        if (te instanceof IActionHost && this.requiredPermission != null) {
            ISecurityGrid sg;
            IGrid g;
            IGridNode gn = ((IActionHost)te).getActionableNode();
            return gn != null && (g = gn.getGrid()) != null && (sg = (ISecurityGrid)g.getCache(ISecurityGrid.class)).hasPermission(player, this.requiredPermission);
        }
        return true;
    }

    public GuiHostType getType() {
        return this.type;
    }

    public static void openGUI(@Nonnull EntityPlayer p, @Nullable TileEntity tile, @Nullable AEPartLocation side, @Nonnull ModGuiHandler type) {
        if (Platform.isClient()) {
            return;
        }
        int x = (int)p.field_70165_t;
        int y = (int)p.field_70163_u;
        int z = (int)p.field_70161_v;
        if (tile != null) {
            x = tile.func_174877_v().func_177958_n();
            y = tile.func_174877_v().func_177956_o();
            z = tile.func_174877_v().func_177952_p();
        }
        if (type.getType().isItem() && tile == null || type.hasPermissions(tile, x, y, z, side, p)) {
            if (tile == null && type.getType() == GuiHostType.ITEM) {
                p.openGui((Object)ThaumicTerminal.instance, type.ordinal() << 4, p.func_130014_f_(), p.field_71071_by.field_70461_c, 0, 0);
            } else if (tile == null || type.getType() == GuiHostType.ITEM) {
                p.openGui((Object)ThaumicTerminal.instance, type.ordinal() << 4 | 8, p.func_130014_f_(), x, y, z);
            } else {
                p.openGui((Object)ThaumicTerminal.instance, type.ordinal() << 4 | side.ordinal(), tile.func_145831_w(), x, y, z);
            }
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface GuiLink {
        public Class<?> value();
    }
}

