/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicterminal.part;

import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractPartDisplay;
import appeng.parts.reporting.AbstractPartTerminal;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import ftblag.thaumicterminal.init.ModGuiHandler;
import ftblag.thaumicterminal.part.IPartHasCustModel;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.world.aura.AuraChunk;
import thaumcraft.common.world.aura.AuraHandler;

public class PartArcaneTerminal
extends AbstractPartTerminal
implements IPartHasCustModel {
    @PartModels
    public static final ResourceLocation MODEL_OFF = new ResourceLocation("thaumicterminal", "parts/arcane_terminal_off");
    @PartModels
    public static final ResourceLocation MODEL_ON = new ResourceLocation("thaumicterminal", "parts/arcane_terminal_on");
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{AbstractPartDisplay.MODEL_BASE, MODEL_OFF, AbstractPartDisplay.MODEL_STATUS_OFF});
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{AbstractPartDisplay.MODEL_BASE, MODEL_ON, AbstractPartDisplay.MODEL_STATUS_ON});
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{AbstractPartDisplay.MODEL_BASE, MODEL_ON, AbstractPartDisplay.MODEL_STATUS_HAS_CHANNEL});
    public AppEngInternalInventory craft = new AppEngInternalInventory((IAEAppEngInventory)this, 15);
    public int auraVisServer;
    public int auraVisClient;

    public PartArcaneTerminal(ItemStack is) {
        super(is);
    }

    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL);
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (this.onPartActivate_wrench(player, hand, pos) || player.func_70093_af()) {
            return false;
        }
        if (Platform.isClient()) {
            return true;
        }
        ModGuiHandler.openGUI(player, this.getHost().getTile(), this.getSide(), ModGuiHandler.ME_ArcaneTerminal);
        return true;
    }

    private boolean onPartActivate_wrench(EntityPlayer player, EnumHand hand, Vec3d pos) {
        return !player.func_70093_af() && Platform.isWrench((EntityPlayer)player, (ItemStack)player.func_184586_b(hand), (BlockPos)this.getTile().func_174877_v()) && (!Platform.isServer() || super.onPartActivate(player, hand, pos));
    }

    @Override
    @Nonnull
    public ResourceLocation[] getModelsToRegister() {
        return new ResourceLocation[]{MODEL_OFF, MODEL_ON};
    }

    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        for (ItemStack is : this.craft) {
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.craft.readFromNBT(data, "craftingGrid");
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.craft.writeToNBT(data, "craftingGrid");
    }

    public IItemHandler getInventoryByName(String name) {
        if (name.equals("crafting")) {
            return this.craft;
        }
        return super.getInventoryByName(name);
    }

    public void getAura() {
        if (!this.getTile().func_145831_w().field_72995_K) {
            int t = 0;
            if (this.getTile().func_145831_w().func_180495_p(this.getTile().func_174877_v().func_177977_b()).func_177230_c() == BlocksTC.arcaneWorkbenchCharger) {
                int sx = this.getTile().func_174877_v().func_177958_n() >> 4;
                int sz = this.getTile().func_174877_v().func_177952_p() >> 4;
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int zz = -1; zz <= 1; ++zz) {
                        AuraChunk ac = AuraHandler.getAuraChunk((int)this.getTile().func_145831_w().field_73011_w.getDimension(), (int)(sx + xx), (int)(sz + zz));
                        if (ac == null) continue;
                        t += (int)ac.getVis();
                    }
                }
            } else {
                t = (int)AuraHandler.getVis((World)this.getTile().func_145831_w(), (BlockPos)this.getTile().func_174877_v());
            }
            this.auraVisServer = t;
        }
    }

    public void spendAura(int vis) {
        block8: {
            if (!this.getTile().func_145831_w().field_72995_K) {
                if (this.getTile().func_145831_w().func_180495_p(this.getTile().func_174877_v().func_177977_b()).func_177230_c() == BlocksTC.arcaneWorkbenchCharger) {
                    int q = vis;
                    int z = Math.max(1, vis / 9);
                    int attempts = 0;
                    while (q > 0) {
                        ++attempts;
                        for (int xx = -1; xx <= 1; ++xx) {
                            for (int zz = -1; zz <= 1; ++zz) {
                                if (z > q) {
                                    z = q;
                                }
                                if ((q -= (int)AuraHandler.drainVis((World)this.getTile().func_145831_w(), (BlockPos)this.getTile().func_174877_v().func_177982_a(xx * 16, 0, zz * 16), (float)z, (boolean)false)) > 0 && attempts <= 1000) {
                                    continue;
                                }
                                break block8;
                            }
                        }
                    }
                } else {
                    AuraHandler.drainVis((World)this.getTile().func_145831_w(), (BlockPos)this.getTile().func_174877_v(), (float)vis, (boolean)false);
                }
            }
        }
    }
}

