/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicterminal.utils;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class TTUtils {
    static int COMPARE_DAMAGE = 1;
    static int COMPARE_NBT = 2;
    static int COMPARE_QUANTITY = 4;

    public static boolean isEqual(@Nullable ItemStack left, @Nullable ItemStack right, int flags) {
        EnumActionResult validity = TTUtils.getResult(left, right);
        if (validity == EnumActionResult.FAIL || validity == EnumActionResult.SUCCESS) {
            return validity == EnumActionResult.SUCCESS;
        }
        if (left.func_77973_b() != right.func_77973_b()) {
            return false;
        }
        if ((flags & COMPARE_DAMAGE) == COMPARE_DAMAGE && left.func_77952_i() != Short.MAX_VALUE && right.func_77952_i() != Short.MAX_VALUE && left.func_77952_i() != right.func_77952_i()) {
            return false;
        }
        if ((flags & COMPARE_NBT) == COMPARE_NBT && !TTUtils.isEqualNbt(left, right)) {
            return false;
        }
        return (flags & COMPARE_QUANTITY) != COMPARE_QUANTITY || left.func_190916_E() == right.func_190916_E();
    }

    public static boolean isEqual(@Nullable FluidStack left, @Nullable FluidStack right, int flags) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null && right != null || left != null && right == null) {
            return false;
        }
        if (left.getFluid() != right.getFluid()) {
            return false;
        }
        if ((flags & COMPARE_QUANTITY) == COMPARE_QUANTITY && left.amount != right.amount) {
            return false;
        }
        return (flags & COMPARE_NBT) != COMPARE_NBT || left.tag == null || left.tag.equals((Object)right.tag);
    }

    public static boolean isEqualNbt(@Nullable ItemStack left, @Nullable ItemStack right) {
        EnumActionResult validity = TTUtils.getResult(left, right);
        if (validity == EnumActionResult.FAIL || validity == EnumActionResult.SUCCESS) {
            return validity == EnumActionResult.SUCCESS;
        }
        if (!ItemStack.func_77970_a((ItemStack)left, (ItemStack)right)) {
            if (left.func_77942_o() && !right.func_77942_o() && left.func_77978_p().func_82582_d()) {
                return true;
            }
            if (!left.func_77942_o() && right.func_77942_o() && right.func_77978_p().func_82582_d()) {
                return true;
            }
            return !left.func_77942_o() && !right.func_77942_o();
        }
        return true;
    }

    private static EnumActionResult getResult(@Nullable ItemStack left, @Nullable ItemStack right) {
        if (left == null && right == null) {
            return EnumActionResult.SUCCESS;
        }
        if (left == null && right != null || left != null && right == null) {
            return EnumActionResult.FAIL;
        }
        boolean leftEmpty = left.func_190926_b();
        boolean rightEmpty = right.func_190926_b();
        if (leftEmpty && rightEmpty) {
            return EnumActionResult.SUCCESS;
        }
        if (leftEmpty && !rightEmpty || !leftEmpty && rightEmpty) {
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    public static Aspect getAspect0(ItemStack itemstack) {
        if (itemstack.func_77942_o()) {
            AspectList aspects = new AspectList();
            aspects.readFromNBT(itemstack.func_77978_p());
            return aspects.size() > 0 ? aspects.getAspects()[0] : null;
        }
        return null;
    }
}

