/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.gasconduits.common.network;

import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.conduits.network.AbstractConduitPacket;
import crazypants.enderio.util.EnumReader;
import gg.galaxygaming.gasconduits.common.conduit.IGasConduit;
import gg.galaxygaming.gasconduits.common.conduit.ender.EnderGasConduit;
import gg.galaxygaming.gasconduits.common.filter.GasFilter;
import gg.galaxygaming.gasconduits.common.filter.IGasFilter;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGasFilter
extends AbstractConduitPacket<IGasConduit> {
    private EnumFacing dir;
    private boolean isInput;
    private IGasFilter filter;

    public PacketGasFilter() {
    }

    public PacketGasFilter(EnderGasConduit eConduit, EnumFacing dir, IGasFilter filter, boolean isInput) {
        super((IConduit)eConduit);
        this.dir = dir;
        this.filter = filter;
        this.isInput = isInput;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.dir != null) {
            buf.writeShort(this.dir.ordinal());
        } else {
            buf.writeShort(-1);
        }
        buf.writeBoolean(this.isInput);
        NBTTagCompound tag = new NBTTagCompound();
        this.filter.writeToNBT(tag);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        short ord = buf.readShort();
        this.dir = ord < 0 ? null : (EnumFacing)EnumReader.get(EnumFacing.class, (int)ord);
        this.isInput = buf.readBoolean();
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.filter = new GasFilter();
        if (tag != null) {
            this.filter.readFromNBT(tag);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketGasFilter, IMessage> {
        public IMessage onMessage(PacketGasFilter message, MessageContext ctx) {
            IGasConduit conduit = (IGasConduit)message.getConduit(ctx);
            if (conduit instanceof EnderGasConduit) {
                ((EnderGasConduit)conduit).setFilter(message.dir, message.filter, message.isInput);
                World world = message.getWorld(ctx);
                IBlockState bs = world.func_180495_p(message.getPos());
                world.func_184138_a(message.getPos(), bs, bs, 3);
            }
            return null;
        }
    }
}

