/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.api;

import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.common.connection.FluxNetworkCache;
import fluxnetworks.common.tileentity.TileFluxCore;
import net.minecraft.nbt.NBTTagCompound;

public class FluxConfigurationType {
    public static FluxConfigurationType NETWORK = new FluxConfigurationType(0, "network", FluxConfigurationType::copyNetwork, FluxConfigurationType::pasteNetwork);
    public static FluxConfigurationType PRIORITY = new FluxConfigurationType(2, "priority", FluxConfigurationType::copyPriority, FluxConfigurationType::pastePriority);
    public static FluxConfigurationType PRIORITY_SETTING = new FluxConfigurationType(3, "p_setting", FluxConfigurationType::copyPrioritySetting, FluxConfigurationType::pastePrioritySetting);
    public static FluxConfigurationType TRANSFER = new FluxConfigurationType(4, "transfer", FluxConfigurationType::copyTransfer, FluxConfigurationType::pasteTransfer);
    public static FluxConfigurationType TRANSFER_SETTING = new FluxConfigurationType(5, "t_setting", FluxConfigurationType::copyTransferSetting, FluxConfigurationType::pasteTransferSetting);
    public static FluxConfigurationType[] VALUES = new FluxConfigurationType[]{NETWORK, PRIORITY, PRIORITY_SETTING, TRANSFER, TRANSFER_SETTING};
    public int ordinal;
    public String key;
    public ICopyMethod copy;
    public IPasteMethod paste;

    public FluxConfigurationType(int ordinal, String key, ICopyMethod copy, IPasteMethod paste) {
        this.ordinal = ordinal;
        this.key = key;
        this.copy = copy;
        this.paste = paste;
    }

    public String getNBTName() {
        return this.key;
    }

    public static void copyNetwork(NBTTagCompound nbt, String key, TileFluxCore tile) {
        if (!tile.getNetwork().isInvalid() && tile.getNetworkID() != -1) {
            nbt.func_74768_a(key, tile.getNetworkID());
        }
    }

    public static void pasteNetwork(NBTTagCompound nbt, String key, TileFluxCore tile) {
        int storedID = nbt.func_74762_e(key);
        if (storedID != -1) {
            IFluxNetwork newNetwork = FluxNetworkCache.instance.getNetwork(storedID);
            tile.getNetwork().queueConnectionRemoval(tile, false);
            newNetwork.queueConnectionAddition(tile);
        }
    }

    public static void copyPriority(NBTTagCompound nbt, String key, TileFluxCore tile) {
        nbt.func_74768_a(key, tile.getPriority());
    }

    public static void pastePriority(NBTTagCompound nbt, String key, TileFluxCore tile) {
        tile.priority = nbt.func_74762_e(key);
    }

    public static void copyPrioritySetting(NBTTagCompound nbt, String key, TileFluxCore tile) {
        nbt.func_74757_a(key, tile.surgeMode);
    }

    public static void pastePrioritySetting(NBTTagCompound nbt, String key, TileFluxCore tile) {
        tile.surgeMode = nbt.func_74767_n(key);
    }

    public static void copyTransfer(NBTTagCompound nbt, String key, TileFluxCore tile) {
        nbt.func_74772_a(key, tile.limit);
    }

    public static void pasteTransfer(NBTTagCompound nbt, String key, TileFluxCore tile) {
        tile.limit = nbt.func_74763_f(key);
    }

    public static void copyTransferSetting(NBTTagCompound nbt, String key, TileFluxCore tile) {
        nbt.func_74757_a(key, tile.disableLimit);
    }

    public static void pasteTransferSetting(NBTTagCompound nbt, String key, TileFluxCore tile) {
        tile.disableLimit = nbt.func_74767_n(key);
    }

    public static interface IPasteMethod<T> {
        public void pasteToTile(NBTTagCompound var1, String var2, TileFluxCore var3);
    }

    public static interface ICopyMethod<T> {
        public void copyFromTile(NBTTagCompound var1, String var2, TileFluxCore var3);
    }
}

