/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.api.network;

import com.google.common.collect.Lists;
import fluxnetworks.api.tileentity.IFluxConnector;
import fluxnetworks.api.tileentity.IFluxController;
import fluxnetworks.api.tileentity.IFluxPlug;
import fluxnetworks.api.tileentity.IFluxPoint;
import fluxnetworks.api.tileentity.IFluxStorage;
import java.util.ArrayList;
import java.util.List;

public class FluxType<T extends IFluxConnector> {
    public static final FluxType flux = new FluxType<IFluxConnector>(IFluxConnector.class);
    public static final FluxType plug = new FluxType<IFluxPlug>(IFluxPlug.class);
    public static final FluxType point = new FluxType<IFluxPoint>(IFluxPoint.class);
    public static final FluxType storage = new FluxType<IFluxStorage>(IFluxStorage.class);
    public static final FluxType controller = new FluxType<IFluxController>(IFluxController.class);
    public Class<T> clazz;
    public static final List<FluxType> types = Lists.newArrayList((Object[])new FluxType[]{flux, plug, point, storage, controller});

    public FluxType(Class<T> clazz) {
        this.clazz = clazz;
    }

    public static List<FluxType> getValidTypes(IFluxConnector tile) {
        ArrayList<FluxType> valid = new ArrayList<FluxType>();
        for (FluxType handler : types) {
            if (!handler.clazz.isInstance(tile)) continue;
            valid.add(handler);
        }
        return valid;
    }
}

