/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui;

import fluxnetworks.FluxNetworks;
import fluxnetworks.FluxTranslate;
import fluxnetworks.client.gui.basic.GuiFluxCore;
import fluxnetworks.client.gui.basic.GuiTextField;
import fluxnetworks.client.gui.button.NavigationButton;
import fluxnetworks.client.gui.button.SlidedSwitchButton;
import fluxnetworks.client.gui.button.TextboxButton;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.core.NBTType;
import fluxnetworks.common.handler.PacketHandler;
import fluxnetworks.common.network.PacketByteBuf;
import fluxnetworks.common.network.PacketNetworkUpdateRequest;
import fluxnetworks.common.network.PacketTile;
import fluxnetworks.common.network.PacketTileHandler;
import fluxnetworks.common.network.PacketTileType;
import fluxnetworks.common.tileentity.TileFluxCore;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiFluxHome
extends GuiFluxCore {
    public TextboxButton fluxName;
    public TextboxButton priority;
    public TextboxButton limit;
    public SlidedSwitchButton surge;
    public SlidedSwitchButton disableLimit;
    public SlidedSwitchButton chunkLoad;
    private int timer;

    public GuiFluxHome(EntityPlayer player, TileFluxCore tileEntity) {
        super(player, tileEntity);
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        this.renderNetwork(this.network.getSetting(NetworkSettings.NETWORK_NAME), this.network.getSetting(NetworkSettings.NETWORK_COLOR), 20, 8);
        this.renderTransfer(this.tileEntity.getTransferHandler(), 0xFFFFFF, 30, 90);
        this.func_73732_a(this.field_146289_q, TextFormatting.RED + FluxNetworks.proxy.getFeedback().getInfo(), 89, 150, 0xFFFFFF);
        if (!this.tileEntity.getConnectionType().isStorage()) {
            this.field_146289_q.func_78276_b(FluxTranslate.SURGE_MODE.t(), 20, 120, this.network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
            this.field_146289_q.func_78276_b(FluxTranslate.DISABLE_LIMIT.t(), 20, 132, this.network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
            this.field_146289_q.func_78276_b(FluxTranslate.CHUNK_LOADING.t(), 20, 144, this.network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
        }
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        super.drawBackgroundLayer(partialTicks, mouseX, mouseY);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int color = this.network.getSetting(NetworkSettings.NETWORK_COLOR) | 0xFF000000;
        this.fluxName = TextboxButton.create(this, FluxTranslate.NAME.t() + ": ", 0, this.field_146289_q, 16, 28, 144, 12).setOutlineColor(color);
        this.fluxName.setMaxStringLength(24);
        this.fluxName.setText(this.tileEntity.getCustomName());
        this.priority = TextboxButton.create(this, FluxTranslate.PRIORITY.t() + ": ", 1, this.field_146289_q, 16, 45, 144, 12).setOutlineColor(color).setDigitsOnly();
        this.priority.setMaxStringLength(5);
        this.priority.setText(String.valueOf(this.tileEntity.priority));
        this.limit = TextboxButton.create(this, FluxTranslate.TRANSFER_LIMIT.t() + ": ", 2, this.field_146289_q, 16, 62, 144, 12).setOutlineColor(color).setDigitsOnly();
        this.limit.setMaxStringLength(9);
        this.limit.setText(String.valueOf(this.tileEntity.limit));
        for (int i = 0; i < 7; ++i) {
            this.navigationButtons.add(new NavigationButton(this.field_146294_l / 2 - 75 + 18 * i, this.field_146295_m / 2 - 99, i));
        }
        this.navigationButtons.add(new NavigationButton(this.field_146294_l / 2 + 59, this.field_146295_m / 2 - 99, 7));
        ((NavigationButton)((Object)this.navigationButtons.get(0))).setMain();
        if (!this.tileEntity.getConnectionType().isStorage()) {
            this.surge = new SlidedSwitchButton(140, 120, 1, this.field_147003_i, this.field_147009_r, this.tileEntity.surgeMode);
            this.disableLimit = new SlidedSwitchButton(140, 132, 2, this.field_147003_i, this.field_147009_r, this.tileEntity.disableLimit);
            this.chunkLoad = new SlidedSwitchButton(140, 144, 3, this.field_147003_i, this.field_147009_r, this.tileEntity.chunkLoading);
            this.switches.add(this.surge);
            this.switches.add(this.disableLimit);
            this.switches.add(this.chunkLoad);
        }
        this.textBoxes.add(this.fluxName);
        this.textBoxes.add(this.priority);
        this.textBoxes.add(this.limit);
    }

    @Override
    public void onTextBoxChanged(TextboxButton text) {
        if (text == this.fluxName) {
            this.tileEntity.customName = this.fluxName.getText();
            PacketHandler.network.sendToServer((IMessage)new PacketByteBuf.ByteBufMessage(this.tileEntity, this.tileEntity.func_174877_v(), 1));
        } else if (text == this.priority) {
            this.tileEntity.priority = this.priority.getIntegerFromText(false);
            PacketHandler.network.sendToServer((IMessage)new PacketByteBuf.ByteBufMessage(this.tileEntity, this.tileEntity.func_174877_v(), 2));
        } else if (text == this.limit) {
            this.tileEntity.limit = !this.tileEntity.getConnectionType().isStorage() ? this.limit.getLongFromText(true) : this.tileEntity.getCurrentLimit();
            this.limit.setText(String.valueOf(this.tileEntity.limit));
            PacketHandler.network.sendToServer((IMessage)new PacketByteBuf.ByteBufMessage(this.tileEntity, this.tileEntity.func_174877_v(), 3));
        }
    }

    @Override
    protected void mouseMainClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseMainClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            for (SlidedSwitchButton s : this.switches) {
                if (!s.isMouseHovered(this.field_146297_k, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) continue;
                s.switchButton();
                switch (s.id) {
                    case 1: {
                        this.tileEntity.surgeMode = s.slideControl;
                        PacketHandler.network.sendToServer((IMessage)new PacketByteBuf.ByteBufMessage(this.tileEntity, this.tileEntity.func_174877_v(), 4));
                        break;
                    }
                    case 2: {
                        this.tileEntity.disableLimit = s.slideControl;
                        PacketHandler.network.sendToServer((IMessage)new PacketByteBuf.ByteBufMessage(this.tileEntity, this.tileEntity.func_174877_v(), 5));
                        break;
                    }
                    case 3: {
                        PacketHandler.network.sendToServer((IMessage)new PacketTile.TileMessage(PacketTileType.CHUNK_LOADING, PacketTileHandler.getChunkLoadPacket(s.slideControl), this.tileEntity.func_174877_v(), this.tileEntity.func_145831_w().field_73011_w.getDimension()));
                    }
                }
            }
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.timer == 0) {
            PacketHandler.network.sendToServer((IMessage)new PacketNetworkUpdateRequest.UpdateRequestMessage(this.network.getNetworkID(), NBTType.NETWORK_GENERAL));
        }
        if (this.timer % 4 == 0) {
            if (this.chunkLoad != null) {
                this.chunkLoad.slideControl = this.tileEntity.chunkLoading;
            }
            if (this.surge != null) {
                this.surge.slideControl = this.tileEntity.surgeMode;
            }
            if (this.disableLimit != null) {
                this.disableLimit.slideControl = this.tileEntity.disableLimit;
            }
        }
        ++this.timer;
        this.timer %= 100;
    }

    @Override
    protected void keyTypedMain(char c, int k) throws IOException {
        super.keyTypedMain(c, k);
        if ((k == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(k)) && this.textBoxes.stream().noneMatch(GuiTextField::isFocused)) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }
}

