/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui.basic;

import com.google.common.collect.Lists;
import fluxnetworks.FluxNetworks;
import fluxnetworks.api.FeedbackInfo;
import fluxnetworks.client.gui.basic.ITextBoxButton;
import fluxnetworks.client.gui.button.NavigationButton;
import fluxnetworks.client.gui.button.NormalButton;
import fluxnetworks.client.gui.button.SlidedSwitchButton;
import fluxnetworks.client.gui.button.TextboxButton;
import fluxnetworks.common.core.ContainerCore;
import fluxnetworks.common.tileentity.TileFluxCore;
import java.awt.Color;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public abstract class GuiCore
extends GuiContainer
implements ITextBoxButton {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("fluxnetworks", "textures/gui/gui_default_background.png");
    public static final ResourceLocation FRAME = new ResourceLocation("fluxnetworks", "textures/gui/gui_default_frame.png");
    public static final ResourceLocation GUI_BAR = new ResourceLocation("fluxnetworks", "textures/gui/gui_bar.png");
    public static final ResourceLocation INVENTORY = new ResourceLocation("fluxnetworks", "textures/gui/inventory_configuration.png");
    public static final ResourceLocation BUTTONS = new ResourceLocation("fluxnetworks", "textures/gui/gui_button.png");
    protected List<NormalButton> buttons = Lists.newArrayList();
    protected List<NavigationButton> navigationButtons = Lists.newArrayList();
    protected List<TextboxButton> textBoxes = Lists.newArrayList();
    protected List<TextboxButton> popBoxes = Lists.newArrayList();
    protected List<SlidedSwitchButton> switches = Lists.newArrayList();
    public TileFluxCore tileEntity;
    public EntityPlayer player;
    protected boolean main = true;

    public GuiCore(EntityPlayer player, TileFluxCore tileEntity) {
        super((Container)new ContainerCore(player, tileEntity));
        this.player = player;
        this.tileEntity = tileEntity;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.drawForegroundLayer(mouseX, mouseY);
        if (!this.main) {
            this.func_73733_a(0 - this.field_147003_i, 0 - this.field_147009_r, this.field_146294_l, this.field_146295_m, -1609560048, -1341124592);
            this.drawPopupForegroundLayer(mouseX, mouseY);
        }
    }

    protected void drawForegroundLayer(int mouseX, int mouseY) {
        this.textBoxes.forEach(TextboxButton::drawTextBox);
        for (NormalButton normalButton : this.buttons) {
            normalButton.drawButton(this.field_146297_k, mouseX, mouseY, this.field_147003_i, this.field_147009_r);
        }
        for (SlidedSwitchButton slidedSwitchButton : this.switches) {
            slidedSwitchButton.drawButton(this.field_146297_k, mouseX, mouseY);
        }
    }

    protected void drawPopupForegroundLayer(int mouseX, int mouseY) {
        this.popBoxes.forEach(TextboxButton::drawTextBox);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawFluxDefaultBackground();
        this.drawBackgroundLayer(partialTicks, mouseX, mouseY);
        GlStateManager.func_179121_F();
    }

    protected void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        for (NavigationButton navigationButton : this.navigationButtons) {
            navigationButton.drawButton(this.field_146297_k, mouseX, mouseY);
        }
        for (SlidedSwitchButton slidedSwitchButton : this.switches) {
            slidedSwitchButton.updatePosition(partialTicks * 4.0f);
        }
    }

    protected void drawFluxDefaultBackground() {
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73876_c() {
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (TextboxButton text : this.textBoxes) {
            text.mouseClicked(mouseX - this.field_147003_i, mouseY - this.field_147009_r, mouseButton);
        }
        if (this.main) {
            this.mouseMainClicked(mouseX, mouseY, mouseButton);
        } else {
            this.mousePopupClicked(mouseX, mouseY, mouseButton);
        }
    }

    protected void mouseMainClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
    }

    protected void mousePopupClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (!this.main) {
            return;
        }
        int i = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int j = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int k = Integer.signum(Mouse.getEventDWheel());
        if (k != 0) {
            this.mouseScroll(i, j, k);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.main) {
            this.keyTypedMain(typedChar, keyCode);
        } else {
            this.keyTypedPop(typedChar, keyCode);
        }
    }

    protected void keyTypedMain(char c, int k) throws IOException {
        for (TextboxButton text : this.textBoxes) {
            if (!text.isFocused()) continue;
            text.textboxKeyTyped(c, k);
        }
    }

    protected void keyTypedPop(char c, int k) throws IOException {
    }

    public void mouseScroll(int mouseX, int mouseY, int scroll) throws IOException {
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        this.buttons.clear();
        this.switches.clear();
        this.navigationButtons.clear();
        this.textBoxes.clear();
        super.func_146280_a(mc, width, height);
    }

    public void func_146281_b() {
        super.func_146281_b();
        FluxNetworks.proxy.setFeedback(FeedbackInfo.NONE);
    }

    public void drawColorRect(int x, int y, int height, int width, int color) {
        GuiCore.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + width + 1), (int)y, (int)color);
        GuiCore.func_73734_a((int)(x - 1), (int)(y + height), (int)(x + width + 1), (int)(y + height + 1), (int)color);
        GuiCore.func_73734_a((int)(x - 1), (int)y, (int)x, (int)(y + height), (int)color);
        GuiCore.func_73734_a((int)(x + width), (int)y, (int)(x + width + 1), (int)(y + height), (int)color);
    }

    public void drawRectWithBackground(int x, int y, int height, int width, int frameColor, int backColor) {
        GuiCore.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + width + 1), (int)y, (int)frameColor);
        GuiCore.func_73734_a((int)(x - 1), (int)(y + height), (int)(x + width + 1), (int)(y + height + 1), (int)frameColor);
        GuiCore.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)backColor);
    }

    protected void drawHoverTooltip(List<String> strings, int x, int y) {
        AtomicInteger maxLength = new AtomicInteger();
        strings.forEach(a -> maxLength.set(Math.max(this.field_146289_q.func_78256_a(a), maxLength.get())));
        this.drawRectWithBackground(x, y, strings.size() * 9 + 3, maxLength.get() + 4, -2130706433, -1073741824);
        int i = 0;
        for (String s : strings) {
            this.field_146289_q.func_78276_b(s, x + 2, y + 2 + 9 * i, 0xFFFFFF);
            ++i;
        }
    }

    protected void drawHoverTooltip(String text, int x, int y) {
        int maxLength = this.field_146289_q.func_78256_a(text);
        GuiCore.func_73734_a((int)x, (int)y, (int)(x + maxLength + 4), (int)(y + 12), (int)Integer.MIN_VALUE);
        this.field_146289_q.func_78276_b(text, x + 2, y + 2, Color.GREEN.getRGB());
    }
}

