/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui.basic;

import com.google.common.collect.Lists;
import fluxnetworks.FluxConfig;
import fluxnetworks.FluxTranslate;
import fluxnetworks.api.ConnectionType;
import fluxnetworks.api.EnergyType;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.api.network.ITransferHandler;
import fluxnetworks.api.tileentity.IFluxConnector;
import fluxnetworks.client.gui.basic.GuiCore;
import fluxnetworks.client.gui.button.NavigationButton;
import fluxnetworks.common.connection.FluxNetworkCache;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.core.FluxUtils;
import fluxnetworks.common.registry.RegistrySounds;
import fluxnetworks.common.tileentity.TileFluxCore;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;

public abstract class GuiFluxCore
extends GuiCore {
    public IFluxNetwork network;
    protected boolean networkValid;
    private int timer1;

    public GuiFluxCore(EntityPlayer player, TileFluxCore tileEntity) {
        super(player, tileEntity);
        this.network = FluxNetworkCache.instance.getClientNetwork(tileEntity.networkID);
        this.networkValid = !this.network.isInvalid();
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
    }

    @Override
    protected void drawPopupForegroundLayer(int mouseX, int mouseY) {
        super.drawPopupForegroundLayer(mouseX, mouseY);
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        super.drawBackgroundLayer(partialTicks, mouseX, mouseY);
    }

    @Override
    protected void mouseMainClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseMainClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            for (NavigationButton button : this.navigationButtons) {
                if (!button.isMouseHovered(this.field_146297_k, mouseX, mouseY)) continue;
                button.switchTab(button.buttonNavigationId, this.player, this.tileEntity);
                if (!FluxConfig.enableButtonSound) continue;
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)RegistrySounds.BUTTON_CLICK, (float)1.0f));
            }
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.timer1 == 0) {
            this.network = FluxNetworkCache.instance.getClientNetwork(this.tileEntity.networkID);
            this.networkValid = !this.network.isInvalid();
        }
        ++this.timer1;
        this.timer1 %= 20;
    }

    @Override
    protected void drawFluxDefaultBackground() {
        GlStateManager.func_179094_E();
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(this.field_146294_l / 2 - 128, this.field_146295_m / 2 - 128, 0, 0, 256, 256);
        float f = (float)(this.network.getSetting(NetworkSettings.NETWORK_COLOR) >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(this.network.getSetting(NetworkSettings.NETWORK_COLOR) >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(this.network.getSetting(NetworkSettings.NETWORK_COLOR) & 0xFF) / 255.0f;
        GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
        this.field_146297_k.func_110434_K().func_110577_a(FRAME);
        this.func_73729_b(this.field_146294_l / 2 - 128, this.field_146295_m / 2 - 128, 0, 0, 256, 256);
        GlStateManager.func_179121_F();
    }

    protected void renderNetwork(String name, int color, int x, int y) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_BAR);
        this.func_73729_b(x, y, 0, 0, 135, 12);
        this.field_146289_q.func_78276_b(name, x + 4, y + 2, 0xFFFFFF);
        GlStateManager.func_179121_F();
    }

    protected void renderTransfer(ITransferHandler handler, int color, int x, int y) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146289_q.func_78276_b(this.getTransferInfo(this.tileEntity.getConnectionType(), this.network.getSetting(NetworkSettings.NETWORK_ENERGY), handler.getChange()), x, y, color);
        this.field_146289_q.func_78276_b(FluxTranslate.BUFFER.t() + ": " + TextFormatting.BLUE + FluxUtils.format(handler.getBuffer(), FluxUtils.TypeNumberFormat.COMMAS, this.network.getSetting(NetworkSettings.NETWORK_ENERGY), false), x, y + 10, 0xFFFFFF);
        this.renderItemStack(this.tileEntity.getDisplayStack(), x - 20, y + 1);
        GlStateManager.func_179121_F();
    }

    protected void renderItemStack(ItemStack stack, int x, int y) {
        GlStateManager.func_179126_j();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        RenderHelper.func_74520_c();
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(this.field_146289_q, stack, x, y, "");
        RenderHelper.func_74518_a();
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        GlStateManager.func_179097_i();
    }

    protected List<String> getFluxInfo(IFluxConnector flux) {
        ArrayList list = Lists.newArrayList();
        list.add(TextFormatting.BOLD + flux.getCustomName());
        NBTTagCompound tag = flux.getDisplayStack().func_179543_a("FluxData");
        if (flux.isChunkLoaded()) {
            if (flux.isForcedLoading()) {
                list.add(TextFormatting.AQUA + FluxTranslate.FORCED_LOADING.t());
            }
            list.add(this.getTransferInfo(flux.getConnectionType(), this.network.getSetting(NetworkSettings.NETWORK_ENERGY), flux.getChange()));
            if (flux.getConnectionType() == ConnectionType.STORAGE) {
                list.add(FluxTranslate.ENERGY_STORED.t() + ": " + TextFormatting.BLUE + NumberFormat.getInstance().format(flux.getBuffer()) + "RF");
            } else {
                list.add(FluxTranslate.INTERNAL_BUFFER.t() + ": " + TextFormatting.BLUE + NumberFormat.getInstance().format(flux.getBuffer()) + "RF");
            }
        } else {
            list.add(TextFormatting.RED + FluxTranslate.CHUNK_UNLOADED.t());
            if (tag != null) {
                if (tag.func_74764_b("energy")) {
                    list.add(FluxTranslate.ENERGY_STORED.t() + ": " + TextFormatting.BLUE + NumberFormat.getInstance().format(tag.func_74762_e("energy")) + "RF");
                } else {
                    list.add(FluxTranslate.INTERNAL_BUFFER.t() + ": " + TextFormatting.BLUE + NumberFormat.getInstance().format(tag.func_74763_f("buffer")) + "RF");
                }
            }
        }
        list.add(FluxTranslate.TRANSFER_LIMIT.t() + ": " + TextFormatting.GREEN + (flux.getDisableLimit() ? FluxTranslate.UNLIMITED.t() : Long.valueOf(flux.getCurrentLimit())));
        list.add(FluxTranslate.PRIORITY.t() + ": " + TextFormatting.GREEN + (flux.getSurgeMode() ? FluxTranslate.SURGE.t() : Integer.valueOf(flux.getPriority())));
        list.add(TextFormatting.ITALIC + flux.getCoords().getStringInfo());
        return list;
    }

    protected String getTransferInfo(ConnectionType type, EnergyType energyType, long change) {
        if (type.canAddEnergy()) {
            String b = FluxUtils.format(change, FluxUtils.TypeNumberFormat.COMMAS, energyType, true);
            if (change == 0L) {
                return FluxTranslate.INPUT.t() + ": " + TextFormatting.GOLD + b;
            }
            return FluxTranslate.INPUT.t() + ": " + TextFormatting.GREEN + "+" + b;
        }
        if (type.canRemoveEnergy() || type.isController()) {
            String b = FluxUtils.format(-change, FluxUtils.TypeNumberFormat.COMMAS, energyType, true);
            if (change == 0L) {
                return FluxTranslate.OUTPUT.t() + ": " + TextFormatting.GOLD + b;
            }
            return FluxTranslate.OUTPUT.t() + ": " + TextFormatting.RED + "-" + b;
        }
        if (type == ConnectionType.STORAGE) {
            if (change == 0L) {
                return FluxTranslate.CHANGE.t() + ": " + TextFormatting.GOLD + change + energyType.getUsageSuffix();
            }
            if (change > 0L) {
                return FluxTranslate.CHANGE.t() + ": " + TextFormatting.RED + "-" + FluxUtils.format(change, FluxUtils.TypeNumberFormat.COMMAS, energyType, true);
            }
            return FluxTranslate.CHANGE.t() + ": " + TextFormatting.GREEN + "+" + FluxUtils.format(-change, FluxUtils.TypeNumberFormat.COMMAS, energyType, true);
        }
        return "";
    }

    protected void renderNavigationPrompt(String error, String prompt) {
        GlStateManager.func_179094_E();
        this.func_73732_a(this.field_146289_q, error, this.field_146999_f / 2, 16, 0x808080);
        GlStateManager.func_179139_a((double)0.625, (double)0.625, (double)0.625);
        this.func_73732_a(this.field_146289_q, FluxTranslate.CLICK.t() + TextFormatting.AQUA + ' ' + prompt + ' ' + TextFormatting.RESET + FluxTranslate.ABOVE.t(), (int)((double)(this.field_146999_f / 2) * 1.6), 41, 0x808080);
        GlStateManager.func_179139_a((double)1.6, (double)1.6, (double)1.6);
        GlStateManager.func_179121_F();
    }
}

