/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui.basic;

import com.google.common.collect.Lists;
import fluxnetworks.FluxConfig;
import fluxnetworks.FluxNetworks;
import fluxnetworks.api.FeedbackInfo;
import fluxnetworks.client.gui.GuiFluxHome;
import fluxnetworks.client.gui.basic.GuiFluxCore;
import fluxnetworks.client.gui.basic.GuiTextField;
import fluxnetworks.client.gui.button.NormalButton;
import fluxnetworks.client.gui.button.TextboxButton;
import fluxnetworks.common.registry.RegistrySounds;
import fluxnetworks.common.tileentity.TileFluxCore;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class GuiTabCore
extends GuiFluxCore {
    protected List<NormalButton> popButtons = Lists.newArrayList();

    public GuiTabCore(EntityPlayer player, TileFluxCore tileEntity) {
        super(player, tileEntity);
    }

    @Override
    protected void drawPopupForegroundLayer(int mouseX, int mouseY) {
        super.drawPopupForegroundLayer(mouseX, mouseY);
        for (NormalButton button : this.popButtons) {
            button.drawButton(this.field_146297_k, mouseX, mouseY, this.field_147003_i, this.field_147009_r);
        }
    }

    @Override
    protected void keyTypedMain(char c, int k) throws IOException {
        super.keyTypedMain(c, k);
        if ((k == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(k)) && this.textBoxes.stream().noneMatch(GuiTextField::isFocused)) {
            FMLCommonHandler.instance().showGuiScreen((Object)new GuiFluxHome(this.player, this.tileEntity));
            FluxNetworks.proxy.setFeedback(FeedbackInfo.NONE);
            if (FluxConfig.enableButtonSound) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)RegistrySounds.BUTTON_CLICK, (float)1.0f));
            }
        }
    }

    @Override
    protected void keyTypedPop(char c, int k) throws IOException {
        super.keyTypedPop(c, k);
        if ((k == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(k)) && this.popBoxes.stream().noneMatch(GuiTextField::isFocused)) {
            this.backToMain();
        }
        for (TextboxButton text : this.popBoxes) {
            if (!text.isFocused()) continue;
            text.textboxKeyTyped(c, k);
        }
    }

    @Override
    protected void mousePopupClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mousePopupClicked(mouseX, mouseY, mouseButton);
        for (TextboxButton text : this.popBoxes) {
            text.mouseClicked(mouseX - this.field_147003_i, mouseY - this.field_147009_r, mouseButton);
        }
    }

    protected void backToMain() {
        this.main = true;
        this.popButtons.clear();
        this.popBoxes.clear();
        FluxNetworks.proxy.setFeedback(FeedbackInfo.NONE);
    }
}

