/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui.basic;

import com.google.common.collect.Lists;
import fluxnetworks.client.gui.basic.GuiTabCore;
import fluxnetworks.common.tileentity.TileFluxCore;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public abstract class GuiTabPages<T>
extends GuiTabCore {
    public List<T> elements = Lists.newArrayList();
    protected List<T> current = Lists.newArrayList();
    protected SortType sortType = SortType.ID;
    public int page = 1;
    public int currentPages = 1;
    public int pages = 1;
    public int gridPerPage = 1;
    public int gridStartX = 0;
    public int gridStartY = 0;
    public int gridHeight = 0;
    public int elementHeight = 0;
    public int elementWidth = 0;

    public GuiTabPages(EntityPlayer player, TileFluxCore tileEntity) {
        super(player, tileEntity);
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        int y;
        super.drawForegroundLayer(mouseX, mouseY);
        int i = 0;
        for (T s : this.current) {
            y = this.gridStartY + this.gridHeight * i;
            this.renderElement(s, this.gridStartX, y);
            ++i;
        }
        i = 0;
        for (T s : this.current) {
            y = this.gridStartY + this.gridHeight * i;
            if (mouseX >= this.gridStartX + this.field_147003_i && mouseY >= y + this.field_147009_r && mouseX < this.gridStartX + this.elementWidth + this.field_147003_i && mouseY < y + this.elementHeight + this.field_147009_r) {
                this.renderElementTooltip(s, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            }
            ++i;
        }
        if (this.pages > 1) {
            this.func_73732_a(this.field_146289_q, this.page + " / " + this.pages, 89, 156, 0xFFFFFF);
        }
    }

    public <T> T getHoveredElement(int mouseX, int mouseY) {
        if (this.currentPages == 0) {
            return null;
        }
        for (int i = 0; i < this.currentPages; ++i) {
            int y = this.gridStartY + this.gridHeight * i;
            if (mouseX < this.gridStartX || mouseY < y || mouseX >= this.gridStartX + this.elementWidth || mouseY >= y + this.elementHeight || this.current.get(i) == null) continue;
            return this.current.get(i);
        }
        return null;
    }

    protected abstract void onElementClicked(T var1, int var2);

    @Override
    protected void mouseMainClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseMainClicked(mouseX, mouseY, mouseButton);
        T e = this.getHoveredElement(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        if (e != null) {
            this.onElementClicked(e, mouseButton);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    @Override
    public void mouseScroll(int mouseX, int mouseY, int scroll) throws IOException {
        super.mouseScroll(mouseX, mouseY, scroll);
        if (scroll == -1 && this.page < this.pages) {
            ++this.page;
            this.refreshCurrentPage();
        } else if (scroll == 1 && this.page > 1) {
            --this.page;
            this.refreshCurrentPage();
        }
    }

    public abstract void renderElement(T var1, int var2, int var3);

    public abstract void renderElementTooltip(T var1, int var2, int var3);

    protected void refreshPages(List<T> elements) {
        this.elements = elements;
        this.pages = (int)Math.ceil((double)elements.size() / (double)this.gridPerPage);
        this.sortGrids(this.sortType);
        this.refreshCurrentPage();
    }

    protected void refreshCurrentPage() {
        if (this.elements.size() == 0) {
            return;
        }
        this.current.clear();
        int a = (this.page - 1) * this.gridPerPage;
        int b = Math.min(this.elements.size(), this.page * this.gridPerPage);
        this.currentPages = b - a;
        for (int i = a; i < b; ++i) {
            this.current.add(this.elements.get(i));
        }
    }

    protected void sortGrids(SortType sortType) {
    }

    public static enum SortType {
        ID("ID"),
        NAME("Name");

        public String name;

        private SortType(String name) {
            this.name = name;
        }
    }
}

