/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui.button;

import fluxnetworks.FluxTranslate;
import fluxnetworks.client.gui.GuiFluxHome;
import fluxnetworks.client.gui.basic.GuiButtonCore;
import fluxnetworks.client.gui.basic.GuiCore;
import fluxnetworks.client.gui.tab.GuiTabConnections;
import fluxnetworks.client.gui.tab.GuiTabCreate;
import fluxnetworks.client.gui.tab.GuiTabMembers;
import fluxnetworks.client.gui.tab.GuiTabSelection;
import fluxnetworks.client.gui.tab.GuiTabSettings;
import fluxnetworks.client.gui.tab.GuiTabStatistics;
import fluxnetworks.client.gui.tab.GuiTabWireless;
import fluxnetworks.common.tileentity.TileFluxCore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class NavigationButton
extends GuiButtonCore {
    public int buttonNavigationId;
    public boolean isCurrentTab = false;

    public NavigationButton(int x, int y, int button) {
        super(x, y, 16, 16, 0);
        this.buttonNavigationId = button;
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(GuiCore.BUTTONS);
        this.func_73729_b(this.x, this.y, 16 * this.buttonNavigationId, 16 * this.getCorrectHoverState(mc, mouseX, mouseY), 16, 16);
        if (this.isMouseHovered(mc, mouseX, mouseY)) {
            FontRenderer fontRenderer = mc.field_71466_p;
            String text = this.getTagName(this.buttonNavigationId);
            fontRenderer.func_78276_b(text, this.x - fontRenderer.func_78256_a(text) / 2 + 8, this.y - 10, 0xFFFFFF);
        }
        GlStateManager.func_179121_F();
    }

    private int getCorrectHoverState(Minecraft mc, int mouseX, int mouseY) {
        if (this.isCurrentTab) {
            return 1;
        }
        return this.getHoverState(this.isMouseHovered(mc, mouseX, mouseY));
    }

    public NavigationButton setMain() {
        this.isCurrentTab = true;
        return this;
    }

    private String getTagName(int id) {
        switch (id) {
            case 0: {
                return FluxTranslate.TAB_HOME.t();
            }
            case 1: {
                return FluxTranslate.TAB_SELECTION.t();
            }
            case 2: {
                return FluxTranslate.TAB_WIRELESS.t();
            }
            case 3: {
                return FluxTranslate.TAB_CONNECTION.t();
            }
            case 4: {
                return FluxTranslate.TAB_STATISTICS.t();
            }
            case 5: {
                return FluxTranslate.TAB_MEMBER.t();
            }
            case 6: {
                return FluxTranslate.TAB_SETTING.t();
            }
            case 7: {
                return FluxTranslate.TAB_CREATE.t();
            }
        }
        return "";
    }

    public void switchTab(int destId, EntityPlayer player, TileFluxCore tileEntity) {
        switch (destId) {
            case 0: {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiFluxHome(player, tileEntity));
                break;
            }
            case 1: {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiTabSelection(player, tileEntity));
                break;
            }
            case 2: {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiTabWireless(player, tileEntity));
                break;
            }
            case 3: {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiTabConnections(player, tileEntity));
                break;
            }
            case 4: {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiTabStatistics(player, tileEntity));
                break;
            }
            case 5: {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiTabMembers(player, tileEntity));
                break;
            }
            case 6: {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiTabSettings(player, tileEntity));
                break;
            }
            case 7: {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiTabCreate(player, tileEntity));
            }
        }
    }
}

