/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui.tab;

import com.google.common.collect.Lists;
import fluxnetworks.FluxNetworks;
import fluxnetworks.FluxTranslate;
import fluxnetworks.api.Coord4D;
import fluxnetworks.api.FeedbackInfo;
import fluxnetworks.api.tileentity.IFluxConnector;
import fluxnetworks.client.gui.basic.GuiTabPages;
import fluxnetworks.client.gui.basic.GuiTextField;
import fluxnetworks.client.gui.button.BatchEditButton;
import fluxnetworks.client.gui.button.NavigationButton;
import fluxnetworks.client.gui.button.NormalButton;
import fluxnetworks.client.gui.button.SimpleToggleButton;
import fluxnetworks.client.gui.button.SlidedSwitchButton;
import fluxnetworks.client.gui.button.TextboxButton;
import fluxnetworks.client.gui.tab.GuiTabSelection;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.core.FluxUtils;
import fluxnetworks.common.core.NBTType;
import fluxnetworks.common.handler.PacketHandler;
import fluxnetworks.common.network.PacketBatchEditing;
import fluxnetworks.common.network.PacketConnectionUpdateRequest;
import fluxnetworks.common.network.PacketNetworkUpdateRequest;
import fluxnetworks.common.tileentity.TileFluxCore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTabConnections
extends GuiTabPages<IFluxConnector> {
    private List<BatchEditButton> editButtons = new ArrayList<BatchEditButton>();
    private List<SlidedSwitchButton> popSwitches = new ArrayList<SlidedSwitchButton>();
    private List<SimpleToggleButton> toggleButtons = new ArrayList<SimpleToggleButton>();
    public List<IFluxConnector> batchConnections = new ArrayList<IFluxConnector>();
    public IFluxConnector singleConnection;
    public boolean batchMode = false;
    public BatchEditButton clear;
    public BatchEditButton edit;
    public BatchEditButton disconnect;
    public NormalButton apply;
    public TextboxButton fluxName;
    public TextboxButton priority;
    public TextboxButton limit;
    public SlidedSwitchButton surge;
    public SlidedSwitchButton unlimited;
    public SlidedSwitchButton chunkLoad;
    public SimpleToggleButton editName;
    public SimpleToggleButton editPriority;
    public SimpleToggleButton editLimit;
    public SimpleToggleButton editSurge;
    public SimpleToggleButton editUnlimited;
    public SimpleToggleButton editChunkLoad;
    private int timer = 3;

    public GuiTabConnections(EntityPlayer player, TileFluxCore tileEntity) {
        super(player, tileEntity);
        this.gridStartX = 16;
        this.gridStartY = 22;
        this.gridHeight = 19;
        this.gridPerPage = 7;
        this.elementHeight = 16;
        this.elementWidth = 144;
        PacketHandler.network.sendToServer((IMessage)new PacketNetworkUpdateRequest.UpdateRequestMessage(this.network.getNetworkID(), NBTType.NETWORK_CONNECTIONS));
    }

    @Override
    protected void onElementClicked(IFluxConnector element, int mouseButton) {
        if (mouseButton == 0 && this.batchConnections.size() == 0 && element.isChunkLoaded()) {
            this.singleConnection = element;
            this.batchMode = false;
            this.main = false;
            this.initPopGui();
        }
        if (mouseButton == 1 || mouseButton == 0 && this.batchConnections.size() > 0) {
            if (this.batchConnections.contains(element)) {
                this.batchConnections.remove(element);
                if (this.batchConnections.size() <= 0) {
                    this.clear.clickable = false;
                    this.edit.clickable = false;
                    this.disconnect.clickable = false;
                }
            } else if (element.isChunkLoaded()) {
                this.batchConnections.add(element);
                this.clear.clickable = true;
                this.edit.clickable = true;
                this.disconnect.clickable = true;
            }
        }
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        for (BatchEditButton button : this.editButtons) {
            button.drawButton(this.field_146297_k, mouseX, mouseY);
        }
        super.drawForegroundLayer(mouseX, mouseY);
        if (this.networkValid) {
            if (this.batchConnections.size() > 0) {
                this.field_146289_q.func_78276_b(FluxTranslate.SELECTED.t() + ": " + TextFormatting.AQUA + this.batchConnections.size(), 20, 10, 0xFFFFFF);
            } else {
                this.field_146289_q.func_78276_b(FluxTranslate.SORT_BY.t() + ": " + TextFormatting.AQUA + "Smart", 20, 10, 0xFFFFFF);
            }
            this.func_73732_a(this.field_146289_q, TextFormatting.RED + FluxNetworks.proxy.getFeedback().getInfo(), 89, 165, 0xFFFFFF);
        } else {
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
        }
    }

    @Override
    protected void drawPopupForegroundLayer(int mouseX, int mouseY) {
        this.drawRectWithBackground(8, 13, 150, 160, -855638017, -1342177280);
        super.drawPopupForegroundLayer(mouseX, mouseY);
        for (SlidedSwitchButton slidedSwitchButton : this.popSwitches) {
            slidedSwitchButton.drawButton(this.field_146297_k, mouseX, mouseY);
        }
        for (SimpleToggleButton simpleToggleButton : this.toggleButtons) {
            simpleToggleButton.drawButton(this.field_146297_k, mouseX, mouseY);
        }
        if (!this.batchMode) {
            this.func_73732_a(this.field_146289_q, FluxTranslate.SINGLE_EDIT.t(), 89, 17, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, this.singleConnection.getCoords().getStringInfo(), 89, 122, 0xFFFFFF);
        } else {
            this.func_73732_a(this.field_146289_q, FluxTranslate.BATCH_EDIT.t(), 89, 17, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, FluxTranslate.EDITING.t() + " " + this.batchConnections.size() + " " + FluxTranslate.CONNECTIONS.t(), 89, 122, 0xFFFFFF);
        }
        if (this.batchMode || !this.singleConnection.getConnectionType().isStorage()) {
            this.field_146289_q.func_78276_b(FluxTranslate.SURGE_MODE.t(), 20, 82, this.network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
            this.field_146289_q.func_78276_b(FluxTranslate.DISABLE_LIMIT.t(), 20, 94, this.network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
            this.field_146289_q.func_78276_b(FluxTranslate.CHUNK_LOADING.t(), 20, 106, this.network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
        }
        this.func_73732_a(this.field_146289_q, TextFormatting.RED + FluxNetworks.proxy.getFeedback().getInfo(), 89, 155, 0xFFFFFF);
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        super.drawBackgroundLayer(partialTicks, mouseX, mouseY);
        for (SlidedSwitchButton button : this.popSwitches) {
            button.updatePosition(partialTicks * 4.0f);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        for (int i = 0; i < 7; ++i) {
            this.navigationButtons.add(new NavigationButton(this.field_146294_l / 2 - 75 + 18 * i, this.field_146295_m / 2 - 99, i));
        }
        this.navigationButtons.add(new NavigationButton(this.field_146294_l / 2 + 59, this.field_146295_m / 2 - 99, 7));
        ((NavigationButton)((Object)this.navigationButtons.get(3))).setMain();
        if (this.networkValid) {
            this.clear = new BatchEditButton(118, 8, this.field_147003_i, this.field_147009_r, 0, FluxTranslate.BATCH_CLEAR_BUTTON.t()).setUnclickable();
            this.edit = new BatchEditButton(132, 8, this.field_147003_i, this.field_147009_r, 1, FluxTranslate.BATCH_EDIT_BUTTON.t()).setUnclickable();
            this.disconnect = new BatchEditButton(146, 8, this.field_147003_i, this.field_147009_r, 2, FluxTranslate.BATCH_DISCONNECT_BUTTON.t()).setUnclickable();
            this.editButtons.add(this.clear);
            this.editButtons.add(this.edit);
            this.editButtons.add(this.disconnect);
        }
    }

    public void initPopGui() {
        this.popBoxes.clear();
        this.popButtons.clear();
        this.popSwitches.clear();
        this.toggleButtons.clear();
        this.popButtons.add(new NormalButton(FluxTranslate.CANCEL.t(), 40, 140, 36, 12, 11));
        this.apply = new NormalButton(FluxTranslate.APPLY.t(), 100, 140, 36, 12, 12).setUnclickable();
        this.popButtons.add(this.apply);
        int color = this.network.getSetting(NetworkSettings.NETWORK_COLOR) | 0xFF000000;
        if (this.batchMode) {
            this.fluxName = TextboxButton.create(this, FluxTranslate.NAME.t() + ": ", 0, this.field_146289_q, 20, 30, 136, 12).setOutlineColor(color);
            this.fluxName.setMaxStringLength(24);
            this.priority = TextboxButton.create(this, FluxTranslate.PRIORITY.t() + ": ", 1, this.field_146289_q, 20, 47, 136, 12).setOutlineColor(color).setDigitsOnly();
            this.priority.setMaxStringLength(5);
            this.limit = TextboxButton.create(this, FluxTranslate.TRANSFER_LIMIT.t() + ": ", 2, this.field_146289_q, 20, 64, 136, 12).setOutlineColor(color).setDigitsOnly();
            this.limit.setMaxStringLength(9);
        } else {
            this.fluxName = TextboxButton.create(this, FluxTranslate.NAME.t() + ": ", 0, this.field_146289_q, 18, 30, 140, 12).setOutlineColor(color);
            this.fluxName.setMaxStringLength(24);
            this.priority = TextboxButton.create(this, FluxTranslate.PRIORITY.t() + ": ", 1, this.field_146289_q, 18, 47, 140, 12).setOutlineColor(color).setDigitsOnly();
            this.priority.setMaxStringLength(5);
            this.limit = TextboxButton.create(this, FluxTranslate.TRANSFER_LIMIT.t() + ": ", 2, this.field_146289_q, 18, 64, 140, 12).setOutlineColor(color).setDigitsOnly();
            this.limit.setMaxStringLength(9);
        }
        if (!this.batchMode) {
            this.fluxName.setText(this.singleConnection.getCustomName());
            this.priority.setText(String.valueOf(this.singleConnection.getPriority()));
            this.limit.setText(String.valueOf(this.singleConnection.getCurrentLimit()));
            if (!this.singleConnection.getConnectionType().isStorage()) {
                this.surge = new SlidedSwitchButton(140, 82, 1, this.field_147003_i, this.field_147009_r, this.singleConnection.getSurgeMode());
                this.unlimited = new SlidedSwitchButton(140, 94, 2, this.field_147003_i, this.field_147009_r, this.singleConnection.getDisableLimit());
                this.chunkLoad = new SlidedSwitchButton(140, 106, 3, this.field_147003_i, this.field_147009_r, this.singleConnection.isForcedLoading());
                this.popSwitches.add(this.surge);
                this.popSwitches.add(this.unlimited);
                this.popSwitches.add(this.chunkLoad);
            }
        } else {
            this.priority.setText(String.valueOf(0));
            this.limit.setText(String.valueOf(0));
            this.editName = new SimpleToggleButton(10, 33, this.field_147003_i, this.field_147009_r, 0);
            this.editPriority = new SimpleToggleButton(10, 50, this.field_147003_i, this.field_147009_r, 1);
            this.editLimit = new SimpleToggleButton(10, 67, this.field_147003_i, this.field_147009_r, 2);
            this.editSurge = new SimpleToggleButton(10, 82, this.field_147003_i, this.field_147009_r, 3);
            this.editUnlimited = new SimpleToggleButton(10, 94, this.field_147003_i, this.field_147009_r, 4);
            this.editChunkLoad = new SimpleToggleButton(10, 106, this.field_147003_i, this.field_147009_r, 5);
            this.toggleButtons.add(this.editName);
            this.toggleButtons.add(this.editPriority);
            this.toggleButtons.add(this.editLimit);
            this.toggleButtons.add(this.editSurge);
            this.toggleButtons.add(this.editUnlimited);
            this.toggleButtons.add(this.editChunkLoad);
            this.surge = new SlidedSwitchButton(140, 82, 1, this.field_147003_i, this.field_147009_r, false);
            this.unlimited = new SlidedSwitchButton(140, 94, 2, this.field_147003_i, this.field_147009_r, false);
            this.chunkLoad = new SlidedSwitchButton(140, 106, 3, this.field_147003_i, this.field_147009_r, false);
            this.popSwitches.add(this.surge);
            this.popSwitches.add(this.unlimited);
            this.popSwitches.add(this.chunkLoad);
        }
        this.popBoxes.add(this.fluxName);
        this.popBoxes.add(this.priority);
        this.popBoxes.add(this.limit);
    }

    @Override
    public void func_146280_a(Minecraft mc, int width, int height) {
        this.editButtons.clear();
        super.func_146280_a(mc, width, height);
        if (!this.main) {
            this.initPopGui();
        }
    }

    @Override
    public void renderElement(IFluxConnector element, int x, int y) {
        GlStateManager.func_179094_E();
        int fontColor = 0xFFFFFF;
        if (this.batchConnections.size() > 0) {
            if (this.batchConnections.contains(element)) {
                GuiTabConnections.func_73734_a((int)(x - 5), (int)(y + 1), (int)(x - 3), (int)(y + this.elementHeight - 1), (int)-855638017);
                GuiTabConnections.func_73734_a((int)(x + this.elementWidth + 3), (int)(y + 1), (int)(x + this.elementWidth + 5), (int)(y + this.elementHeight - 1), (int)-855638017);
                this.drawColorRect(x, y, this.elementHeight, this.elementWidth, element.getConnectionType().color | 0xFF000000);
            } else {
                GuiTabConnections.func_73734_a((int)(x - 5), (int)(y + 1), (int)(x - 3), (int)(y + this.elementHeight - 1), (int)-1436524448);
                GuiTabConnections.func_73734_a((int)(x + this.elementWidth + 3), (int)(y + 1), (int)(x + this.elementWidth + 5), (int)(y + this.elementHeight - 1), (int)-1436524448);
                this.drawColorRect(x, y, this.elementHeight, this.elementWidth, element.getConnectionType().color | 0x60000000);
                fontColor = 0xD0D0D0;
            }
        } else {
            this.drawColorRect(x, y, this.elementHeight, this.elementWidth, element.getConnectionType().color | 0xFF000000);
        }
        this.renderItemStack(element.getDisplayStack(), x, y);
        if (element.isChunkLoaded()) {
            this.field_146289_q.func_78276_b(element.getCustomName(), x + 20, y + 1, fontColor);
            GlStateManager.func_179139_a((double)0.625, (double)0.625, (double)0.625);
            this.field_146289_q.func_78276_b(this.getTransferInfo(element.getConnectionType(), this.network.getSetting(NetworkSettings.NETWORK_ENERGY), element.getChange()), (int)((double)(x + 20) * 1.6), (int)((double)(y + 10) * 1.6), fontColor);
            GlStateManager.func_179139_a((double)1.6, (double)1.6, (double)1.6);
        } else {
            this.field_146289_q.func_78276_b(element.getCustomName(), x + 20, y + 4, 0x808080);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderElementTooltip(IFluxConnector element, int mouseX, int mouseY) {
        if (this.main) {
            GlStateManager.func_179094_E();
            this.drawHoverTooltip(this.getFluxInfo(element), mouseX + 4, mouseY - 16);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    protected void mouseMainClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseMainClicked(mouseX, mouseY, mouseButton);
        for (BatchEditButton button : this.editButtons) {
            if (!button.clickable || !button.isMouseHovered(this.field_146297_k, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) continue;
            switch (button.id) {
                case 0: {
                    this.batchConnections.clear();
                    this.clear.clickable = false;
                    this.edit.clickable = false;
                    this.disconnect.clickable = false;
                    break;
                }
                case 1: {
                    this.batchMode = true;
                    this.main = false;
                    this.initPopGui();
                    break;
                }
                case 2: {
                    List<Coord4D> list = this.batchConnections.stream().map(IFluxConnector::getCoords).collect(Collectors.toList());
                    boolean[] b = new boolean[]{false, false, false, false, false, false, true};
                    PacketHandler.network.sendToServer((IMessage)new PacketBatchEditing.BatchEditingMessage(this.network.getNetworkID(), list, new NBTTagCompound(), b));
                }
            }
        }
    }

    @Override
    protected void mousePopupClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mousePopupClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            for (NormalButton normalButton : this.popButtons) {
                ArrayList list;
                if (!normalButton.isMouseHovered(this.field_146297_k, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) continue;
                if (normalButton.id == 11) {
                    this.main = true;
                }
                if (normalButton.id != 12) continue;
                boolean[] b2 = new boolean[]{true, true, true, true, true, true, false};
                if (this.batchMode) {
                    list = this.batchConnections.stream().map(IFluxConnector::getCoords).collect(Collectors.toList());
                    b2[0] = this.editName.on;
                    b2[1] = this.editPriority.on;
                    b2[2] = this.editLimit.on;
                    b2[3] = this.editSurge.on;
                    b2[4] = this.editUnlimited.on;
                    b2[5] = this.editChunkLoad.on;
                } else {
                    list = Lists.newArrayList((Object[])new Coord4D[]{this.singleConnection.getCoords()});
                }
                NBTTagCompound tag = FluxUtils.getBatchEditingTag(this.fluxName, this.priority, this.limit, this.surge, this.unlimited, this.chunkLoad);
                PacketHandler.network.sendToServer((IMessage)new PacketBatchEditing.BatchEditingMessage(this.network.getNetworkID(), list, tag, b2));
            }
            for (SlidedSwitchButton slidedSwitchButton : this.popSwitches) {
                if (!slidedSwitchButton.isMouseHovered(this.field_146297_k, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) continue;
                slidedSwitchButton.switchButton();
                if (this.batchMode) continue;
                this.apply.clickable = true;
            }
            for (SimpleToggleButton simpleToggleButton : this.toggleButtons) {
                if (!simpleToggleButton.isMouseHovered(this.field_146297_k, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) continue;
                simpleToggleButton.on = !simpleToggleButton.on;
                this.apply.clickable = this.toggleButtons.stream().anyMatch(b -> b.on);
            }
            if (this.main) {
                this.backToMain();
            }
        }
    }

    @Override
    protected void keyTypedPop(char c, int k) throws IOException {
        if ((k == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(k)) && this.popBoxes.stream().noneMatch(GuiTextField::isFocused)) {
            this.backToMain();
        }
        for (TextboxButton text : this.popBoxes) {
            if (!text.isFocused()) continue;
            text.textboxKeyTyped(c, k);
            if (this.batchMode) continue;
            this.apply.clickable = true;
        }
    }

    @Override
    public void func_73876_c() {
        if (this.timer == 4) {
            this.refreshPages(this.network.getSetting(NetworkSettings.ALL_CONNECTORS));
        }
        if (this.timer % 5 == 0) {
            PacketHandler.network.sendToServer((IMessage)new PacketConnectionUpdateRequest.ConnectionRequestMessage(this.network.getNetworkID(), this.current.stream().map(IFluxConnector::getCoords).collect(Collectors.toList())));
        }
        ++this.timer;
        this.timer %= 100;
        if (FluxNetworks.proxy.getFeedback() == FeedbackInfo.SUCCESS) {
            this.backToMain();
            this.batchConnections.clear();
            this.clear.clickable = false;
            this.edit.clickable = false;
            this.disconnect.clickable = false;
            this.refreshPages(this.network.getSetting(NetworkSettings.ALL_CONNECTORS));
        }
        if (FluxNetworks.proxy.getFeedback() == FeedbackInfo.SUCCESS_2) {
            this.backToMain();
            this.elements.removeAll(this.batchConnections);
            this.batchConnections.clear();
            this.clear.clickable = false;
            this.edit.clickable = false;
            this.disconnect.clickable = false;
            this.refreshPages(this.network.getSetting(NetworkSettings.ALL_CONNECTORS));
            if (this.elements.stream().noneMatch(f -> f.getCoords().equals(this.tileEntity.getCoords()))) {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiTabSelection(this.player, this.tileEntity));
            }
        }
    }

    @Override
    protected void sortGrids(GuiTabPages.SortType sortType) {
        this.elements.sort(Comparator.comparing(IFluxConnector::isChunkLoaded).reversed().thenComparing(f -> f.getConnectionType().isStorage()).thenComparing(f -> f.getConnectionType().canAddEnergy()).thenComparing(f -> f.getConnectionType().canRemoveEnergy()).thenComparing(p -> -p.getPriority()));
        this.refreshCurrentPage();
    }
}

