/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui.tab;

import fluxnetworks.FluxNetworks;
import fluxnetworks.FluxTranslate;
import fluxnetworks.client.gui.basic.GuiTabPages;
import fluxnetworks.client.gui.button.NavigationButton;
import fluxnetworks.client.gui.button.NormalButton;
import fluxnetworks.client.gui.button.TextboxButton;
import fluxnetworks.common.connection.NetworkMember;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.core.NBTType;
import fluxnetworks.common.handler.PacketHandler;
import fluxnetworks.common.network.PacketGeneral;
import fluxnetworks.common.network.PacketGeneralHandler;
import fluxnetworks.common.network.PacketGeneralType;
import fluxnetworks.common.network.PacketNetworkUpdateRequest;
import fluxnetworks.common.tileentity.TileFluxCore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTabMembers
extends GuiTabPages<NetworkMember> {
    public TextboxButton player;
    private int timer;

    public GuiTabMembers(EntityPlayer player, TileFluxCore tileEntity) {
        super(player, tileEntity);
        this.gridStartX = 16;
        this.gridStartY = 18;
        this.gridHeight = 14;
        this.gridPerPage = 9;
        this.elementHeight = 11;
        this.elementWidth = 143;
        PacketHandler.network.sendToServer((IMessage)new PacketNetworkUpdateRequest.UpdateRequestMessage(this.network.getNetworkID(), NBTType.NETWORK_PLAYERS));
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        if (this.networkValid) {
            this.func_73732_a(this.field_146289_q, TextFormatting.RED + FluxNetworks.proxy.getFeedback().getInfo(), 89, 162, 0xFFFFFF);
        } else {
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
        }
    }

    @Override
    public void func_73866_w_() {
        for (int i = 0; i < 7; ++i) {
            this.navigationButtons.add(new NavigationButton(this.field_146294_l / 2 - 75 + 18 * i, this.field_146295_m / 2 - 99, i));
        }
        this.navigationButtons.add(new NavigationButton(this.field_146294_l / 2 + 59, this.field_146295_m / 2 - 99, 7));
        ((NavigationButton)((Object)this.navigationButtons.get(5))).setMain();
        if (this.networkValid) {
            this.buttons.add(new NormalButton("+", 152, 150, 12, 12, 1));
            this.player = TextboxButton.create(this, "", 1, this.field_146289_q, 14, 150, 130, 12);
            this.player.setMaxStringLength(32);
            this.textBoxes.add(this.player);
        }
        super.func_73866_w_();
    }

    @Override
    protected void onElementClicked(NetworkMember element, int mouseButton) {
        if (mouseButton == 0) {
            PacketHandler.network.sendToServer((IMessage)new PacketGeneral.GeneralMessage(PacketGeneralType.CHANGE_PERMISSION, PacketGeneralHandler.getChangePermissionPacket(this.network.getNetworkID(), element.getPlayerUUID())));
        } else if (mouseButton == 1) {
            PacketHandler.network.sendToServer((IMessage)new PacketGeneral.GeneralMessage(PacketGeneralType.REMOVE_MEMBER, PacketGeneralHandler.getRemoveMemberPacket(this.network.getNetworkID(), element.getPlayerUUID())));
        }
    }

    @Override
    public void renderElement(NetworkMember element, int x, int y) {
        this.drawColorRect(x, y, this.elementHeight, this.elementWidth, element.getPermission().color | 0xCC000000);
        this.field_146289_q.func_78276_b(element.getCachedName(), x + 3, y + 1, 0xFFFFFF);
        String p = element.getPermission().getName();
        this.field_146289_q.func_78276_b(p, x + 140 - this.field_146289_q.func_78256_a(p), y + 1, 0xFFFFFF);
    }

    @Override
    public void renderElementTooltip(NetworkMember element, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(TextFormatting.AQUA + element.getCachedName());
        strings.add(TextFormatting.RESET + element.getPermission().getName());
        strings.add(TextFormatting.WHITE + "L/R Change/Remove");
        this.drawHoverTooltip(strings, mouseX + 4, mouseY - 8);
        GlStateManager.func_179121_F();
    }

    @Override
    protected void mouseMainClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseMainClicked(mouseX, mouseY, mouseButton);
        for (NormalButton button : this.buttons) {
            if (!button.isMouseHovered(this.field_146297_k, mouseX - this.field_147003_i, mouseY - this.field_147009_r) || button.id != 1 || this.player.getText().isEmpty()) continue;
            PacketHandler.network.sendToServer((IMessage)new PacketGeneral.GeneralMessage(PacketGeneralType.ADD_MEMBER, PacketGeneralHandler.getAddMemberPacket(this.network.getNetworkID(), this.player.getText())));
            this.player.setText("");
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.timer == 0) {
            this.refreshPages(this.network.getSetting(NetworkSettings.NETWORK_PLAYERS));
        }
        ++this.timer;
        this.timer %= 2;
    }

    @Override
    protected void sortGrids(GuiTabPages.SortType sortType) {
        this.elements.sort(Comparator.comparing(NetworkMember::getPermission).thenComparing(NetworkMember::getCachedName));
    }
}

