/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui.tab;

import fluxnetworks.FluxNetworks;
import fluxnetworks.FluxTranslate;
import fluxnetworks.api.FeedbackInfo;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.client.gui.basic.GuiCore;
import fluxnetworks.client.gui.basic.GuiTabPages;
import fluxnetworks.client.gui.button.NavigationButton;
import fluxnetworks.client.gui.button.NormalButton;
import fluxnetworks.client.gui.button.TextboxButton;
import fluxnetworks.common.connection.FluxNetworkCache;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.core.FluxUtils;
import fluxnetworks.common.handler.PacketHandler;
import fluxnetworks.common.network.PacketTile;
import fluxnetworks.common.network.PacketTileHandler;
import fluxnetworks.common.network.PacketTileType;
import fluxnetworks.common.tileentity.TileFluxCore;
import java.io.IOException;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTabSelection
extends GuiTabPages<IFluxNetwork> {
    public TextboxButton password;
    public IFluxNetwork popSelect;
    private int timer2;

    public GuiTabSelection(EntityPlayer player, TileFluxCore tileEntity) {
        super(player, tileEntity);
        this.gridStartX = 16;
        this.gridStartY = 22;
        this.gridHeight = 13;
        this.gridPerPage = 10;
        this.elementHeight = 12;
        this.elementWidth = 143;
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        if (this.elements.size() == 0) {
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_NETWORK.t(), FluxTranslate.TAB_CREATE.t());
        } else {
            String amount = FluxTranslate.TOTAL.t() + ": " + this.elements.size();
            this.field_146289_q.func_78276_b(amount, 154 - this.field_146289_q.func_78256_a(amount), 10, 0xFFFFFF);
            this.field_146289_q.func_78276_b(FluxTranslate.SORT_BY.t() + ": " + TextFormatting.AQUA + this.sortType.name, 20, 10, 0xFFFFFF);
            if (this.main) {
                this.func_73732_a(this.field_146289_q, TextFormatting.RED + FluxNetworks.proxy.getFeedback().getInfo(), 89, 150, 0xFFFFFF);
            }
        }
    }

    @Override
    protected void onElementClicked(IFluxNetwork element, int mouseButton) {
        if (mouseButton == 0) {
            this.popSelect = element;
            PacketHandler.network.sendToServer((IMessage)new PacketTile.TileMessage(PacketTileType.SET_NETWORK, PacketTileHandler.getSetNetworkPacket(element.getNetworkID(), ""), this.tileEntity.func_174877_v(), this.tileEntity.func_145831_w().field_73011_w.getDimension()));
        }
    }

    @Override
    protected void drawPopupForegroundLayer(int mouseX, int mouseY) {
        super.drawPopupForegroundLayer(mouseX, mouseY);
        if (this.popSelect != null) {
            this.func_73732_a(this.field_146289_q, FluxTranslate.CONNECTING_TO.t() + " " + this.popSelect.getSetting(NetworkSettings.NETWORK_NAME), 89, 50, 0xFFFFFF);
        }
        this.func_73732_a(this.field_146289_q, FluxTranslate.NETWORK_PASSWORD.t() + ":", 40, 68, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, TextFormatting.RED + FluxNetworks.proxy.getFeedback().getInfo(), 89, 110, 0xFFFFFF);
    }

    @Override
    public void func_73866_w_() {
        for (int i = 0; i < 7; ++i) {
            this.navigationButtons.add(new NavigationButton(this.field_146294_l / 2 - 75 + 18 * i, this.field_146295_m / 2 - 99, i));
        }
        this.navigationButtons.add(new NavigationButton(this.field_146294_l / 2 + 59, this.field_146295_m / 2 - 99, 7));
        ((NavigationButton)((Object)this.navigationButtons.get(1))).setMain();
        super.func_73866_w_();
    }

    @Override
    public void renderElement(IFluxNetwork element, int x, int y) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GuiCore.GUI_BAR);
        int color = element.getSetting(NetworkSettings.NETWORK_COLOR);
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        boolean selected = this.tileEntity.getNetworkID() == element.getNetworkID();
        boolean isEncrypted = element.getSetting(NetworkSettings.NETWORK_SECURITY).isEncrypted();
        if (isEncrypted) {
            if (selected) {
                this.func_73729_b(x + 129, y, 143, 16, 16, this.elementHeight);
            } else {
                this.func_73729_b(x + 129, y, 159, 16, 16, this.elementHeight);
            }
        }
        String text = element.getSetting(NetworkSettings.NETWORK_NAME);
        if (selected) {
            GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
            this.func_73729_b(x, y, 0, 16, this.elementWidth, this.elementHeight);
            this.field_146297_k.field_71466_p.func_78276_b(text, x + 4, y + 2, 0xFFFFFF);
        } else {
            GlStateManager.func_179124_c((float)(f * 0.75f), (float)(f1 * 0.75f), (float)(f2 * 0.75f));
            this.func_73729_b(x, y, 0, 16, this.elementWidth, this.elementHeight);
            this.field_146297_k.field_71466_p.func_78276_b(text, x + 4, y + 2, 0x404040);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderElementTooltip(IFluxNetwork element, int mouseX, int mouseY) {
    }

    private void initPopGui() {
        this.popButtons.clear();
        this.popButtons.add(new NormalButton(FluxTranslate.CANCEL.t(), 24, 86, 30, 12, 11));
        this.popButtons.add(new NormalButton(FluxTranslate.CONNECT.t(), 120, 86, 30, 12, 12));
        this.password = TextboxButton.create(this, "", 5, this.field_146289_q, 70, 66, 81, 12);
        this.password.setTextInvisible();
        this.password.setMaxStringLength(16);
        this.popBoxes.add(this.password);
    }

    @Override
    protected void mouseMainClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseMainClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && mouseX > this.field_147003_i + 45 && mouseX < this.field_147003_i + 75 && mouseY > this.field_147009_r + 10 && mouseY < this.getGuiTop() + 17) {
            this.sortType = (GuiTabPages.SortType)FluxUtils.incrementEnum((Enum)this.sortType, (Enum[])GuiTabPages.SortType.values());
            this.sortGrids(this.sortType);
        }
    }

    @Override
    protected void mousePopupClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mousePopupClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            for (NormalButton button : this.popButtons) {
                if (!button.isMouseHovered(this.field_146297_k, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) continue;
                if (button.id == 11) {
                    this.main = true;
                }
                if (button.id != 12 || this.password.getText().length() <= 0) continue;
                PacketHandler.network.sendToServer((IMessage)new PacketTile.TileMessage(PacketTileType.SET_NETWORK, PacketTileHandler.getSetNetworkPacket(this.popSelect.getNetworkID(), this.password.getText()), this.tileEntity.func_174877_v(), this.tileEntity.func_145831_w().field_73011_w.getDimension()));
                this.password.setText("");
            }
            if (this.main) {
                this.backToMain();
            }
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.timer2 == 0) {
            this.refreshPages(FluxNetworkCache.instance.getAllClientNetworks());
        }
        if (FluxNetworks.proxy.getFeedback() == FeedbackInfo.SUCCESS) {
            this.backToMain();
        }
        if (FluxNetworks.proxy.getFeedback() == FeedbackInfo.PASSWORD_REQUIRE) {
            this.main = false;
            this.initPopGui();
            FluxNetworks.proxy.setFeedback(FeedbackInfo.NONE);
        }
        ++this.timer2;
        this.timer2 %= 10;
    }

    @Override
    protected void sortGrids(GuiTabPages.SortType sortType) {
        switch (sortType) {
            case ID: {
                this.elements.sort(Comparator.comparing(IFluxNetwork::getNetworkID));
                this.refreshCurrentPage();
                break;
            }
            case NAME: {
                this.elements.sort(Comparator.comparing(IFluxNetwork::getNetworkName));
                this.refreshCurrentPage();
            }
        }
    }

    @Override
    protected void keyTypedPop(char c, int k) throws IOException {
        super.keyTypedPop(c, k);
    }

    @Override
    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        if (!this.main) {
            this.initPopGui();
        }
    }
}

