/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui.tab;

import com.google.common.collect.Lists;
import fluxnetworks.FluxConfig;
import fluxnetworks.FluxNetworks;
import fluxnetworks.FluxTranslate;
import fluxnetworks.api.EnergyType;
import fluxnetworks.api.FeedbackInfo;
import fluxnetworks.api.NetworkColor;
import fluxnetworks.api.SecurityType;
import fluxnetworks.client.gui.GuiFluxHome;
import fluxnetworks.client.gui.basic.GuiTabCore;
import fluxnetworks.client.gui.basic.GuiTextField;
import fluxnetworks.client.gui.button.ColorButton;
import fluxnetworks.client.gui.button.NavigationButton;
import fluxnetworks.client.gui.button.NormalButton;
import fluxnetworks.client.gui.button.TextboxButton;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.core.FluxUtils;
import fluxnetworks.common.handler.PacketHandler;
import fluxnetworks.common.network.PacketGeneral;
import fluxnetworks.common.network.PacketGeneralHandler;
import fluxnetworks.common.network.PacketGeneralType;
import fluxnetworks.common.registry.RegistrySounds;
import fluxnetworks.common.tileentity.TileFluxCore;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTabSettings
extends GuiTabCore {
    private List<ColorButton> colorButtons = Lists.newArrayList();
    public SecurityType securityType;
    public EnergyType energyType;
    public ColorButton color;
    public TextboxButton name;
    public TextboxButton password;
    public TextboxButton customColor;
    public NormalButton apply;
    public NormalButton delete;
    public NormalButton colorApply;
    public int deleteCount;

    public GuiTabSettings(EntityPlayer player, TileFluxCore tileEntity) {
        super(player, tileEntity);
        if (this.networkValid) {
            this.securityType = this.network.getSetting(NetworkSettings.NETWORK_SECURITY);
            this.energyType = this.network.getSetting(NetworkSettings.NETWORK_ENERGY);
        }
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        if (this.networkValid) {
            if (mouseX > 30 + this.field_147003_i && mouseX < 66 + this.field_147003_i && mouseY > 140 + this.field_147009_r && mouseY < 152 + this.field_147009_r) {
                if (this.delete.clickable) {
                    this.func_73732_a(this.field_146289_q, TextFormatting.BOLD + FluxTranslate.DELETE_NETWORK.t(), 48, 128, 0xFF0000);
                } else {
                    this.func_73732_a(this.field_146289_q, FluxTranslate.DOUBLE_SHIFT.t(), 48, 128, 0xFFFFFF);
                }
            }
            this.func_73732_a(this.field_146289_q, FluxTranslate.TAB_SETTING.t(), 89, 10, 0xB4B4B4);
            this.field_146289_q.func_78276_b(FluxTranslate.NETWORK_NAME.t() + ":", 14, 30, 0x606060);
            this.field_146289_q.func_78276_b(FluxTranslate.NETWORK_SECURITY.t() + ": " + TextFormatting.AQUA + this.securityType.getName(), 14, 50, 0x606060);
            if (this.securityType == SecurityType.ENCRYPTED) {
                this.field_146289_q.func_78276_b(FluxTranslate.NETWORK_PASSWORD.t() + ": ", 14, 64, 0x606060);
            }
            this.field_146289_q.func_78276_b(FluxTranslate.NETWORK_ENERGY.t() + ": " + TextFormatting.AQUA + this.energyType.getName(), 14, 78, 0x606060);
            this.field_146289_q.func_78276_b(FluxTranslate.NETWORK_COLOR.t() + ":", 14, 97, 0x606060);
            this.func_73732_a(this.field_146289_q, TextFormatting.RED + FluxNetworks.proxy.getFeedback().getInfo(), 89, 156, 0xFFFFFF);
        } else {
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
        }
    }

    @Override
    protected void drawPopupForegroundLayer(int mouseX, int mouseY) {
        this.drawRectWithBackground(30, 44, 60, 118, -855638017, Integer.MIN_VALUE);
        super.drawPopupForegroundLayer(mouseX, mouseY);
        this.func_73732_a(this.field_146289_q, FluxTranslate.CUSTOM_COLOR.t(), 89, 48, 0xFFFFFF);
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        super.drawBackgroundLayer(partialTicks, mouseX, mouseY);
        for (ColorButton button : this.colorButtons) {
            button.drawButton(this.field_146297_k, mouseX, mouseY);
        }
    }

    @Override
    public void func_146280_a(Minecraft mc, int width, int height) {
        this.colorButtons.clear();
        super.func_146280_a(mc, width, height);
        if (!this.main) {
            this.initPopGui();
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (int i = 0; i < 7; ++i) {
            this.navigationButtons.add(new NavigationButton(this.field_146294_l / 2 - 75 + 18 * i, this.field_146295_m / 2 - 99, i));
        }
        this.navigationButtons.add(new NavigationButton(this.field_146294_l / 2 + 59, this.field_146295_m / 2 - 99, 7));
        ((NavigationButton)((Object)this.navigationButtons.get(6))).setMain();
        if (this.networkValid) {
            int l = this.field_146289_q.func_78256_a(FluxTranslate.NETWORK_NAME.t());
            this.name = TextboxButton.create(this, "", 1, this.field_146289_q, 20 + l, 28, 140 - l, 12);
            this.name.setMaxStringLength(24);
            this.name.setText(this.network.getNetworkName());
            l = this.field_146289_q.func_78256_a(FluxTranslate.NETWORK_PASSWORD.t());
            this.password = TextboxButton.create(this, "", 2, this.field_146289_q, 20 + l, 62, 140 - l, 12).setTextInvisible();
            this.password.setText(this.network.getSetting(NetworkSettings.NETWORK_PASSWORD));
            this.password.setMaxStringLength(16);
            this.password.setVisible(this.network.getSetting(NetworkSettings.NETWORK_SECURITY).isEncrypted());
            this.apply = new NormalButton(FluxTranslate.APPLY.t(), 112, 140, 36, 12, 3).setUnclickable();
            this.delete = new NormalButton(FluxTranslate.DELETE.t(), 30, 140, 36, 12, 4).setUnclickable();
            this.buttons.add(this.apply);
            this.buttons.add(this.delete);
            int x = 0;
            int y = 0;
            boolean colorSet = false;
            for (NetworkColor color : NetworkColor.values()) {
                ColorButton b = new ColorButton(this.field_146294_l / 2 - 40 + x * 16, this.field_146295_m / 2 + 13 + y * 16, color.color);
                this.colorButtons.add(b);
                if (!colorSet && color.color == this.network.getSetting(NetworkSettings.NETWORK_COLOR)) {
                    this.color = b;
                    this.color.selected = true;
                    colorSet = true;
                }
                if (++x != 7) continue;
                x = 0;
                ++y;
            }
            if (!colorSet) {
                ColorButton c = new ColorButton(this.field_146294_l / 2 - 56, this.field_146295_m / 2 + 29, this.network.getSetting(NetworkSettings.NETWORK_COLOR));
                this.colorButtons.add(c);
                this.color = c;
                this.color.selected = true;
            }
            this.textBoxes.add(this.name);
            this.textBoxes.add(this.password);
        }
    }

    @Override
    protected void mouseMainClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseMainClicked(mouseX, mouseY, mouseButton);
        if (this.networkValid && (mouseButton == 0 || mouseButton == 1)) {
            if (mouseButton == 0) {
                if (mouseX > this.field_147003_i + 50 && mouseX < this.field_147003_i + 150 && mouseY > this.field_147009_r + 48 && mouseY < this.getGuiTop() + 60) {
                    this.securityType = (SecurityType)FluxUtils.incrementEnum((Enum)this.securityType, (Enum[])SecurityType.values());
                    this.password.setText("");
                    this.password.setVisible(!this.password.getVisible());
                    boolean bl = this.apply.clickable = (!this.securityType.isEncrypted() || this.password.getText().length() != 0) && this.name.getText().length() != 0;
                }
                if (mouseX > this.field_147003_i + 50 && mouseX < this.field_147003_i + 150 && mouseY > this.field_147009_r + 76 && mouseY < this.getGuiTop() + 88) {
                    this.energyType = (EnergyType)FluxUtils.incrementEnum((Enum)this.energyType, (Enum[])EnergyType.values());
                    this.apply.clickable = (!this.securityType.isEncrypted() || this.password.getText().length() != 0) && this.name.getText().length() != 0;
                }
                for (NormalButton normalButton : this.buttons) {
                    if (!normalButton.clickable || !normalButton.isMouseHovered(this.field_146297_k, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) continue;
                    if (normalButton.id == 4) {
                        PacketHandler.network.sendToServer((IMessage)new PacketGeneral.GeneralMessage(PacketGeneralType.DELETE_NETWORK, PacketGeneralHandler.getDeleteNetworkPacket(this.tileEntity.getNetworkID())));
                    }
                    if (normalButton.id != 3) continue;
                    PacketHandler.network.sendToServer((IMessage)new PacketGeneral.GeneralMessage(PacketGeneralType.EDIT_NETWORK, PacketGeneralHandler.getNetworkEditPacket(this.network.getNetworkID(), this.name.getText(), this.color.color, this.securityType, this.energyType, this.password.getText())));
                }
            }
            for (ColorButton colorButton : this.colorButtons) {
                if (!colorButton.isMouseHovered(this.field_146297_k, mouseX, mouseY)) continue;
                this.color.selected = false;
                this.color = colorButton;
                this.color.selected = true;
                boolean bl = this.apply.clickable = (!this.securityType.isEncrypted() || this.password.getText().length() != 0) && this.name.getText().length() != 0;
                if (mouseButton != 1) continue;
                this.main = false;
                this.initPopGui();
            }
        }
    }

    @Override
    protected void mousePopupClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mousePopupClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            for (NormalButton button : this.popButtons) {
                if (!button.isMouseHovered(this.field_146297_k, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) continue;
                if (button.id == 11) {
                    this.main = true;
                }
                if (button.id != 12) continue;
                this.color.color = this.customColor.getIntegerFromHex();
                this.main = true;
            }
            if (this.main) {
                this.backToMain();
            }
        }
    }

    @Override
    protected void keyTypedMain(char c, int k) {
        if ((k == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(k)) && this.textBoxes.stream().noneMatch(GuiTextField::isFocused)) {
            FMLCommonHandler.instance().showGuiScreen((Object)new GuiFluxHome(this.player, this.tileEntity));
            if (FluxConfig.enableButtonSound) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)RegistrySounds.BUTTON_CLICK, (float)1.0f));
            }
        }
        for (TextboxButton text : this.textBoxes) {
            if (!text.isFocused()) continue;
            text.textboxKeyTyped(c, k);
            this.apply.clickable = (!this.securityType.isEncrypted() || this.password.getText().length() != 0) && this.name.getText().length() != 0;
        }
        if (k == 42) {
            ++this.deleteCount;
            if (this.deleteCount > 1) {
                this.delete.clickable = true;
            }
        } else {
            this.deleteCount = 0;
            this.delete.clickable = false;
        }
    }

    @Override
    protected void keyTypedPop(char c, int k) {
        if ((k == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(k)) && this.popBoxes.stream().noneMatch(GuiTextField::isFocused)) {
            this.backToMain();
        }
        for (TextboxButton text : this.popBoxes) {
            if (!text.isFocused()) continue;
            text.textboxKeyTyped(c, k);
            this.colorApply.clickable = text.getText().length() == 6;
        }
    }

    private void initPopGui() {
        this.popBoxes.clear();
        this.popButtons.clear();
        this.popButtons.add(new NormalButton(FluxTranslate.CANCEL.t(), 40, 86, 36, 12, 11));
        this.colorApply = new NormalButton(FluxTranslate.APPLY.t(), 100, 86, 36, 12, 12);
        this.popButtons.add(this.colorApply);
        this.customColor = TextboxButton.create(this, "0x", 7, this.field_146289_q, 57, 64, 64, 12).setHexOnly();
        this.customColor.setMaxStringLength(6);
        this.customColor.setText(Integer.toHexString(this.color.color));
        this.popBoxes.add(this.customColor);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (FluxNetworks.proxy.getFeedback() == FeedbackInfo.SUCCESS) {
            FMLCommonHandler.instance().showGuiScreen((Object)new GuiFluxHome(this.player, this.tileEntity));
            FluxNetworks.proxy.setFeedback(FeedbackInfo.NONE);
        }
        if (FluxNetworks.proxy.getFeedback() == FeedbackInfo.SUCCESS_2) {
            this.apply.clickable = false;
            FluxNetworks.proxy.setFeedback(FeedbackInfo.NONE);
        }
    }
}

