/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui.tab;

import fluxnetworks.FluxNetworks;
import fluxnetworks.FluxTranslate;
import fluxnetworks.api.FeedbackInfo;
import fluxnetworks.client.gui.basic.GuiTabCore;
import fluxnetworks.client.gui.button.InventoryButton;
import fluxnetworks.client.gui.button.NavigationButton;
import fluxnetworks.client.gui.button.NormalButton;
import fluxnetworks.client.gui.button.SlidedSwitchButton;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.handler.PacketHandler;
import fluxnetworks.common.network.PacketGeneral;
import fluxnetworks.common.network.PacketGeneralHandler;
import fluxnetworks.common.network.PacketGeneralType;
import fluxnetworks.common.tileentity.TileFluxCore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTabWireless
extends GuiTabCore {
    public List<InventoryButton> inventoryButtonList = new ArrayList<InventoryButton>();
    public int enableWireless;
    public int rightHand;
    public int leftHand;
    public int hotBar;
    public int armorSlot;
    public int baublesSlot;
    public NormalButton apply;

    public GuiTabWireless(EntityPlayer player, TileFluxCore tileEntity) {
        super(player, tileEntity);
        if (this.networkValid) {
            int a = this.network.getSetting(NetworkSettings.NETWORK_WIRELESS);
            this.enableWireless = a & 1;
            this.rightHand = a >> 1 & 1;
            this.leftHand = a >> 2 & 1;
            this.hotBar = a >> 3 & 1;
            this.armorSlot = a >> 4 & 1;
            this.baublesSlot = a >> 5 & 1;
        }
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        for (InventoryButton button : this.inventoryButtonList) {
            button.drawButton(this.field_146297_k, mouseX, mouseY);
        }
        if (this.networkValid) {
            this.func_73732_a(this.field_146289_q, FluxTranslate.TAB_WIRELESS.t(), 89, 12, 0xB4B4B4);
            this.field_146289_q.func_78276_b(FluxTranslate.ENABLE_WIRELESS.t(), 20, 156, this.network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
            this.func_73732_a(this.field_146289_q, TextFormatting.RED + FluxNetworks.proxy.getFeedback().getInfo(), 89, 146, 0xFFFFFF);
        } else {
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (int i = 0; i < 7; ++i) {
            this.navigationButtons.add(new NavigationButton(this.field_146294_l / 2 - 75 + 18 * i, this.field_146295_m / 2 - 99, i));
        }
        this.navigationButtons.add(new NavigationButton(this.field_146294_l / 2 + 59, this.field_146295_m / 2 - 99, 7));
        ((NavigationButton)((Object)this.navigationButtons.get(2))).setMain();
        if (this.networkValid) {
            this.switches.add(new SlidedSwitchButton(140, 156, 4, this.field_147003_i, this.field_147009_r, this.enableWireless != 0));
            this.inventoryButtonList.add(new InventoryButton(24, 32, 0, 80, 52, 16, this.field_147003_i, this.field_147009_r, 0, this.armorSlot != 0, FluxTranslate.ARMOR.t()));
            this.inventoryButtonList.add(new InventoryButton(100, 32, 0, 80, 52, 16, this.field_147003_i, this.field_147009_r, 1, this.baublesSlot != 0, FluxTranslate.BAUBLES.t()));
            this.inventoryButtonList.add(new InventoryButton(32, 56, 0, 0, 112, 40, this.field_147003_i, this.field_147009_r, 2, false, FluxTranslate.INVENTORY.t()));
            this.inventoryButtonList.add(new InventoryButton(32, 104, 112, 0, 112, 16, this.field_147003_i, this.field_147009_r, 3, this.hotBar != 0, FluxTranslate.HOT_BAR.t()));
            this.inventoryButtonList.add(new InventoryButton(136, 128, 52, 80, 16, 16, this.field_147003_i, this.field_147009_r, 4, this.rightHand != 0, FluxTranslate.RIGHT_HAND.t()));
            this.inventoryButtonList.add(new InventoryButton(24, 128, 52, 80, 16, 16, this.field_147003_i, this.field_147009_r, 5, this.leftHand != 0, FluxTranslate.LEFT_HAND.t()));
            this.apply = new NormalButton(FluxTranslate.APPLY.t(), 73, 130, 32, 12, 0).setUnclickable();
            this.buttons.add(this.apply);
        }
    }

    @Override
    protected void mouseMainClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseMainClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            for (InventoryButton inventoryButton : this.inventoryButtonList) {
                if (!inventoryButton.isMouseHovered(this.field_146297_k, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) continue;
                switch (inventoryButton.id) {
                    case 0: {
                        inventoryButton.selected = !inventoryButton.selected;
                        this.armorSlot = this.armorSlot == 0 ? 1 : 0;
                        break;
                    }
                    case 1: {
                        inventoryButton.selected = !inventoryButton.selected;
                        this.baublesSlot = this.baublesSlot == 0 ? 1 : 0;
                        break;
                    }
                    case 3: {
                        inventoryButton.selected = !inventoryButton.selected;
                        this.hotBar = this.hotBar == 0 ? 1 : 0;
                        break;
                    }
                    case 4: {
                        inventoryButton.selected = !inventoryButton.selected;
                        this.rightHand = this.rightHand == 0 ? 1 : 0;
                        break;
                    }
                    case 5: {
                        inventoryButton.selected = !inventoryButton.selected;
                        this.leftHand = this.leftHand == 0 ? 1 : 0;
                        break;
                    }
                    default: {
                        inventoryButton.selected = !inventoryButton.selected;
                    }
                }
                this.apply.clickable = true;
            }
            for (NormalButton normalButton : this.buttons) {
                if (!normalButton.clickable || !normalButton.isMouseHovered(this.field_146297_k, mouseX - this.field_147003_i, mouseY - this.field_147009_r) || normalButton.id != 0) continue;
                int wireless = this.enableWireless | this.rightHand << 1 | this.leftHand << 2 | this.hotBar << 3 | this.armorSlot << 4 | this.baublesSlot << 5;
                PacketHandler.network.sendToServer((IMessage)new PacketGeneral.GeneralMessage(PacketGeneralType.CHANGE_WIRELESS, PacketGeneralHandler.getChangeWirelessPacket(this.network.getNetworkID(), wireless)));
            }
            for (SlidedSwitchButton slidedSwitchButton : this.switches) {
                if (!slidedSwitchButton.isMouseHovered(this.field_146297_k, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) continue;
                slidedSwitchButton.switchButton();
                if (slidedSwitchButton.id != 4) continue;
                this.enableWireless = this.enableWireless == 0 ? 1 : 0;
                this.apply.clickable = true;
            }
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (FluxNetworks.proxy.getFeedback() == FeedbackInfo.SUCCESS) {
            this.apply.clickable = false;
            FluxNetworks.proxy.setFeedback(FeedbackInfo.NONE);
        }
    }

    @Override
    public void func_146280_a(Minecraft mc, int width, int height) {
        this.inventoryButtonList.clear();
        super.func_146280_a(mc, width, height);
    }
}

