/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.connection;

import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.api.network.IFluxTransfer;
import fluxnetworks.api.network.ITransferHandler;
import fluxnetworks.api.tileentity.IFluxConnector;
import fluxnetworks.common.connection.FluxNetworkServer;
import net.minecraft.nbt.NBTTagCompound;

public abstract class FluxTransferHandler<T extends IFluxConnector>
implements ITransferHandler {
    public final T fluxConnector;
    public long added;
    public long removed;
    public long change;
    public long buffer;
    public long request;
    private long bufferSize;

    public FluxTransferHandler(T fluxConnector) {
        this.fluxConnector = fluxConnector;
    }

    public IFluxNetwork getNetwork() {
        return this.fluxConnector.getNetwork();
    }

    @Override
    public long addToNetwork(long maxAmount, boolean simulate) {
        if (!this.fluxConnector.isActive()) {
            return 0L;
        }
        long added = Math.min(maxAmount, this.buffer);
        if (!simulate) {
            this.buffer -= added;
        }
        return added;
    }

    @Override
    public long removeFromNetwork(long maxAmount, boolean simulate, boolean pre) {
        if (!this.fluxConnector.isActive()) {
            return 0L;
        }
        long canRemove = this.getValidRemoval(maxAmount);
        long removed = 0L;
        for (IFluxTransfer transfer : this.getTransfers()) {
            if (transfer == null) continue;
            long toTransfer = canRemove - removed;
            long remove = transfer.removeFromNetwork(toTransfer, simulate);
            removed += remove;
            if (simulate) continue;
            this.removed += remove;
            this.request -= remove;
        }
        if (pre) {
            this.request = removed;
        }
        return removed;
    }

    public long getConnectorLimit() {
        return this.fluxConnector.getCurrentLimit();
    }

    public long getBufferLimiter() {
        return ((FluxNetworkServer)this.getNetwork()).bufferLimiter;
    }

    @Override
    public void onServerStartTick() {
        this.change = this.added - this.removed;
        this.request = 0L;
        this.added = 0L;
        this.removed = 0L;
    }

    @Override
    public void onWorldEndTick() {
    }

    public long addToBuffer(long add, boolean simulate) {
        long r = this.getValidAddition(add);
        if (r > 0L) {
            if (!simulate) {
                this.buffer += r;
                this.added += r;
            }
            return r;
        }
        return 0L;
    }

    @Override
    public long getAdded() {
        return this.added;
    }

    @Override
    public long getRemoved() {
        return this.removed;
    }

    @Override
    public long getChange() {
        return this.change;
    }

    @Override
    public long getBuffer() {
        return this.buffer;
    }

    @Override
    public long getRequest() {
        return this.request;
    }

    public void setBuffer(long amount) {
        this.buffer = amount;
    }

    private void checkBufferSize() {
        this.bufferSize = Math.min(Math.max(this.bufferSize, this.getConnectorLimit()), this.getBufferLimiter());
    }

    private long getMaxAddition() {
        long r = Math.min(this.getConnectorLimit() - this.added, this.bufferSize - this.buffer);
        return r > 0L ? r : 0L;
    }

    private long getMaxRemoval() {
        return this.getConnectorLimit() - this.removed;
    }

    private long getValidAddition(long toAdd) {
        this.checkBufferSize();
        return Math.min(this.getMaxAddition(), toAdd);
    }

    private long getValidRemoval(long toRemove) {
        return Math.min(this.getMaxRemoval(), toRemove);
    }

    @Override
    public NBTTagCompound writeNetworkedNBT(NBTTagCompound tag) {
        tag.func_74772_a("71", this.change);
        return tag;
    }

    @Override
    public void readNetworkedNBT(NBTTagCompound tag) {
        this.change = tag.func_74763_f("71");
    }
}

