/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.connection;

import com.mojang.authlib.GameProfile;
import fluxnetworks.api.AccessPermission;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class NetworkMember {
    private UUID playerUUID;
    private String cachedName;
    private AccessPermission permission;

    NetworkMember() {
    }

    public NetworkMember(NBTTagCompound nbt) {
        this.readNetworkNBT(nbt);
    }

    public static NetworkMember createNetworkMember(EntityPlayer player, AccessPermission permissionLevel) {
        NetworkMember t = new NetworkMember();
        GameProfile profile = player.func_146103_bH();
        t.playerUUID = EntityPlayer.func_146094_a((GameProfile)profile);
        t.cachedName = profile.getName();
        t.permission = permissionLevel;
        return t;
    }

    public static NetworkMember createMemberByUsername(String username) {
        boolean isOffline;
        NetworkMember t = new NetworkMember();
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        boolean bl = isOffline = !server.func_71266_T();
        if (!isOffline) {
            PlayerProfileCache cache = server.func_152358_ax();
            GameProfile profile = cache.func_152655_a(username);
            if (profile != null) {
                t.playerUUID = profile.getId();
            } else {
                isOffline = true;
            }
        }
        if (isOffline) {
            t.playerUUID = EntityPlayer.func_175147_b((String)username);
        }
        t.cachedName = username;
        t.permission = AccessPermission.USER;
        return t;
    }

    public String getCachedName() {
        return this.cachedName;
    }

    public AccessPermission getPermission() {
        return this.permission;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void setPermission(AccessPermission permission) {
        this.permission = permission;
    }

    public void readNetworkNBT(NBTTagCompound nbt) {
        this.playerUUID = nbt.func_186857_a("playerUUID");
        this.cachedName = nbt.func_74779_i("cachedName");
        this.permission = AccessPermission.values()[nbt.func_74771_c("playerAccess")];
    }

    public NBTTagCompound writeNetworkNBT(NBTTagCompound nbt) {
        nbt.func_186854_a("playerUUID", this.playerUUID);
        nbt.func_74778_a("cachedName", this.cachedName);
        nbt.func_74774_a("playerAccess", (byte)this.permission.ordinal());
        return nbt;
    }
}

