/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.connection;

import fluxnetworks.api.network.FluxType;
import fluxnetworks.api.network.IFluxNetwork;
import net.minecraft.nbt.NBTTagCompound;

public class NetworkStatistics {
    public final IFluxNetwork network;
    private int timer;
    public int fluxPlugCount;
    public int fluxPointCount;
    public int fluxControllerCount;
    public int fluxStorageCount;

    public NetworkStatistics(IFluxNetwork network) {
        this.network = network;
    }

    public void onEndServerTick() {
        if (this.timer == 0) {
            this.weakTick();
        }
        ++this.timer;
        this.timer %= 20;
    }

    public void weakTick() {
        this.fluxControllerCount = this.network.getConnections(FluxType.controller).size();
        this.fluxStorageCount = this.network.getConnections(FluxType.storage).size();
        this.fluxPlugCount = this.network.getConnections(FluxType.plug).size() - this.fluxStorageCount;
        this.fluxPointCount = this.network.getConnections(FluxType.point).size() - this.fluxStorageCount - this.fluxControllerCount;
    }

    public NBTTagCompound writeNBT(NBTTagCompound tag) {
        tag.func_74768_a("i1", this.fluxPlugCount);
        tag.func_74768_a("i2", this.fluxPointCount);
        tag.func_74768_a("i3", this.fluxControllerCount);
        tag.func_74768_a("i4", this.fluxStorageCount);
        return tag;
    }

    public void readNBT(NBTTagCompound tag) {
        this.fluxPlugCount = tag.func_74762_e("i1");
        this.fluxPointCount = tag.func_74762_e("i2");
        this.fluxControllerCount = tag.func_74762_e("i3");
        this.fluxStorageCount = tag.func_74762_e("i4");
    }
}

