/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.connection.handler;

import com.google.common.collect.Lists;
import fluxnetworks.api.energy.ITileEnergyHandler;
import fluxnetworks.api.network.IFluxTransfer;
import fluxnetworks.api.tileentity.IFluxConnector;
import fluxnetworks.common.connection.FluxTransferHandler;
import fluxnetworks.common.connection.transfer.ConnectionTransfer;
import fluxnetworks.common.handler.TileEntityHandler;
import fluxnetworks.common.tileentity.TileFluxCore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class ConnectionTransferHandler
extends FluxTransferHandler {
    public final TileFluxCore tileEntity;
    public Map<EnumFacing, IFluxTransfer> transfers = new HashMap<EnumFacing, IFluxTransfer>();

    public ConnectionTransferHandler(TileFluxCore tile, IFluxConnector fluxConnector) {
        super(fluxConnector);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.transfers.put(facing, null);
        }
        this.tileEntity = tile;
    }

    @Override
    public void onServerStartTick() {
        super.onServerStartTick();
        this.transfers.entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> ((IFluxTransfer)e.getValue()).onServerStartTick());
    }

    @Override
    public void onWorldEndTick() {
        super.onWorldEndTick();
    }

    @Override
    public void updateTransfers(EnumFacing ... faces) {
        for (EnumFacing facing : faces) {
            TileEntity tile = this.tileEntity.func_145831_w().func_175625_s(this.tileEntity.func_174877_v().func_177972_a(facing));
            this.setTransfer(facing, tile);
        }
    }

    public void setTransfer(EnumFacing side, TileEntity tileEntity) {
        ITileEnergyHandler handler;
        IFluxTransfer transfer = this.transfers.get(side);
        if (tileEntity == null || (handler = TileEntityHandler.getEnergyHandler(tileEntity, side.func_176734_d())) == null) {
            this.transfers.put(side, null);
        } else if (transfer == null || transfer.getTile() != tileEntity) {
            this.transfers.put(side, new ConnectionTransfer(this, handler, tileEntity, side));
        } else if (transfer.isInvalid()) {
            this.transfers.put(side, null);
        }
    }

    @Override
    public List<IFluxTransfer> getTransfers() {
        return Lists.newArrayList(this.transfers.values());
    }

    public long addPhantomEnergyToNetwork(long amount, EnumFacing side, boolean simulate) {
        if (this.getNetwork().isInvalid()) {
            return 0L;
        }
        IFluxTransfer transfer = this.transfers.get(side);
        if (transfer != null) {
            long a = this.addToBuffer(amount, simulate);
            if (!simulate) {
                transfer.addedToNetwork(a);
            }
            return a;
        }
        return 0L;
    }
}

