/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.connection.handler;

import com.google.common.collect.Lists;
import fluxnetworks.api.network.IFluxTransfer;
import fluxnetworks.api.tileentity.IFluxEnergy;
import fluxnetworks.common.connection.FluxTransferHandler;
import java.util.List;
import net.minecraft.util.EnumFacing;

public class SingleTransferHandler
extends FluxTransferHandler<IFluxEnergy> {
    public final IFluxTransfer transfer;

    public SingleTransferHandler(IFluxEnergy tile, IFluxTransfer transfer) {
        super(tile);
        this.transfer = transfer;
    }

    @Override
    public void onServerStartTick() {
        super.onServerStartTick();
        this.transfer.onServerStartTick();
    }

    @Override
    public long addToNetwork(long maxAmount, boolean simulate) {
        if (!((IFluxEnergy)this.fluxConnector).isActive()) {
            return 0L;
        }
        long canAdd = Math.min(this.getConnectorLimit(), maxAmount);
        long add = this.transfer.addToNetwork(canAdd, simulate);
        if (!simulate) {
            this.added += add;
        }
        return add;
    }

    @Override
    public long removeFromNetwork(long maxAmount, boolean simulate, boolean pre) {
        if (!((IFluxEnergy)this.fluxConnector).isActive()) {
            return 0L;
        }
        long canRemove = Math.min(this.getConnectorLimit(), maxAmount);
        long remove = this.transfer.removeFromNetwork(canRemove, simulate);
        if (pre) {
            this.request += remove;
        }
        if (!simulate) {
            this.request -= remove;
            this.removed += remove;
        }
        return remove;
    }

    @Override
    public void updateTransfers(EnumFacing ... faces) {
    }

    @Override
    public List<IFluxTransfer> getTransfers() {
        return Lists.newArrayList((Object[])new IFluxTransfer[]{this.transfer});
    }

    @Override
    public long getBuffer() {
        return ((IFluxEnergy)this.fluxConnector).getEnergy();
    }
}

