/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.connection.transfer;

import baubles.api.cap.BaublesCapabilities;
import com.google.common.collect.Lists;
import fluxnetworks.FluxNetworks;
import fluxnetworks.api.energy.IItemEnergyHandler;
import fluxnetworks.api.network.IFluxTransfer;
import fluxnetworks.common.connection.NetworkMember;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.handler.ItemEnergyHandler;
import fluxnetworks.common.tileentity.TileFluxController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandler;

public class ControllerTransfer
implements IFluxTransfer {
    public final TileFluxController tile;
    private List<EntityPlayer> players = new ArrayList<EntityPlayer>();
    private int timer;
    private static final Predicate<ItemStack> NOT_EMPTY = STACK -> !STACK.func_190926_b();

    public ControllerTransfer(TileFluxController tile) {
        this.tile = tile;
    }

    @Override
    public void onServerStartTick() {
        if (this.timer == 0) {
            this.updatePlayers();
        }
        ++this.timer;
        this.timer %= 20;
    }

    @Override
    public long addToNetwork(long amount, boolean simulate) {
        return 0L;
    }

    @Override
    public long removeFromNetwork(long amount, boolean simulate) {
        if (this.timer % 4 != 0) {
            return 0L;
        }
        if ((this.tile.getNetwork().getSetting(NetworkSettings.NETWORK_WIRELESS) & 1) == 0) {
            return 0L;
        }
        long received = 0L;
        block0: for (EntityPlayer player : this.players) {
            if (player == null || player.field_70128_L) continue;
            Map<Iterable<ItemStack>, Predicate<ItemStack>> inventories = this.getSubInventories(new HashMap<Iterable<ItemStack>, Predicate<ItemStack>>(), player);
            for (Map.Entry<Iterable<ItemStack>, Predicate<ItemStack>> inventory : inventories.entrySet()) {
                for (ItemStack stack : inventory.getKey()) {
                    long receive;
                    IItemEnergyHandler handler;
                    if (!inventory.getValue().test(stack) || (handler = ItemEnergyHandler.getEnergyHandler(stack)) == null || amount - (received += (receive = handler.addEnergy(amount - received, stack, simulate))) > 0L) continue;
                    break block0;
                }
            }
        }
        return received;
    }

    private void updatePlayers() {
        List<NetworkMember> m = this.tile.getNetwork().getSetting(NetworkSettings.NETWORK_PLAYERS);
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        for (NetworkMember p : m) {
            Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(p.getPlayerUUID());
            if (!(entity instanceof EntityPlayer)) continue;
            players.add((EntityPlayer)entity);
        }
        this.players = players;
    }

    private Map<Iterable<ItemStack>, Predicate<ItemStack>> getSubInventories(Map<Iterable<ItemStack>, Predicate<ItemStack>> subInventories, EntityPlayer player) {
        InventoryPlayer inv = player.field_71071_by;
        ItemStack heldItem = inv.func_70448_g();
        int wireless = this.tile.getNetwork().getSetting(NetworkSettings.NETWORK_WIRELESS);
        if ((wireless >> 1 & 1) == 1) {
            subInventories.put(Lists.newArrayList((Object[])new ItemStack[]{heldItem}), NOT_EMPTY);
        }
        if ((wireless >> 2 & 1) == 1) {
            subInventories.put((Iterable<ItemStack>)inv.field_184439_c, NOT_EMPTY);
        }
        if ((wireless >> 3 & 1) == 1) {
            subInventories.put(inv.field_70462_a.subList(0, 9), stack -> !stack.func_190926_b() && (heldItem.func_190926_b() || heldItem != stack));
        }
        if ((wireless >> 4 & 1) == 1) {
            subInventories.put((Iterable<ItemStack>)inv.field_70460_b, NOT_EMPTY);
        }
        if ((wireless >> 5 & 1) == 1 && FluxNetworks.proxy.baublesLoaded && player.hasCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null)) {
            IItemHandler handler = (IItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null);
            subInventories.put(() -> new ItemHandlerIterator(handler), NOT_EMPTY);
        }
        return subInventories;
    }

    @Override
    public void addedToNetwork(long amount) {
    }

    @Override
    public void removedFromNetwork(long amount) {
    }

    @Override
    public TileEntity getTile() {
        return this.tile;
    }

    @Override
    public ItemStack getDisplayStack() {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean isInvalid() {
        return this.tile.func_145837_r();
    }

    private static class ItemHandlerIterator
    implements Iterator<ItemStack> {
        private final IItemHandler handler;
        private int count = 0;

        ItemHandlerIterator(IItemHandler handler) {
            this.handler = handler;
        }

        @Override
        public boolean hasNext() {
            return this.count < this.handler.getSlots();
        }

        @Override
        public ItemStack next() {
            ItemStack next = this.handler.getStackInSlot(this.count);
            ++this.count;
            return next;
        }
    }
}

