/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.core;

import fluxnetworks.api.ConnectionType;
import fluxnetworks.api.EnergyType;
import fluxnetworks.api.FluxConfigurationType;
import fluxnetworks.api.network.FluxType;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.api.tileentity.IFluxConnector;
import fluxnetworks.client.gui.button.SlidedSwitchButton;
import fluxnetworks.client.gui.button.TextboxButton;
import fluxnetworks.common.connection.FluxNetworkCache;
import fluxnetworks.common.item.ItemFluxConnector;
import fluxnetworks.common.tileentity.TileFluxCore;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FluxUtils {
    public static final String FLUX_DATA = "FluxData";
    public static final String GUI_COLOR = "GuiColor";
    public static final String CONFIGS_TAG = "Configs";
    public static UUID UUID_DEFAULT = new UUID(-1L, -1L);
    public static Material MACHINE = new Material(MapColor.field_151646_E);

    public static <E extends Enum> E incrementEnum(E enumObj, E[] values) {
        int ordinal = enumObj.ordinal() + 1;
        if (ordinal < values.length) {
            return values[ordinal];
        }
        return values[0];
    }

    @Nullable
    public static EnumFacing getBlockDirection(BlockPos pos, BlockPos other) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (!pos.func_177972_a(face).equals((Object)other)) continue;
            return face;
        }
        return null;
    }

    public static <T> boolean addWithCheck(Collection<T> list, T toAdd) {
        if (toAdd != null && !list.contains(toAdd)) {
            list.add(toAdd);
            return true;
        }
        return false;
    }

    public static ItemStack getBlockItem(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = new ItemStack(Item.func_150898_a((Block)state.func_177230_c()));
        return stack;
    }

    public static boolean addConnection(IFluxConnector fluxConnector) {
        IFluxNetwork network;
        if (fluxConnector.getNetworkID() != -1 && !(network = FluxNetworkCache.instance.getNetwork(fluxConnector.getNetworkID())).isInvalid()) {
            if (fluxConnector.getConnectionType().isController() && network.getConnections(FluxType.controller).size() > 0) {
                return false;
            }
            network.queueConnectionAddition(fluxConnector);
            return true;
        }
        return false;
    }

    public static void removeConnection(IFluxConnector fluxConnector, boolean isChunkUnload) {
        IFluxNetwork network;
        if (fluxConnector.getNetworkID() != -1 && !(network = FluxNetworkCache.instance.getNetwork(fluxConnector.getNetworkID())).isInvalid()) {
            network.queueConnectionRemoval(fluxConnector, isChunkUnload);
            return;
        }
    }

    public static int getIntFromColor(int red, int green, int blue) {
        red = red << 16 & 0xFF0000;
        green = green << 8 & 0xFF00;
        return 0xFF000000 | red | green | (blue &= 0xFF);
    }

    public static int getBrighterColor(int color, double index) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return FluxUtils.getIntFromColor((int)Math.min((double)red * index, 255.0), (int)Math.min((double)green * index, 255.0), (int)Math.min((double)blue * index, 255.0));
    }

    public static String format(long in, TypeNumberFormat style, String suffix) {
        switch (style) {
            case FULL: {
                return in + suffix;
            }
            case COMPACT: {
                int unit = 1000;
                if (in < (long)unit) {
                    return in + " " + suffix;
                }
                int exp = (int)(Math.log(in) / Math.log(unit));
                if (suffix.startsWith("m")) {
                    suffix = suffix.substring(1);
                    if (exp - 2 >= 0) {
                        char pre = "kMGTPE".charAt(exp - 2);
                        return String.format("%.1f %s", (double)in / Math.pow(unit, exp), Character.valueOf(pre)) + suffix;
                    }
                    return String.format("%.1f %s", (double)in / Math.pow(unit, exp), suffix);
                }
                char pre = "kMGTPE".charAt(exp - 1);
                return String.format("%.1f %s", (double)in / Math.pow(unit, exp), Character.valueOf(pre)) + suffix;
            }
            case COMMAS: {
                return NumberFormat.getInstance().format(in) + suffix;
            }
            case NONE: {
                return suffix;
            }
        }
        return Long.toString(in);
    }

    public static String format(long in, TypeNumberFormat style, EnergyType energy, boolean usage) {
        if (energy == EnergyType.EU) {
            return FluxUtils.format(in / 4L, style, usage ? energy.getUsageSuffix() : energy.getStorageSuffix());
        }
        return FluxUtils.format(in, style, usage ? energy.getUsageSuffix() : energy.getStorageSuffix());
    }

    public static boolean checkPassword(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isLetterOrDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static NBTTagCompound copyConfiguration(TileFluxCore flux, NBTTagCompound config) {
        for (FluxConfigurationType type : FluxConfigurationType.VALUES) {
            type.copy.copyFromTile(config, type.getNBTName(), flux);
        }
        return config;
    }

    public static void pasteConfiguration(TileFluxCore flux, NBTTagCompound config) {
        if (flux.getConnectionType() == ConnectionType.STORAGE) {
            FluxConfigurationType type = FluxConfigurationType.NETWORK;
            if (config.func_74764_b(type.getNBTName())) {
                type.paste.pasteToTile(config, type.getNBTName(), flux);
            }
            return;
        }
        for (FluxConfigurationType type : FluxConfigurationType.VALUES) {
            if (!config.func_74764_b(type.getNBTName())) continue;
            type.paste.pasteToTile(config, type.getNBTName(), flux);
        }
    }

    public static NBTTagCompound getBatchEditingTag(TextboxButton a, TextboxButton b, TextboxButton c, SlidedSwitchButton d, SlidedSwitchButton e, SlidedSwitchButton f) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a(ItemFluxConnector.CUSTOM_NAME, a.getText());
        tag.func_74768_a(ItemFluxConnector.PRIORITY, b.getIntegerFromText(false));
        tag.func_74772_a(ItemFluxConnector.LIMIT, c.getLongFromText(true));
        tag.func_74757_a(ItemFluxConnector.SURGE_MODE, d != null && d.slideControl);
        tag.func_74757_a(ItemFluxConnector.DISABLE_LIMIT, e != null && e.slideControl);
        tag.func_74757_a("chunkLoad", f != null && f.slideControl);
        return tag;
    }

    public static enum TypeNumberFormat {
        FULL,
        COMPACT,
        COMMAS,
        NONE;

    }
}

