/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.handler;

import fluxnetworks.common.core.ILocalizationProvider;
import fluxnetworks.common.core.Localization;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;

public class LocalizationHandler
implements ISelectiveResourceReloadListener {
    public List<ILocalizationProvider> providers = new ArrayList<ILocalizationProvider>();

    public void clear() {
        this.providers.clear();
    }

    public void add(ILocalizationProvider handler) {
        this.providers.add(handler);
        this.loadHandler(handler);
    }

    public void remove(ILocalizationProvider handler) {
        this.providers.remove(handler);
    }

    public void loadHandler(ILocalizationProvider handler) {
        handler.getLocalizations(new ArrayList<Localization>()).forEach(LocalizationHandler::translate);
    }

    public static Localization translate(Localization l) {
        l.translated = LocalizationHandler.translate(l.key);
        return l;
    }

    public static String translate(String string) {
        return new TextComponentTranslation(string, new Object[0]).func_150254_d();
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        this.providers.forEach(this::loadHandler);
    }
}

