/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.handler;

import com.google.common.collect.Lists;
import fluxnetworks.api.energy.ITileEnergyHandler;
import fluxnetworks.api.tileentity.IFluxConnector;
import fluxnetworks.common.handler.ItemEnergyHandler;
import fluxnetworks.common.handler.energy.ForgeEnergyHandler;
import fluxnetworks.common.handler.energy.GTEnergyHandler;
import fluxnetworks.common.handler.energy.IC2EnergyHandler;
import fluxnetworks.common.handler.energy.RedstoneFluxHandler;
import fluxnetworks.common.tileentity.TileFluxController;
import fluxnetworks.common.tileentity.TileFluxPlug;
import fluxnetworks.common.tileentity.TileFluxPoint;
import fluxnetworks.common.tileentity.TileFluxStorage;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileEntityHandler {
    public static List<ITileEnergyHandler> tileEnergyHandlers = Lists.newArrayList();

    public static void registerTileEntity() {
        GameRegistry.registerTileEntity(TileFluxController.class, (String)"FluxController");
        GameRegistry.registerTileEntity(TileFluxPoint.class, (String)"FluxPoint");
        GameRegistry.registerTileEntity(TileFluxPlug.class, (String)"FluxPlug");
        GameRegistry.registerTileEntity(TileFluxStorage.class, (String)"FluxStorage");
        GameRegistry.registerTileEntity(TileFluxStorage.Herculean.class, (String)"HerculeanFluxStorage");
        GameRegistry.registerTileEntity(TileFluxStorage.Gargantuan.class, (String)"GargantuanFluxStorage");
    }

    public static void registerEnergyHandler() {
        tileEnergyHandlers.add(ForgeEnergyHandler.INSTANCE);
        ItemEnergyHandler.itemEnergyHandlers.add(ForgeEnergyHandler.INSTANCE);
        if (Loader.isModLoaded((String)"gregtech")) {
            tileEnergyHandlers.add(GTEnergyHandler.INSTANCE);
            ItemEnergyHandler.itemEnergyHandlers.add(GTEnergyHandler.INSTANCE);
        }
        if (Loader.isModLoaded((String)"redstoneflux")) {
            tileEnergyHandlers.add(RedstoneFluxHandler.INSTANCE);
            ItemEnergyHandler.itemEnergyHandlers.add(RedstoneFluxHandler.INSTANCE);
        }
        if (Loader.isModLoaded((String)"ic2")) {
            tileEnergyHandlers.add(IC2EnergyHandler.INSTANCE);
            ItemEnergyHandler.itemEnergyHandlers.add(IC2EnergyHandler.INSTANCE);
        }
    }

    @Nullable
    public static ITileEnergyHandler getEnergyHandler(TileEntity tile, EnumFacing side) {
        if (tile instanceof IFluxConnector) {
            return null;
        }
        for (ITileEnergyHandler handler : tileEnergyHandlers) {
            if (!handler.canRenderConnection(tile, side)) continue;
            return handler;
        }
        return null;
    }

    public static boolean canRenderConnection(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof IFluxConnector) {
            return false;
        }
        ITileEnergyHandler handler = TileEntityHandler.getEnergyHandler(tile, side);
        return handler != null;
    }
}

