/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.network;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import fluxnetworks.FluxNetworks;
import fluxnetworks.api.AccessPermission;
import fluxnetworks.api.EnergyType;
import fluxnetworks.api.FeedbackInfo;
import fluxnetworks.api.SecurityType;
import fluxnetworks.api.network.FluxType;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.api.tileentity.IFluxConnector;
import fluxnetworks.common.connection.FluxNetworkCache;
import fluxnetworks.common.connection.NetworkMember;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.core.FluxUtils;
import fluxnetworks.common.core.NBTType;
import fluxnetworks.common.data.FluxNetworkData;
import fluxnetworks.common.handler.PacketHandler;
import fluxnetworks.common.network.PacketFeedback;
import fluxnetworks.common.network.PacketNetworkUpdate;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketGeneralHandler {
    public static NBTTagCompound getCreateNetworkPacket(String name, int color, SecurityType security, EnergyType energy, String password) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a(FluxNetworkData.NETWORK_NAME, name);
        tag.func_74768_a(FluxNetworkData.NETWORK_COLOR, color);
        tag.func_74768_a(FluxNetworkData.SECURITY_TYPE, security.ordinal());
        tag.func_74768_a(FluxNetworkData.ENERGY_TYPE, energy.ordinal());
        tag.func_74778_a(FluxNetworkData.NETWORK_PASSWORD, password);
        return tag;
    }

    public static IMessage handleCreateNetworkPacket(EntityPlayer player, NBTTagCompound nbtTag) {
        String name = nbtTag.func_74779_i(FluxNetworkData.NETWORK_NAME);
        int color = nbtTag.func_74762_e(FluxNetworkData.NETWORK_COLOR);
        SecurityType security = SecurityType.values()[nbtTag.func_74762_e(FluxNetworkData.SECURITY_TYPE)];
        EnergyType energy = EnergyType.values()[nbtTag.func_74762_e(FluxNetworkData.ENERGY_TYPE)];
        String password = nbtTag.func_74779_i(FluxNetworkData.NETWORK_PASSWORD);
        if (!FluxUtils.checkPassword(password)) {
            return new PacketFeedback.FeedbackMessage(FeedbackInfo.ILLEGAL_PASSWORD);
        }
        if (FluxNetworkCache.instance.hasSpaceLeft(player)) {
            FluxNetworkCache.instance.createdNetwork(player, name, color, security, energy, password);
            return new PacketFeedback.FeedbackMessage(FeedbackInfo.SUCCESS);
        }
        return new PacketFeedback.FeedbackMessage(FeedbackInfo.NO_SPACE);
    }

    public static NBTTagCompound getNetworkEditPacket(int networkID, String networkName, int color, SecurityType security, EnergyType energy, String password) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        tag.func_74778_a(FluxNetworkData.NETWORK_NAME, networkName);
        tag.func_74768_a(FluxNetworkData.NETWORK_COLOR, color);
        tag.func_74768_a(FluxNetworkData.SECURITY_TYPE, security.ordinal());
        tag.func_74768_a(FluxNetworkData.ENERGY_TYPE, energy.ordinal());
        tag.func_74778_a(FluxNetworkData.NETWORK_PASSWORD, password);
        return tag;
    }

    public static IMessage handleNetworkEditPacket(EntityPlayer player, NBTTagCompound tag) {
        int networkID = tag.func_74762_e(FluxNetworkData.NETWORK_ID);
        String newName = tag.func_74779_i(FluxNetworkData.NETWORK_NAME);
        int color = tag.func_74762_e(FluxNetworkData.NETWORK_COLOR);
        SecurityType security = SecurityType.values()[tag.func_74762_e(FluxNetworkData.SECURITY_TYPE)];
        EnergyType energy = EnergyType.values()[tag.func_74762_e(FluxNetworkData.ENERGY_TYPE)];
        String password = tag.func_74779_i(FluxNetworkData.NETWORK_PASSWORD);
        if (!FluxUtils.checkPassword(password)) {
            return new PacketFeedback.FeedbackMessage(FeedbackInfo.ILLEGAL_PASSWORD);
        }
        IFluxNetwork network = FluxNetworkCache.instance.getNetwork(networkID);
        if (!network.isInvalid()) {
            if (network.getMemberPermission(player).canEdit()) {
                network.setSetting(NetworkSettings.NETWORK_NAME, newName);
                if (network.getSetting(NetworkSettings.NETWORK_COLOR) != color) {
                    network.setSetting(NetworkSettings.NETWORK_COLOR, color);
                    List<IFluxConnector> list = network.getConnections(FluxType.flux);
                    list.forEach(fluxConnector -> fluxConnector.connect(network));
                    FluxNetworks.proxy.clearColorCache(networkID);
                }
                network.setSetting(NetworkSettings.NETWORK_SECURITY, security);
                network.setSetting(NetworkSettings.NETWORK_ENERGY, energy);
                network.setSetting(NetworkSettings.NETWORK_PASSWORD, password);
                PacketHandler.network.sendToAll((IMessage)new PacketNetworkUpdate.NetworkUpdateMessage(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_GENERAL));
                return new PacketFeedback.FeedbackMessage(FeedbackInfo.SUCCESS_2);
            }
            return new PacketFeedback.FeedbackMessage(FeedbackInfo.NO_ADMIN);
        }
        return null;
    }

    public static NBTTagCompound getDeleteNetworkPacket(int networkID) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        return tag;
    }

    public static IMessage handleDeleteNetworkPacket(EntityPlayer player, NBTTagCompound nbtTag) {
        int id = nbtTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        IFluxNetwork toDelete = FluxNetworkCache.instance.getNetwork(id);
        if (!toDelete.isInvalid()) {
            if (toDelete.getMemberPermission(player).canDelete()) {
                FluxNetworkData.get().removeNetwork(toDelete);
                return new PacketFeedback.FeedbackMessage(FeedbackInfo.SUCCESS);
            }
            return new PacketFeedback.FeedbackMessage(FeedbackInfo.NO_OWNER);
        }
        return null;
    }

    public static NBTTagCompound getAddMemberPacket(int networkID, String playerName) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        tag.func_74778_a("playerName", playerName);
        return tag;
    }

    public static IMessage handleAddMemberPacket(EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        String playerName = packetTag.func_74779_i("playerName");
        IFluxNetwork network = FluxNetworkCache.instance.getNetwork(networkID);
        if (!network.isInvalid()) {
            if (network.getMemberPermission(player).canEdit()) {
                network.addNewMember(playerName);
                return new PacketNetworkUpdate.NetworkUpdateMessage(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_PLAYERS);
            }
            return new PacketFeedback.FeedbackMessage(FeedbackInfo.NO_ADMIN);
        }
        return null;
    }

    public static NBTTagCompound getRemoveMemberPacket(int networkID, UUID playerRemoved) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        tag.func_186854_a("playerRemoved", playerRemoved);
        return tag;
    }

    public static IMessage handleRemoveMemberPacket(EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        UUID playerRemoved = packetTag.func_186857_a("playerRemoved");
        IFluxNetwork network = FluxNetworkCache.instance.getNetwork(networkID);
        if (!network.isInvalid()) {
            if (network.getMemberPermission(player).canEdit()) {
                network.removeMember(playerRemoved);
                return new PacketNetworkUpdate.NetworkUpdateMessage(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_PLAYERS);
            }
            return new PacketFeedback.FeedbackMessage(FeedbackInfo.NO_ADMIN);
        }
        return null;
    }

    public static NBTTagCompound getChangePermissionPacket(int networkID, UUID playerChanged) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        tag.func_186854_a("playerChanged", playerChanged);
        return tag;
    }

    public static IMessage handleChangePermissionPacket(EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        UUID playerChanged = packetTag.func_186857_a("playerChanged");
        if (playerChanged != null) {
            if (EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).equals(playerChanged)) {
                return null;
            }
            IFluxNetwork network = FluxNetworkCache.instance.getNetwork(networkID);
            if (!network.isInvalid()) {
                if (network.getMemberPermission(player).canEdit()) {
                    NetworkMember p;
                    Optional<NetworkMember> settings = network.getValidMember(playerChanged);
                    if (settings.isPresent() && !(p = settings.get()).getPermission().canDelete()) {
                        p.setPermission(p.getPermission() == AccessPermission.USER ? AccessPermission.ADMIN : AccessPermission.USER);
                        return new PacketNetworkUpdate.NetworkUpdateMessage(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_PLAYERS);
                    }
                    return new PacketFeedback.FeedbackMessage(FeedbackInfo.INVALID_USER);
                }
                return new PacketFeedback.FeedbackMessage(FeedbackInfo.NO_ADMIN);
            }
        }
        return null;
    }

    public static NBTTagCompound getChangeWirelessPacket(int networkID, int wirelessMode) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        tag.func_74768_a(FluxNetworkData.WIRELESS_MODE, wirelessMode);
        return tag;
    }

    public static IMessage handleChangeWirelessPacket(EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        int wireless = packetTag.func_74762_e(FluxNetworkData.WIRELESS_MODE);
        IFluxNetwork network = FluxNetworkCache.instance.getNetwork(networkID);
        if (!network.isInvalid()) {
            if (network.getMemberPermission(player).canEdit()) {
                network.setSetting(NetworkSettings.NETWORK_WIRELESS, wireless);
                PacketHandler.network.sendTo((IMessage)new PacketNetworkUpdate.NetworkUpdateMessage(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_GENERAL), (EntityPlayerMP)player);
                return new PacketFeedback.FeedbackMessage(FeedbackInfo.SUCCESS);
            }
            return new PacketFeedback.FeedbackMessage(FeedbackInfo.NO_ADMIN);
        }
        return null;
    }
}

