/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.network;

import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.common.connection.FluxNetworkCache;
import fluxnetworks.common.core.NBTType;
import fluxnetworks.common.handler.PacketHandler;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketNetworkUpdate
implements IMessageHandler<NetworkUpdateMessage, IMessage> {
    public IMessage onMessage(NetworkUpdateMessage message, MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            PacketHandler.handlePacket(() -> FluxNetworkCache.instance.updateClientFromPacket(message.updatedNetworks, message.type), ctx.netHandler);
        }
        return null;
    }

    public static class NetworkUpdateMessage
    implements IMessage {
        public Map<Integer, NBTTagCompound> updatedNetworks = new HashMap<Integer, NBTTagCompound>();
        public NBTType type;

        public NetworkUpdateMessage() {
        }

        public NetworkUpdateMessage(List<IFluxNetwork> toSend, NBTType type) {
            this.type = type;
            toSend.forEach(n -> {
                NBTTagCompound tag = new NBTTagCompound();
                n.writeNetworkNBT(tag, type);
                if (!tag.func_82582_d()) {
                    this.updatedNetworks.put(n.getNetworkID(), tag);
                }
            });
        }

        public void fromBytes(ByteBuf buf) {
            this.type = NBTType.values()[buf.readInt()];
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.updatedNetworks.put(buf.readInt(), ByteBufUtils.readTag((ByteBuf)buf));
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.type.ordinal());
            buf.writeInt(this.updatedNetworks.size());
            this.updatedNetworks.forEach((i, n) -> {
                buf.writeInt(i.intValue());
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)n);
            });
        }
    }
}

