/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.network;

import com.google.common.collect.Lists;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.common.connection.FluxNetworkCache;
import fluxnetworks.common.core.NBTType;
import fluxnetworks.common.network.PacketNetworkUpdate;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketNetworkUpdateRequest
implements IMessageHandler<UpdateRequestMessage, IMessage> {
    public IMessage onMessage(UpdateRequestMessage message, MessageContext ctx) {
        IFluxNetwork network = FluxNetworkCache.instance.getNetwork(message.networkID);
        if (!network.isInvalid()) {
            return new PacketNetworkUpdate.NetworkUpdateMessage(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), message.type);
        }
        return null;
    }

    public static class UpdateRequestMessage
    implements IMessage {
        public int networkID;
        public NBTType type;

        public UpdateRequestMessage() {
        }

        public UpdateRequestMessage(int networkID, NBTType type) {
            this.networkID = networkID;
            this.type = type;
        }

        public void fromBytes(ByteBuf buf) {
            this.networkID = buf.readInt();
            this.type = NBTType.values()[buf.readInt()];
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.networkID);
            buf.writeInt(this.type.ordinal());
        }
    }
}

