/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.network;

import fluxnetworks.common.handler.PacketHandler;
import fluxnetworks.common.network.PacketTileType;
import fluxnetworks.common.tileentity.TileFluxCore;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTile
implements IMessageHandler<TileMessage, IMessage> {
    public IMessage onMessage(TileMessage message, MessageContext ctx) {
        EntityPlayer player = PacketHandler.getPlayer(ctx);
        if (player != null) {
            TileEntity tile;
            World world = player.func_130014_f_();
            if (world.field_73011_w.getDimension() != message.dimension) {
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                world = server.func_71218_a(message.dimension);
            }
            if ((tile = world.func_175625_s(message.pos)) instanceof TileFluxCore) {
                TileFluxCore flux = (TileFluxCore)tile;
                PacketHandler.handlePacket(() -> {
                    IMessage returned = message.handler.handler.handlePacket(flux, player, message.tag);
                    if (returned != null && player instanceof EntityPlayerMP) {
                        PacketHandler.network.sendTo(returned, (EntityPlayerMP)player);
                    }
                }, ctx.netHandler);
            }
        }
        return null;
    }

    public static class TileMessage
    implements IMessage {
        public PacketTileType handler;
        public NBTTagCompound tag;
        public BlockPos pos;
        public int dimension;

        public TileMessage() {
        }

        public TileMessage(PacketTileType handler, NBTTagCompound tag, BlockPos pos, int dimension) {
            this.handler = handler;
            this.tag = tag;
            this.pos = pos;
            this.dimension = dimension;
        }

        public void fromBytes(ByteBuf buf) {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.dimension = buf.readInt();
            this.handler = PacketTileType.values()[buf.readInt()];
            this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.pos.func_177958_n());
            buf.writeInt(this.pos.func_177956_o());
            buf.writeInt(this.pos.func_177952_p());
            buf.writeInt(this.dimension);
            buf.writeInt(this.handler.ordinal());
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        }
    }
}

