/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.tileentity;

import com.mojang.authlib.GameProfile;
import fluxnetworks.FluxConfig;
import fluxnetworks.api.Coord4D;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.api.tileentity.IFluxConfigurable;
import fluxnetworks.api.tileentity.IFluxConnector;
import fluxnetworks.api.tileentity.ITileByteBuf;
import fluxnetworks.common.connection.FluxNetworkInvalid;
import fluxnetworks.common.connection.FluxNetworkServer;
import fluxnetworks.common.connection.FluxTransferHandler;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.core.FluxUtils;
import fluxnetworks.common.core.NBTType;
import fluxnetworks.common.data.FluxChunkManager;
import fluxnetworks.common.data.FluxNetworkData;
import fluxnetworks.common.item.ItemFluxConnector;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public abstract class TileFluxCore
extends TileEntity
implements IFluxConnector,
IFluxConfigurable,
ITickable,
ITileByteBuf {
    public HashSet<EntityPlayer> playerUsing = new HashSet();
    public String customName = "";
    public int networkID = -1;
    public UUID playerUUID = FluxUtils.UUID_DEFAULT;
    public int color = -1;
    public int folderID = -1;
    public int priority = 0;
    public long limit = FluxConfig.defaultLimit;
    public boolean surgeMode = false;
    public boolean disableLimit = false;
    public boolean connected = false;
    public byte[] connections = new byte[]{0, 0, 0, 0, 0, 0};
    public boolean chunkLoading = false;
    protected IFluxNetwork network = FluxNetworkInvalid.instance;
    protected boolean load = false;
    public Coord4D coord4D;

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.load) {
            FluxUtils.removeConnection(this, false);
            if (this.chunkLoading) {
                FluxChunkManager.releaseChunk(this.field_145850_b, new ChunkPos(this.field_174879_c));
            }
            this.load = false;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.field_145850_b.field_72995_K && this.load) {
            FluxUtils.removeConnection(this, true);
            this.load = false;
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.playerUsing.size() > 0) {
                this.sendPackets();
            }
            if (!this.load) {
                if (!FluxUtils.addConnection(this)) {
                    this.networkID = -1;
                    this.color = -1;
                }
                this.updateTransfers(EnumFacing.field_82609_l);
                this.sendPackets();
                this.load = true;
            }
        }
    }

    @Override
    public void connect(IFluxNetwork network) {
        this.network = network;
        this.networkID = network.getNetworkID();
        this.color = network.getSetting(NetworkSettings.NETWORK_COLOR);
        this.connected = true;
        this.sendPackets();
    }

    @Override
    public void disconnect(IFluxNetwork network) {
        if (network.getNetworkID() == this.getNetworkID()) {
            this.network = FluxNetworkInvalid.instance;
            this.networkID = -1;
            this.color = -1;
            this.connected = false;
            this.sendPackets();
        }
    }

    @Override
    public IFluxNetwork getNetwork() {
        return this.network;
    }

    @Override
    public int getNetworkID() {
        return this.networkID;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.writeCustomNBT(new NBTTagCompound(), NBTType.TILE_UPDATE));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readCustomNBT(pkt.func_148857_g(), NBTType.TILE_UPDATE);
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public void sendPackets() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeCustomNBT(compound, NBTType.ALL_SAVE);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readCustomNBT(compound, NBTType.ALL_SAVE);
    }

    @Override
    public NBTTagCompound writeCustomNBT(NBTTagCompound tag, NBTType type) {
        if (type == NBTType.ALL_SAVE || type == NBTType.TILE_UPDATE) {
            tag.func_74768_a("0", this.priority);
            tag.func_74772_a("1", this.limit);
            tag.func_74757_a("2", this.disableLimit);
            tag.func_74757_a("3", this.surgeMode);
            tag.func_74768_a("4", this.networkID);
            tag.func_186854_a("5", this.playerUUID);
            tag.func_74778_a("6", this.customName);
            tag.func_74768_a("7", this.color);
            tag.func_74757_a("8", this.connected);
            tag.func_74768_a("9", this.folderID);
            for (int i = 0; i < this.connections.length; ++i) {
                tag.func_74774_a('c' + String.valueOf(i), this.connections[i]);
            }
            tag.func_74772_a("buf", ((FluxTransferHandler)this.getTransferHandler()).buffer);
            tag.func_74757_a("l", this.chunkLoading);
        }
        if (type == NBTType.TILE_UPDATE) {
            this.getTransferHandler().writeNetworkedNBT(tag);
        }
        if (type == NBTType.TILE_DROP) {
            tag.func_74772_a("buffer", ((FluxTransferHandler)this.getTransferHandler()).buffer);
            tag.func_74768_a(ItemFluxConnector.PRIORITY, this.priority);
            tag.func_74772_a(ItemFluxConnector.LIMIT, this.limit);
            tag.func_74757_a(ItemFluxConnector.DISABLE_LIMIT, this.disableLimit);
            tag.func_74757_a(ItemFluxConnector.SURGE_MODE, this.surgeMode);
            tag.func_74768_a(FluxNetworkData.NETWORK_ID, this.networkID);
            tag.func_74778_a(ItemFluxConnector.CUSTOM_NAME, this.customName);
            tag.func_74768_a("folderID", this.folderID);
        }
        return tag;
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag, NBTType type) {
        if (type == NBTType.ALL_SAVE || type == NBTType.TILE_UPDATE) {
            this.priority = tag.func_74762_e("0");
            this.limit = tag.func_74763_f("1");
            this.disableLimit = tag.func_74767_n("2");
            this.surgeMode = tag.func_74767_n("3");
            this.networkID = tag.func_74762_e("4");
            this.playerUUID = tag.func_186857_a("5");
            this.customName = tag.func_74779_i("6");
            this.color = tag.func_74762_e("7");
            this.connected = tag.func_74767_n("8");
            this.folderID = tag.func_74762_e("9");
            for (int i = 0; i < this.connections.length; ++i) {
                this.connections[i] = tag.func_74771_c('c' + String.valueOf(i));
            }
            ((FluxTransferHandler)this.getTransferHandler()).buffer = tag.func_74763_f("buf");
            this.chunkLoading = tag.func_74767_n("l");
        }
        if (type == NBTType.TILE_UPDATE) {
            this.getTransferHandler().readNetworkedNBT(tag);
        }
        if (type == NBTType.TILE_DROP) {
            long k = tag.func_74763_f("buffer");
            ((FluxTransferHandler)this.getTransferHandler()).buffer = k > 0L ? k : ((FluxTransferHandler)this.getTransferHandler()).buffer;
            this.priority = tag.func_74762_e(ItemFluxConnector.PRIORITY);
            long l = tag.func_74763_f(ItemFluxConnector.LIMIT);
            this.limit = l > 0L ? l : this.limit;
            this.disableLimit = tag.func_74767_n(ItemFluxConnector.DISABLE_LIMIT);
            this.surgeMode = tag.func_74767_n(ItemFluxConnector.SURGE_MODE);
            int i = tag.func_74762_e(FluxNetworkData.NETWORK_ID);
            this.networkID = i > 0 ? i : this.networkID;
            String name = tag.func_74779_i(ItemFluxConnector.CUSTOM_NAME);
            this.customName = name.isEmpty() ? this.customName : name;
            this.folderID = tag.func_74762_e("folderID");
        }
    }

    @Override
    public boolean canAccess(EntityPlayer player) {
        if (!this.network.isInvalid()) {
            if (EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).equals(this.playerUUID)) {
                return true;
            }
            return this.network.getMemberPermission(player).canAccess();
        }
        return true;
    }

    @Override
    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 1: {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.customName);
                break;
            }
            case 2: {
                buf.writeInt(this.priority);
                break;
            }
            case 3: {
                buf.writeLong(this.limit);
                break;
            }
            case 4: {
                buf.writeBoolean(this.surgeMode);
                break;
            }
            case 5: {
                buf.writeBoolean(this.disableLimit);
            }
        }
    }

    @Override
    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 1: {
                this.customName = ByteBufUtils.readUTF8String((ByteBuf)buf);
                this.markLiteSettingChanged();
                break;
            }
            case 2: {
                this.priority = buf.readInt();
                this.sortNetworkConnections();
                break;
            }
            case 3: {
                this.limit = buf.readLong();
                this.markLiteSettingChanged();
                break;
            }
            case 4: {
                this.surgeMode = buf.readBoolean();
                this.sortNetworkConnections();
                break;
            }
            case 5: {
                this.disableLimit = buf.readBoolean();
                this.markLiteSettingChanged();
            }
        }
    }

    protected void sortNetworkConnections() {
        if (this.network instanceof FluxNetworkServer) {
            FluxNetworkServer fluxNetworkServer = (FluxNetworkServer)this.network;
            fluxNetworkServer.sortConnections = true;
            this.markLiteSettingChanged();
        }
    }

    protected void markLiteSettingChanged() {
        if (this.network instanceof FluxNetworkServer) {
            FluxNetworkServer fluxNetworkServer = (FluxNetworkServer)this.network;
            fluxNetworkServer.markLiteSettingChanged(this);
        }
    }

    @Override
    public NBTTagCompound copyConfiguration(NBTTagCompound config) {
        return FluxUtils.copyConfiguration(this, config);
    }

    @Override
    public void pasteConfiguration(NBTTagCompound config) {
        FluxUtils.pasteConfiguration(this, config);
    }

    @Override
    public World getDimension() {
        return this.field_145850_b;
    }

    @Override
    public UUID getConnectionOwner() {
        return this.playerUUID;
    }

    public void updateTransfers(EnumFacing ... facings) {
        this.getTransferHandler().updateTransfers(facings);
    }

    @Override
    public int getPriority() {
        return this.surgeMode ? Integer.MAX_VALUE : this.priority;
    }

    public void open(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            this.playerUsing.add(player);
            this.sendPackets();
        }
    }

    public void close(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            this.playerUsing.remove(player);
        }
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public boolean isChunkLoaded() {
        return !this.func_145837_r();
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean isForcedLoading() {
        return this.chunkLoading;
    }

    @Override
    public long getCurrentLimit() {
        return this.disableLimit ? Long.MAX_VALUE : this.limit;
    }

    @Override
    public int getActualPriority() {
        return this.priority;
    }

    @Override
    public long getActualLimit() {
        return this.limit;
    }

    @Override
    public int getFolderID() {
        return this.folderID;
    }

    @Override
    public Coord4D getCoords() {
        if (this.coord4D == null) {
            this.coord4D = new Coord4D(this);
        }
        return this.coord4D;
    }

    @Override
    public boolean getDisableLimit() {
        return this.disableLimit;
    }

    @Override
    public boolean getSurgeMode() {
        return this.surgeMode;
    }
}

