/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.tileentity;

import fluxnetworks.FluxConfig;
import fluxnetworks.api.ConnectionType;
import fluxnetworks.api.network.ITransferHandler;
import fluxnetworks.api.tileentity.IFluxEnergy;
import fluxnetworks.api.tileentity.IFluxStorage;
import fluxnetworks.common.connection.handler.SingleTransferHandler;
import fluxnetworks.common.connection.transfer.StorageTransfer;
import fluxnetworks.common.core.NBTType;
import fluxnetworks.common.data.FluxNetworkData;
import fluxnetworks.common.registry.RegistryBlocks;
import fluxnetworks.common.tileentity.TileFluxCore;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileFluxStorage
extends TileFluxCore
implements IFluxStorage,
IFluxEnergy {
    public final SingleTransferHandler handler = new SingleTransferHandler(this, new StorageTransfer(this));
    public static final int C = 1000000;
    public static final int D = -1000;
    public int energyStored;
    public int maxEnergyStorage;
    public int maxTransferRate;
    public ItemStack stack = ItemStack.field_190927_a;

    public TileFluxStorage() {
        this(FluxConfig.basicCapacity, FluxConfig.basicTransfer);
        this.customName = "Basic Storage";
        this.limit = FluxConfig.basicTransfer;
        this.stack = new ItemStack(RegistryBlocks.FLUX_STORAGE_1);
    }

    private TileFluxStorage(int maxEnergyStorage, int maxTransferRate) {
        this.maxEnergyStorage = maxEnergyStorage;
        this.maxTransferRate = maxTransferRate;
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.STORAGE;
    }

    @Override
    public ITransferHandler getTransferHandler() {
        return this.handler;
    }

    @Override
    public NBTTagCompound writeCustomNBT(NBTTagCompound tag, NBTType type) {
        super.writeCustomNBT(tag, type);
        tag.func_74768_a("energy", this.energyStored);
        return tag;
    }

    @Override
    public long addEnergy(long amount, boolean simulate) {
        long energyReceived = Math.min((long)(this.maxEnergyStorage - this.energyStored), Math.min((long)this.maxTransferRate, amount));
        if (!simulate) {
            this.energyStored = (int)((long)this.energyStored + energyReceived);
            this.sendPackets();
        }
        return energyReceived;
    }

    @Override
    public long removeEnergy(long amount, boolean simulate) {
        long energyExtracted = Math.min((long)this.energyStored, Math.min((long)this.maxTransferRate, amount));
        if (!simulate) {
            this.energyStored = (int)((long)this.energyStored - energyExtracted);
            this.sendPackets();
        }
        return energyExtracted;
    }

    @Override
    public long getEnergy() {
        return this.energyStored;
    }

    @Override
    public long getCurrentLimit() {
        return this.maxTransferRate;
    }

    @Override
    public int getPriority() {
        return Math.min(this.priority - 1000000, -1000);
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag, NBTType type) {
        super.readCustomNBT(tag, type);
        this.energyStored = tag.func_74762_e("energy");
    }

    public ItemStack writeStorageToDisplayStack(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound subTag = new NBTTagCompound();
        subTag.func_74768_a("energy", this.energyStored);
        subTag.func_74768_a(FluxNetworkData.NETWORK_ID, this.networkID);
        tag.func_74782_a("FluxData", (NBTBase)subTag);
        tag.func_74757_a("GuiColor", true);
        stack.func_77982_d(tag);
        return stack;
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.writeStorageToDisplayStack(this.stack);
    }

    public static class Gargantuan
    extends TileFluxStorage {
        public Gargantuan() {
            super(FluxConfig.gargantuanCapacity, FluxConfig.gargantuanTransfer);
            this.customName = "Gargantuan Storage";
            this.limit = FluxConfig.gargantuanTransfer;
            this.stack = new ItemStack(RegistryBlocks.FLUX_STORAGE_3);
        }
    }

    public static class Herculean
    extends TileFluxStorage {
        public Herculean() {
            super(FluxConfig.herculeanCapacity, FluxConfig.herculeanTransfer);
            this.customName = "Herculean Storage";
            this.limit = FluxConfig.herculeanTransfer;
            this.stack = new ItemStack(RegistryBlocks.FLUX_STORAGE_2);
        }
    }
}

