/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.block;

import epicsquid.mysticallib.LibRegistry;
import epicsquid.mysticallib.block.CustomStateMapper;
import epicsquid.mysticallib.block.IBlock;
import epicsquid.mysticallib.model.CustomModelBlock;
import epicsquid.mysticallib.model.CustomModelLoader;
import epicsquid.mysticallib.model.ICustomModeledObject;
import epicsquid.mysticallib.model.IModeledObject;
import epicsquid.mysticallib.model.block.BakedModelBlock;
import epicsquid.mysticallib.model.block.BakedModelWall;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWall;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWallBase
extends BlockWall
implements IBlock,
IModeledObject,
ICustomModeledObject {
    private Item itemBlock;
    public List<ItemStack> drops = null;
    private boolean isOpaque = false;
    private boolean isFlammable = false;
    protected boolean hasCustomModel = false;
    private BlockRenderLayer layer = BlockRenderLayer.SOLID;
    protected Block parent;
    public String name = "";

    public BlockWallBase(@Nonnull Block base, @Nonnull SoundType type, float hardness, @Nonnull String name) {
        super(base);
        this.func_149647_a(null);
        this.parent = base;
        this.name = name;
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149672_a(type);
        this.func_149713_g(0);
        this.func_149711_c(hardness);
        this.setOpacity(false);
        this.field_149787_q = false;
        this.itemBlock = (Item)new ItemBlock((Block)this).setRegistryName(LibRegistry.getActiveModid(), name);
    }

    @Nonnull
    public BlockWallBase setFlammable(boolean flammable) {
        this.isFlammable = flammable;
        return this;
    }

    @Nonnull
    public BlockWallBase setResistance(float resistance) {
        super.func_149752_b(resistance);
        return this;
    }

    @Nonnull
    public BlockWallBase setModelCustom(boolean custom) {
        this.hasCustomModel = custom;
        return this;
    }

    @Nonnull
    public BlockWallBase setHarvestReqs(@Nonnull String tool, int level) {
        this.setHarvestLevel(tool, level);
        return this;
    }

    @Nonnull
    public BlockWallBase setOpacity(boolean isOpaque) {
        this.isOpaque = isOpaque;
        return this;
    }

    @Nonnull
    public BlockWallBase setLayer(@Nonnull BlockRenderLayer layer) {
        this.layer = layer;
        return this;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return this.isOpaque;
    }

    public boolean hasCustomModel() {
        return this.hasCustomModel;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean isFlammable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return this.isFlammable || super.isFlammable(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.isFlammable ? 100 : super.getFlammability(world, pos, face);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        if (this.hasCustomModel) {
            ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new CustomStateMapper());
        }
        if (!this.hasCustomModel) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "handlers"));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "handlers"));
        }
    }

    public boolean canPlaceTorchOnTop(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return true;
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (tab == this.func_149708_J() || tab == CreativeTabs.field_78027_g) {
            list.add((Object)new ItemStack((Block)this, 1));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initCustomModel() {
        if (this.hasCustomModel) {
            ResourceLocation defaultTex = new ResourceLocation(this.parent.getRegistryName().func_110624_b() + ":blocks/" + this.parent.getRegistryName().func_110623_a());
            CustomModelLoader.blockmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":models/block/" + this.name), new CustomModelBlock(this.getModelClass(), defaultTex, defaultTex));
            CustomModelLoader.itemmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":" + this.name + "#handlers"), new CustomModelBlock(this.getModelClass(), defaultTex, defaultTex));
        }
    }

    @Nonnull
    protected Class<? extends BakedModelBlock> getModelClass() {
        return BakedModelWall.class;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return this.layer;
    }

    @Override
    @Nonnull
    public Item getItemBlock() {
        return this.itemBlock;
    }

    @Override
    public ItemBlock setItemBlock(ItemBlock block) {
        this.itemBlock = block;
        return block;
    }

    @Nonnull
    public Block getParent() {
        return this.parent;
    }
}

