/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IEntityStyle;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.api.IItemStyle;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ITextStyle;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.apiimpl.elements.ElementEntity;
import mcjty.theoneprobe.apiimpl.elements.ElementHorizontal;
import mcjty.theoneprobe.apiimpl.elements.ElementIcon;
import mcjty.theoneprobe.apiimpl.elements.ElementItemLabel;
import mcjty.theoneprobe.apiimpl.elements.ElementItemStack;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.apiimpl.elements.ElementText;
import mcjty.theoneprobe.apiimpl.elements.ElementVertical;
import mcjty.theoneprobe.apiimpl.styles.EntityStyle;
import mcjty.theoneprobe.apiimpl.styles.IconStyle;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import mcjty.theoneprobe.apiimpl.styles.TextStyle;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractElementPanel
implements IElement,
IProbeInfo {
    protected List<IElement> children = new ArrayList<IElement>();
    protected Integer borderColor;
    protected int spacing;
    protected ElementAlignment alignment;
    protected IProbeConfig overriddenConfig;

    @Override
    public void render(int x, int y) {
        if (this.borderColor != null) {
            int w = this.getWidth();
            int h = this.getHeight();
            RenderHelper.drawHorizontalLine(x, y, x + w - 1, this.borderColor);
            RenderHelper.drawHorizontalLine(x, y + h - 1, x + w - 1, this.borderColor);
            RenderHelper.drawVerticalLine(x, y, y + h - 1, this.borderColor);
            RenderHelper.drawVerticalLine(x + w - 1, y, y + h, this.borderColor);
        }
    }

    public AbstractElementPanel(Integer borderColor, int spacing, ElementAlignment alignment) {
        this.borderColor = borderColor;
        this.spacing = spacing;
        this.alignment = alignment;
    }

    public AbstractElementPanel(ByteBuf buf) {
        this.children = ProbeInfo.createElements(buf);
        if (buf.readBoolean()) {
            this.borderColor = buf.readInt();
        }
        this.spacing = buf.readShort();
        this.alignment = ElementAlignment.values()[buf.readShort()];
    }

    @Override
    public void toBytes(ByteBuf buf) {
        ProbeInfo.writeElements(this.children, buf);
        if (this.borderColor != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.borderColor.intValue());
        } else {
            buf.writeBoolean(false);
        }
        buf.writeShort(this.spacing);
        buf.writeShort(this.alignment.ordinal());
    }

    @Override
    public IProbeInfo icon(ResourceLocation icon, int u, int v, int w, int h) {
        return this.icon(icon, u, v, w, h, new IconStyle());
    }

    @Override
    public IProbeInfo icon(ResourceLocation icon, int u, int v, int w, int h, IIconStyle style) {
        this.children.add(new ElementIcon(icon, u, v, w, h, style));
        return this;
    }

    @Override
    public IProbeInfo text(String text) {
        this.children.add(new ElementText(text));
        return this;
    }

    @Override
    public IProbeInfo text(String text, ITextStyle style) {
        this.children.add(new ElementText(text));
        return this;
    }

    @Override
    public IProbeInfo itemLabel(ItemStack stack, ITextStyle style) {
        this.children.add(new ElementItemLabel(stack));
        return this;
    }

    @Override
    public IProbeInfo itemLabel(ItemStack stack) {
        this.children.add(new ElementItemLabel(stack));
        return this;
    }

    @Override
    public IProbeInfo entity(String entityName, IEntityStyle style) {
        this.children.add(new ElementEntity(entityName, style));
        return this;
    }

    @Override
    public IProbeInfo entity(String entityName) {
        return this.entity(entityName, (IEntityStyle)new EntityStyle());
    }

    @Override
    public IProbeInfo entity(Entity entity, IEntityStyle style) {
        this.children.add(new ElementEntity(entity, style));
        return this;
    }

    @Override
    public IProbeInfo entity(Entity entity) {
        return this.entity(entity, (IEntityStyle)new EntityStyle());
    }

    @Override
    public IProbeInfo item(ItemStack stack, IItemStyle style) {
        this.children.add(new ElementItemStack(stack, style));
        return this;
    }

    @Override
    public IProbeInfo item(ItemStack stack) {
        return this.item(stack, new ItemStyle());
    }

    @Override
    public IProbeInfo progress(int current, int max) {
        return this.progress(current, max, (IProgressStyle)new ProgressStyle());
    }

    @Override
    public IProbeInfo progress(int current, int max, IProgressStyle style) {
        this.children.add(new ElementProgress(current, max, style));
        return this;
    }

    @Override
    public IProbeInfo progress(long current, long max) {
        return this.progress(current, max, (IProgressStyle)new ProgressStyle());
    }

    @Override
    public IProbeInfo progress(long current, long max, IProgressStyle style) {
        this.children.add(new ElementProgress(current, max, style));
        return this;
    }

    @Override
    public IProbeInfo horizontal(ILayoutStyle style) {
        ElementHorizontal e = new ElementHorizontal(style.getBorderColor(), style.getSpacing(), style.getAlignment());
        this.children.add(e);
        return e;
    }

    @Override
    public IProbeInfo horizontal() {
        ElementHorizontal e = new ElementHorizontal(null, this.spacing, ElementAlignment.ALIGN_TOPLEFT);
        this.children.add(e);
        return e;
    }

    @Override
    public IProbeInfo vertical(ILayoutStyle style) {
        ElementVertical e = new ElementVertical(style.getBorderColor(), style.getSpacing(), style.getAlignment());
        this.children.add(e);
        return e;
    }

    @Override
    public IProbeInfo vertical() {
        ElementVertical e = new ElementVertical(null, 2, ElementAlignment.ALIGN_TOPLEFT);
        this.children.add(e);
        return e;
    }

    @Override
    public IProbeInfo element(IElement element) {
        this.children.add(element);
        return this;
    }

    @Override
    public ILayoutStyle defaultLayoutStyle() {
        return new LayoutStyle();
    }

    @Override
    public IProgressStyle defaultProgressStyle() {
        return new ProgressStyle();
    }

    @Override
    public ITextStyle defaultTextStyle() {
        return new TextStyle();
    }

    @Override
    public IItemStyle defaultItemStyle() {
        return new ItemStyle();
    }

    @Override
    public IEntityStyle defaultEntityStyle() {
        return new EntityStyle();
    }

    @Override
    public IIconStyle defaultIconStyle() {
        return new IconStyle();
    }
}

