/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.zenscript;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import leviathan143.loottweaker.common.lib.DataToJSONConverter;
import leviathan143.loottweaker.common.lib.LootUtils;
import leviathan143.loottweaker.common.lib.ZenScriptUtils;
import leviathan143.loottweaker.common.zenscript.ZenLootConditionWrapper;
import net.minecraft.world.storage.loot.conditions.KilledByPlayer;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.conditions.RandomChanceWithLooting;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="loottweaker.vanilla.loot.Conditions")
public class ConditionHelper {
    @ZenMethod
    public static ZenLootConditionWrapper randomChance(float chance) {
        return new ZenLootConditionWrapper((LootCondition)new RandomChance(chance));
    }

    @ZenMethod
    public static ZenLootConditionWrapper randomChanceWithLooting(float chance, float lootingMult) {
        return new ZenLootConditionWrapper((LootCondition)new RandomChanceWithLooting(chance, lootingMult));
    }

    @ZenMethod
    public static ZenLootConditionWrapper killedByPlayer() {
        return new ZenLootConditionWrapper((LootCondition)new KilledByPlayer(false));
    }

    @ZenMethod
    public static ZenLootConditionWrapper killedByNonPlayer() {
        return new ZenLootConditionWrapper((LootCondition)new KilledByPlayer(true));
    }

    @ZenMethod
    public static ZenLootConditionWrapper parse(IData json) {
        if (!ZenScriptUtils.checkIsMap(json)) {
            return null;
        }
        return new ZenLootConditionWrapper(LootUtils.parseJSONCondition(DataToJSONConverter.from(json)));
    }
}

